/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.metricsreporter.opentelemetry;

import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import io.confluent.cruisecontrol.metricsreporter.opentelemetry.AbstractBuilder;
import io.confluent.cruisecontrol.metricsreporter.opentelemetry.ProtoResourceMetricsParser;
import io.confluent.cruisecontrol.metricsreporter.opentelemetry.ReadOnlyMessage;
import io.opentelemetry.proto.metrics.v1.ScopeMetrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SbcResourceMetrics
extends ReadOnlyMessage {
    public static final String DEFAULT_BROKER_ID = "";
    private static final SbcResourceMetrics DEFAULT_INSTANCE = new SbcResourceMetrics(Collections.emptyList(), "");
    public static final ProtoResourceMetricsParser PARSER = new ProtoResourceMetricsParser();
    private final String brokerId;
    private final List<ScopeMetrics> scopeMetrics;

    public SbcResourceMetrics(List<ScopeMetrics> scopeMetrics, String brokerId) {
        this.scopeMetrics = scopeMetrics;
        this.brokerId = brokerId;
    }

    public String brokerId() {
        return this.brokerId;
    }

    public List<ScopeMetrics> scopeMetrics() {
        return this.scopeMetrics;
    }

    public Parser<? extends MessageLite> getParserForType() {
        return PARSER;
    }

    public MessageLite.Builder newBuilderForType() {
        return new SbcResourceMetricsBuilder();
    }

    public MessageLite getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public boolean isInitialized() {
        return this.scopeMetrics != null && this.brokerId != null;
    }

    private static class SbcResourceMetricsBuilder
    extends AbstractBuilder<SbcResourceMetrics> {
        private List<ScopeMetrics> scopeMetrics = new ArrayList<ScopeMetrics>();
        private String brokerId = "";

        private SbcResourceMetricsBuilder() {
        }

        public MessageLite.Builder clear() {
            this.scopeMetrics = new ArrayList<ScopeMetrics>();
            this.brokerId = SbcResourceMetrics.DEFAULT_BROKER_ID;
            return this;
        }

        public MessageLite buildPartial() {
            return new SbcResourceMetrics(this.scopeMetrics, this.brokerId);
        }

        public MessageLite.Builder mergeFrom(MessageLite other) {
            if (other instanceof SbcResourceMetrics) {
                SbcResourceMetrics sbc = (SbcResourceMetrics)other;
                this.scopeMetrics.addAll(sbc.scopeMetrics);
                this.brokerId = sbc.brokerId;
            }
            return this;
        }

        public MessageLite getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public boolean isInitialized() {
            return this.scopeMetrics != null && this.brokerId != null;
        }
    }
}

