/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer;

import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.config.SbcGoalsConfig;
import com.linkedin.kafka.cruisecontrol.config.SbcGoalsConfigDelta;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalCallback;
import io.confluent.databalancer.BalancerEnabledConfig;
import io.confluent.databalancer.BrokerChangeEvent;
import io.confluent.databalancer.ConfluentDataBalanceEngine;
import io.confluent.databalancer.DataBalanceEngine;
import io.confluent.databalancer.DataBalanceEngineContext;
import io.confluent.databalancer.DatabalancerUtils;
import io.confluent.databalancer.EngineInitializationContext;
import io.confluent.databalancer.NoOpDataBalanceEngine;
import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import io.confluent.databalancer.operation.BalancerStatusStateMachine;
import io.confluent.databalancer.operation.BalancerStatusTracker;
import io.confluent.databalancer.operation.BrokerAdditionStateMachine;
import io.confluent.databalancer.operation.BrokerRemovalCancellationMode;
import io.confluent.databalancer.operation.BrokerRemovalCancellationProposal;
import io.confluent.databalancer.operation.BrokerRemovalExclusionCancellationData;
import io.confluent.databalancer.operation.BrokerRemovalStateMachine;
import io.confluent.databalancer.operation.BrokerRemovalStateTracker;
import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import io.confluent.databalancer.persistence.BrokerRemovalStateRecord;
import io.confluent.databalancer.utils.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kafka.common.AliveBrokersMetadata;
import kafka.common.BalancerStatusDescriptionInternal;
import kafka.common.BrokerRemovalDescriptionInternal;
import kafka.common.BrokerRemovalRequest;
import kafka.common.EvenClusterLoadPlanInternal;
import kafka.common.EvenClusterLoadStatusDescriptionInternal;
import kafka.controller.ClusterBalanceManager;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.BalancerJbodEnabledMisconfigurationException;
import org.apache.kafka.common.errors.BalancerMisconfigurationException;
import org.apache.kafka.common.errors.BalancerOfflineException;
import org.apache.kafka.common.errors.BrokerRemovalCanceledException;
import org.apache.kafka.common.errors.InvalidBrokerRemovalException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.ConfigurationsImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class KafkaDataBalanceManager {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaDataBalanceManager.class);
    public static final String BROKER_REMOVAL_STATE_METRIC_NAME = "BrokerRemovalOperationState";
    public static final String BALANCER_STATE_METRIC_NAME = "BalancerState";
    public static final String BALANCER_DEFAULT_STATE = "NOT_CONTROLLER";
    private KafkaConfig kafkaConfig;
    private DataBalanceEngine balanceEngine;
    BalancerStatusTracker balancerStatusTracker;
    private final DataBalanceEngineFactory dbeFactory;
    private final DataBalancerMetricsRegistry dataBalancerMetricsRegistry;
    private final long taskHistoryRetentionPeriodMs;
    private final BalancerEnabledConfig balancerEnabledConfig;
    private final Optional<Endpoint> bootstrapServerEndpointOpt;
    private final int brokerId;
    private final Time time;
    private final AtomicReference<String> balancerStateReference = new AtomicReference<String>("NOT_CONTROLLER");

    public KafkaDataBalanceManager(KafkaConfig kafkaConfig, Optional<Endpoint> bootstrapServerEndpointOpt, DataBalancerMetricsRegistry dbMetricsRegistry, Time time) {
        this(kafkaConfig, bootstrapServerEndpointOpt, new DataBalanceEngineFactory(dbMetricsRegistry, kafkaConfig), dbMetricsRegistry, time, null);
    }

    KafkaDataBalanceManager(KafkaConfig kafkaConfig, DataBalanceEngineFactory dbeFactory, DataBalancerMetricsRegistry metricsRegistry, Time time, BalancerStatusTracker balancerStatusTracker) {
        this(kafkaConfig, Optional.empty(), dbeFactory, metricsRegistry, time, balancerStatusTracker);
    }

    KafkaDataBalanceManager(KafkaConfig kafkaConfig, Optional<Endpoint> bootstrapServerEndpointOpt, DataBalanceEngineFactory dbeFactory, DataBalancerMetricsRegistry metricsRegistry, Time time, BalancerStatusTracker balancerStatusTracker) {
        this.kafkaConfig = Objects.requireNonNull(kafkaConfig, "KafkaConfig must be non-null");
        this.bootstrapServerEndpointOpt = Objects.requireNonNull(bootstrapServerEndpointOpt, "Bootstrap server endpoint optional cannot be null");
        this.dbeFactory = Objects.requireNonNull(dbeFactory, "DataBalanceEngineFactory must be non-null");
        this.dataBalancerMetricsRegistry = Objects.requireNonNull(metricsRegistry, "MetricsRegistry must be non-null");
        this.time = time;
        this.balanceEngine = dbeFactory.getInactiveDataBalanceEngine();
        this.balancerEnabledConfig = new BalancerEnabledConfig(kafkaConfig.confluentConfig().selfBalanceEnable(), kafkaConfig.confluentConfig().selfBalanceDemotionSupportEnabled());
        if (this.balancerEnabledConfig.isConfiguredAsEnabled()) {
            this.enableDatabalancerMetric();
        }
        this.brokerId = DatabalancerUtils.getBrokerId(kafkaConfig);
        if (balancerStatusTracker == null) {
            this.dataBalancerMetricsRegistry.newGauge(ConfluentDataBalanceEngine.class, BALANCER_STATE_METRIC_NAME, this.balancerStateReference::get, true, DataBalancerMetricsRegistry.brokerIdMetricTag(this.brokerId));
            this.balancerStatusTracker = new BalancerStatusTracker(this.brokerId, this.balancerStateReference, time);
        } else {
            this.balancerStatusTracker = balancerStatusTracker;
        }
        this.taskHistoryRetentionPeriodMs = DatabalancerUtils.taskHistoryRetentionMs(kafkaConfig);
        KafkaDataBalanceManager.enableBrokerIdLogging(this.brokerId);
    }

    private static void enableBrokerIdLogging(Integer brokerId) {
        MDC.put((String)"brokerId", (String)brokerId.toString());
    }

    public static ConfigResource balancerConfigResource() {
        return new ConfigResource(ConfigResource.Type.BROKER, "");
    }

    public synchronized void onElection(AliveBrokersMetadata aliveBrokersMetadata, Optional<ConfigurationsImage> configurationsImageOptional) {
        List<String> logDirs;
        ConfigurationsImage configsImage;
        Object isEnabledObj;
        KafkaDataBalanceManager.enableBrokerIdLogging(this.brokerId);
        this.balanceEngine = this.dbeFactory.getActiveDataBalanceEngine();
        if (!this.balancerStatusTracker.isInitialized()) {
            this.balancerStatusTracker.initialize();
        }
        boolean isEnabledBefore = this.balancerEnabledConfig.shouldBeEnabled();
        if (configurationsImageOptional.isPresent() && (isEnabledObj = ConfigDef.parseType((String)"confluent.balancer.enable", (Object)(configsImage = configurationsImageOptional.get()).configProperties(KafkaDataBalanceManager.balancerConfigResource()).get("confluent.balancer.enable"), (ConfigDef.Type)ConfigDef.Type.BOOLEAN)) != null) {
            boolean isEnabled = (Boolean)isEnabledObj;
            this.balancerEnabledConfig.maybeUpdateConfigValue(isEnabled);
        }
        this.balancerEnabledConfig.maybeUpdateDemotedBrokers(!aliveBrokersMetadata.demotedBrokers().isEmpty());
        if (!this.balancerEnabledConfig.shouldBeEnabled()) {
            this.balancerStatusTracker.registerEvent(BalancerStatusStateMachine.BalancerEvent.BALANCER_DISABLED);
            LOG.info("DataBalancer: Skipping DataBalancer startup. BalancerEnabledConfig: {}", (Object)this.balancerEnabledConfig);
            return;
        }
        if (!isEnabledBefore) {
            this.enableDatabalancerMetric();
        }
        if ((logDirs = DatabalancerUtils.getConfiguredLogDirs(this.kafkaConfig)) == null || logDirs.size() == 0) {
            throw new ConfigException("Broker configured with null or empty log directory");
        }
        if (logDirs.size() > 1) {
            BalancerJbodEnabledMisconfigurationException e = new BalancerJbodEnabledMisconfigurationException("SBC configured with multiple log directories");
            this.balancerStatusTracker.registerEvent(BalancerStatusStateMachine.BalancerEvent.JBOD_ENABLED, (Exception)e);
            return;
        }
        this.balancerStatusTracker.registerEvent(BalancerStatusStateMachine.BalancerEvent.INITIALIZING_CRUISE_CONTROL, (Exception)null);
        LOG.info("DataBalancer: Activating SBC with {}", (Object)aliveBrokersMetadata);
        this.activateEngine(Optional.of(aliveBrokersMetadata));
    }

    public boolean isActive() {
        return this.balanceEngine.isActive();
    }

    public BalancerStatusTracker balancerStatusTracker() {
        return this.balancerStatusTracker;
    }

    public synchronized void onResignation() {
        try {
            KafkaDataBalanceManager.enableBrokerIdLogging(this.brokerId);
            BrokerRemovalCancellationProposal.BrokerRemovalCancellationProposalBuilder cancellationRequestBuilder = new BrokerRemovalCancellationProposal.BrokerRemovalCancellationProposalBuilder().setCancellationEvent(BrokerRemovalStateMachine.BrokerRemovalEvent.BALANCER_RESIGNED).setCancellationMode(BrokerRemovalCancellationMode.TRANSIENT_CANCELLATION);
            this.tryCancelAllExistingBrokerRemovals(cancellationRequestBuilder);
            this.deactivateEngine(BalancerStatusStateMachine.BalancerEvent.CONTROLLER_FAILS_OVER);
            this.balanceEngine = this.dbeFactory.getInactiveDataBalanceEngine();
            this.balancerStatusTracker = new BalancerStatusTracker((int)DatabalancerUtils.getBrokerId(this.kafkaConfig), this.balancerStateReference, this.time);
        }
        catch (RuntimeException e) {
            LOG.error("Error occurred during DataBalanceManager resignation", (Throwable)e);
        }
    }

    public synchronized void shutdown() {
        try {
            this.dbeFactory.shutdown(this.kafkaConfig);
        }
        catch (InterruptedException e) {
            LOG.warn("DataBalanceManager interrupted during shutdown.");
        }
    }

    public synchronized void maybeEnableOrDisable(Boolean newIsEnabledConfigValue, Optional<AliveBrokersMetadata> aliveBrokersMetadataOptional) {
        boolean shouldChange;
        if (aliveBrokersMetadataOptional.isPresent()) {
            boolean demotedBrokersExist = !aliveBrokersMetadataOptional.get().demotedBrokers().isEmpty();
            shouldChange = this.balancerEnabledConfig.maybeUpdate(newIsEnabledConfigValue, demotedBrokersExist);
        } else {
            shouldChange = this.balancerEnabledConfig.maybeUpdateConfigValue(newIsEnabledConfigValue);
        }
        if (shouldChange) {
            this.doEnableOrDisable(this.balancerEnabledConfig.shouldBeEnabled(), aliveBrokersMetadataOptional);
        }
    }

    public synchronized boolean maybeEnableOrDisable(AliveBrokersMetadata aliveBrokersMetadata) {
        boolean demotedBrokersExist = !aliveBrokersMetadata.demotedBrokers().isEmpty();
        boolean shouldChange = this.balancerEnabledConfig.maybeUpdateDemotedBrokers(demotedBrokersExist);
        if (shouldChange) {
            this.doEnableOrDisable(this.balancerEnabledConfig.shouldBeEnabled(), Optional.of(aliveBrokersMetadata));
        }
        return shouldChange;
    }

    void doEnableOrDisable(boolean toEnable, Optional<AliveBrokersMetadata> aliveBrokersMetadataOptional) {
        if (toEnable) {
            LOG.info("Enabling Data Balancer ({})", (Object)this.balancerEnabledConfig);
            this.enableDatabalancerMetric();
            this.activateEngine(aliveBrokersMetadataOptional, EngineInitializationContext.EngineStartupType.ON_ENABLE);
        } else {
            LOG.info("Disabling Data Balancer ({})", (Object)this.balancerEnabledConfig);
            BrokerRemovalCancellationProposal.BrokerRemovalCancellationProposalBuilder cancellationRequestBuilder = new BrokerRemovalCancellationProposal.BrokerRemovalCancellationProposalBuilder().setCancellationEvent(BrokerRemovalStateMachine.BrokerRemovalEvent.BALANCER_DISABLED);
            this.tryCancelAllExistingBrokerRemovals(cancellationRequestBuilder);
            this.deactivateEngine(BalancerStatusStateMachine.BalancerEvent.BALANCER_DISABLED);
            this.disableDatabalancerMetric();
        }
    }

    public synchronized void handleThrottleConfig(Long throttle) {
        LOG.info("Setting broker throttle to {}", (Object)throttle);
        this.balanceEngine.updateThrottle(throttle);
    }

    public synchronized void handleHealModeConfig(boolean shouldEnableImbalanceAutoHeal) {
        LOG.info("Setting DataBalancer auto heal mode to {}", (Object)shouldEnableImbalanceAutoHeal);
        this.balanceEngine.setAutoHealMode(shouldEnableImbalanceAutoHeal);
    }

    public synchronized void handleCellEnabledConfigUpdate(Boolean cellEnabledConfig) {
        LOG.info("Setting cell enabled property to {}", (Object)cellEnabledConfig);
        this.balanceEngine.updateConfigPermanently("confluent.cells.enable", cellEnabledConfig);
    }

    public synchronized void handleExcludeTopicsConfig(List<String> excludedNames, List<String> excludedPrefixes, String updatedRegex) {
        LOG.debug("Setting excluded topics to {} and excluded prefixes to {}", excludedNames, excludedPrefixes);
        this.balanceEngine.updateConfigPermanently("topics.excluded.from.partition.movement", updatedRegex);
    }

    public synchronized void handleGoalViolationDelayOnNewBrokersConfig(long newGoalViolationDelayOnNewBrokers) {
        LOG.debug("Setting goal violation delay on new brokers to {}", (Object)newGoalViolationDelayOnNewBrokers);
        this.balanceEngine.updateConfigPermanently("goal.violation.delay.on.new.brokers.ms", newGoalViolationDelayOnNewBrokers);
    }

    public synchronized void handleGoalConfigUpdate(SbcGoalsConfigDelta sbcGoalsConfigDelta) throws BalancerMisconfigurationException {
        LOG.info("Applying DataBalancer goals delta ({})", (Object)sbcGoalsConfigDelta);
        this.balanceEngine.updateConfigPermanently(sbcGoalsConfigDelta);
    }

    public synchronized void updateConfig(KafkaConfig oldConfig, KafkaConfig newConfig) {
        long oldGoalViolationDelayOnNewBrokers;
        long newGoalViolationDelayOnNewBrokers;
        this.updateConfig(newConfig);
        boolean newEnabledValue = newConfig.confluentConfig().selfBalanceEnable();
        this.maybeEnableOrDisable(newEnabledValue, Optional.empty());
        Long throttle = this.kafkaConfig.getLong("confluent.balancer.throttle.bytes.per.second");
        if (!throttle.equals(oldConfig.getLong("confluent.balancer.throttle.bytes.per.second"))) {
            this.handleThrottleConfig(throttle);
        }
        if (!this.kafkaConfig.getString("confluent.balancer.heal.uneven.load.trigger").equals(oldConfig.getString("confluent.balancer.heal.uneven.load.trigger"))) {
            boolean shouldEnableImbalanceAutoHeal = DatabalancerUtils.anyUnevenLoadEnabled(this.kafkaConfig);
            this.handleHealModeConfig(shouldEnableImbalanceAutoHeal);
        }
        if (!this.kafkaConfig.getBoolean("confluent.cells.enable").equals(oldConfig.getBoolean("confluent.cells.enable"))) {
            Boolean cellsEnabled = this.kafkaConfig.getBoolean("confluent.cells.enable");
            this.handleCellEnabledConfigUpdate(cellsEnabled);
        }
        List excludedNames = this.kafkaConfig.getList("confluent.balancer.exclude.topic.names");
        List excludedPrefixes = this.kafkaConfig.getList("confluent.balancer.exclude.topic.prefixes");
        if (!excludedNames.equals(oldConfig.getList("confluent.balancer.exclude.topic.names")) || !excludedPrefixes.equals(oldConfig.getList("confluent.balancer.exclude.topic.prefixes"))) {
            String updatedRegex = DatabalancerUtils.generateCcTopicExclusionRegex(excludedNames, excludedPrefixes);
            this.handleExcludeTopicsConfig(excludedNames, excludedPrefixes, updatedRegex);
        }
        if ((newGoalViolationDelayOnNewBrokers = newConfig.getLong("confluent.balancer.goal.violation.delay.on.new.brokers.ms").longValue()) != (oldGoalViolationDelayOnNewBrokers = oldConfig.getLong("confluent.balancer.goal.violation.delay.on.new.brokers.ms").longValue())) {
            this.handleGoalViolationDelayOnNewBrokersConfig(newGoalViolationDelayOnNewBrokers);
        }
        this.updateSbcGoalsConfig(oldConfig, newConfig);
    }

    public synchronized void updateConfig(KafkaConfig newConfig) {
        this.kafkaConfig = newConfig;
    }

    public synchronized KafkaConfig updateKafkaConfig(Map<String, Object> changedConfigs, Set<String> deletedConfigs, KafkaConfig originalConfig) {
        HashMap<String, Object> updatedConfigs = new HashMap<String, Object>();
        this.kafkaConfig.props().forEach((key, value) -> updatedConfigs.put((String)key, value));
        updatedConfigs.putAll(changedConfigs);
        deletedConfigs.forEach(config -> updatedConfigs.put((String)config, originalConfig.get(config)));
        KafkaConfig newConfig = new KafkaConfig(updatedConfigs, false);
        this.updateConfig(newConfig);
        return newConfig;
    }

    private synchronized void updateSbcGoalsConfig(KafkaConfig oldConfig, KafkaConfig newConfig) {
        SbcGoalsConfigDelta sbcGoalsConfigDelta;
        List newIncrementalBalancingGoals;
        List oldIncrementalBalancingGoals;
        Boolean newIncrementalBalancingEnabled;
        Boolean oldIncrementalBalancingEnabled;
        List newRebalancingGoals;
        List oldRebalancingGoals;
        List newTriggeringGoals;
        SbcGoalsConfigDelta.Builder sbcGoalsConfigDeltaBuilder = SbcGoalsConfigDelta.builder();
        List oldTriggeringGoals = oldConfig.getList("confluent.balancer.triggering.goals");
        if (!oldTriggeringGoals.equals(newTriggeringGoals = newConfig.getList("confluent.balancer.triggering.goals"))) {
            sbcGoalsConfigDeltaBuilder.newTriggeringGoals(newTriggeringGoals);
        }
        if (!(oldRebalancingGoals = oldConfig.getList("confluent.balancer.rebalancing.goals")).equals(newRebalancingGoals = newConfig.getList("confluent.balancer.rebalancing.goals"))) {
            sbcGoalsConfigDeltaBuilder.newRebalancingGoals(newRebalancingGoals);
        }
        if ((oldIncrementalBalancingEnabled = oldConfig.getBoolean("confluent.balancer.incremental.balancing.enabled")) != (newIncrementalBalancingEnabled = newConfig.getBoolean("confluent.balancer.incremental.balancing.enabled"))) {
            sbcGoalsConfigDeltaBuilder.newIncrementalBalancingEnabled(newIncrementalBalancingEnabled);
        }
        if (!(oldIncrementalBalancingGoals = oldConfig.getList("confluent.balancer.incremental.balancing.goals")).equals(newIncrementalBalancingGoals = newConfig.getList("confluent.balancer.incremental.balancing.goals"))) {
            sbcGoalsConfigDeltaBuilder.newIncrementalBalancingGoals(newIncrementalBalancingGoals);
        }
        if ((sbcGoalsConfigDelta = sbcGoalsConfigDeltaBuilder.build()).hasUpdate()) {
            this.handleGoalConfigUpdate(sbcGoalsConfigDelta);
        }
    }

    public void onBrokersStartup(Set<Integer> emptyBrokers, Set<Integer> newBrokers, AliveBrokersMetadata brokersMetadata) {
        if (newBrokers.isEmpty()) {
            return;
        }
        if (!this.balanceEngine.isActive()) {
            LOG.warn("Notified of broker additions (empty broker ids {}, new brokers {}) but DataBalancer is disabled -- ignoring for now", emptyBrokers, newBrokers);
            return;
        }
        Set<Integer> brokersNotBeingAdded = newBrokers.stream().filter(b -> !emptyBrokers.contains(b)).collect(Collectors.toSet());
        LOG.info("Notify new broker arrival: {}, non-empty brokers: {}, empty brokers: {}", new Object[]{newBrokers, brokersNotBeingAdded, emptyBrokers});
        this.balanceEngine.notifyBrokerChange(brokersNotBeingAdded, BrokerChangeEvent.ONLINE_NORMAL_BROKER);
        this.tryCancelExistingBrokerRemovals(newBrokers, BrokerRemovalStateMachine.BrokerRemovalEvent.BROKER_RESTARTED);
        if (emptyBrokers.isEmpty()) {
            return;
        }
        this.balanceEngine.notifyBrokerChange(emptyBrokers, BrokerChangeEvent.ONLINE_ADDING_BROKER);
        HashSet<Integer> addingBrokers = new HashSet<Integer>(this.balanceEngine.getDataBalanceEngineContext().additionContext().brokersBeingAdded());
        addingBrokers.addAll(emptyBrokers);
        String operationUid = String.format("addBroker-%d", this.time.milliseconds());
        this.balanceEngine.addBrokers(addingBrokers, operationUid, brokersMetadata);
    }

    public void onBrokersFailure(Set<Integer> deadBrokers) {
        LOG.info("Notify broker failure: {}", deadBrokers);
        this.balanceEngine.notifyBrokerChange(deadBrokers, BrokerChangeEvent.DEAD_BROKER);
    }

    public void onAlteredExclusions(Set<Integer> newExclusions, Set<Integer> removedExclusions) {
        BrokerRemovalCancellationProposal.BrokerRemovalCancellationProposalBuilder cancellationRequestBuilder;
        if (!this.balanceEngine.isActive()) {
            LOG.debug("Notified of replica placement exclusion alterations but will not act on them as the DataBalancer is not initialized (removed exclusions: ({}); added exclusions: ({}))", removedExclusions, newExclusions);
            return;
        }
        LOG.info("Notified of replica placement exclusion alterations - removed exclusions: ({}); added exclusions: ({})", removedExclusions, newExclusions);
        if (!newExclusions.isEmpty()) {
            this.overrideAllPendingBrokerAdditions(BrokerAdditionStateMachine.BrokerAdditionEvent.BROKER_EXCLUSION_DETECTED.withBrokers(newExclusions), String.format("altered replica exclusion (new exclusions: [%s], removed exclusions: [%s])", newExclusions, removedExclusions));
            cancellationRequestBuilder = new BrokerRemovalCancellationProposal.BrokerRemovalCancellationProposalBuilder().setCancellationEvent(BrokerRemovalStateMachine.BrokerRemovalEvent.EXCLUSION_ADDED).setModifiedExclusionsData(new BrokerRemovalExclusionCancellationData(ExclusionOp.OpType.SET, newExclusions));
            boolean removalsCancelled = this.tryCancelAllExistingBrokerRemovals(cancellationRequestBuilder);
            long numActiveRemovals = this.balanceEngine.getDataBalanceEngineContext().getBrokerRemovalsStateTrackers().values().stream().filter(stateTracker -> !stateTracker.currentState().isTerminal()).count();
            if (numActiveRemovals == 0L || removalsCancelled) {
                this.balanceEngine.notifyBrokerChange(newExclusions, BrokerChangeEvent.EXCLUDED_FOR_REPLICA_PLACEMENT);
            }
        }
        if (!removedExclusions.isEmpty()) {
            cancellationRequestBuilder = new BrokerRemovalCancellationProposal.BrokerRemovalCancellationProposalBuilder().setCancellationEvent(BrokerRemovalStateMachine.BrokerRemovalEvent.EXCLUSION_REMOVED).setModifiedExclusionsData(new BrokerRemovalExclusionCancellationData(ExclusionOp.OpType.DELETE, removedExclusions));
            this.tryCancelAllExistingBrokerRemovals(cancellationRequestBuilder);
            this.balanceEngine.notifyBrokerChange(removedExclusions, BrokerChangeEvent.REMOVED_REPLICA_EXCLUSION);
        }
    }

    public synchronized void onBrokerHealthChange(Set<Integer> newlyPromotedBrokers, Set<Integer> newlyDemotedBrokers, AliveBrokersMetadata aliveBrokersMetadata) {
        LOG.info("Processing broker health change change. SBC will be enabled or disabled if necessary.");
        boolean isSbcStatusChanged = this.maybeEnableOrDisable(aliveBrokersMetadata);
        if (isSbcStatusChanged) {
            LOG.debug("Notified of leadership priority change but will not act on them due to sbc disable(demoted brokers: ({}); promoted brokers: ({}))", newlyDemotedBrokers, newlyPromotedBrokers);
            return;
        }
        if (newlyDemotedBrokers.isEmpty()) {
            LOG.debug("Notified of leadership priority change but will not act on them due to not having any newly demoted brokers");
            return;
        }
        if (!this.balanceEngine.isActive()) {
            LOG.debug("Notified of leadership priority change but will not act on them as the DataBalancer is not initialized (demoted brokers: ({}); promoted brokers: ({}))", newlyDemotedBrokers, newlyPromotedBrokers);
            return;
        }
        LOG.info("Notified of leadership priority alterations - demoted brokers: ({}); promoted brokers: ({})", newlyDemotedBrokers, newlyPromotedBrokers);
        this.overrideAllPendingBrokerAdditions(BrokerAdditionStateMachine.BrokerAdditionEvent.BROKER_DEMOTION_DETECTED.withBrokers(newlyDemotedBrokers), String.format("broker leadership priority change (demoted brokers: [%s]", newlyDemotedBrokers));
        BrokerRemovalCancellationProposal.BrokerRemovalCancellationProposalBuilder cancellationRequestBuilder = new BrokerRemovalCancellationProposal.BrokerRemovalCancellationProposalBuilder().setCancellationEvent(BrokerRemovalStateMachine.BrokerRemovalEvent.DEMOTED_ADDED).setDemotedBrokers(newlyDemotedBrokers);
        boolean removalsCancelled = this.tryCancelAllExistingBrokerRemovals(cancellationRequestBuilder);
        long numActiveRemovals = this.balanceEngine.getDataBalanceEngineContext().getBrokerRemovalsStateTrackers().values().stream().filter(stateTracker -> !stateTracker.currentState().isTerminal()).count();
        if (numActiveRemovals == 0L || removalsCancelled) {
            this.balanceEngine.notifyBrokerChange(newlyDemotedBrokers, BrokerChangeEvent.DEMOTED);
        }
    }

    private synchronized boolean tryCancelAllExistingBrokerRemovals(BrokerRemovalCancellationProposal.BrokerRemovalCancellationProposalBuilder cancellationRequestBuilder) {
        if (!this.balanceEngine.isActive()) {
            return false;
        }
        Map<ImmutableSet<Integer>, BrokerRemovalStateTracker> stateTrackers = this.balanceEngine.getDataBalanceEngineContext().getBrokerRemovalsStateTrackers();
        return this.tryCancelExistingBrokerRemovals(new ArrayList<BrokerRemovalStateTracker>(stateTrackers.values()), cancellationRequestBuilder);
    }

    private synchronized boolean tryCancelExistingBrokerRemovals(Set<Integer> newBrokers, BrokerRemovalStateMachine.BrokerRemovalEvent cancellationEvent) {
        Map<ImmutableSet, BrokerRemovalStateTracker> stateTrackersToCancel = this.balanceEngine.getDataBalanceEngineContext().getBrokerRemovalsStateTrackers().entrySet().stream().filter(e -> ((ImmutableSet)e.getKey()).stream().anyMatch(newBrokers::contains)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return this.tryCancelExistingBrokerRemovals(new ArrayList<BrokerRemovalStateTracker>(stateTrackersToCancel.values()), new BrokerRemovalCancellationProposal.BrokerRemovalCancellationProposalBuilder().setCancellationEvent(cancellationEvent));
    }

    private synchronized boolean tryCancelExistingBrokerRemovals(Collection<BrokerRemovalStateTracker> stateTrackers, BrokerRemovalCancellationProposal.BrokerRemovalCancellationProposalBuilder cancellationProposalBuilder) {
        Map<ImmutableSet<Integer>, BrokerRemovalStateTracker> allStateTrackers = this.balanceEngine.getDataBalanceEngineContext().getBrokerRemovalsStateTrackers();
        Set<ImmutableSet<Integer>> allBrokerIds = allStateTrackers.keySet();
        List cancelledRemovalOperations = stateTrackers.stream().map(stateTracker -> {
            ImmutableSet<Object> brokerIds = new ImmutableSet();
            if (this.tryCancelBrokerRemoval((BrokerRemovalStateTracker)stateTracker, cancellationProposalBuilder)) {
                brokerIds = stateTracker.brokerIds();
                allStateTrackers.remove(brokerIds);
            }
            return brokerIds;
        }).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        if (cancelledRemovalOperations.isEmpty()) {
            LOG.debug("No broker removal operations were canceled for {}, either due to none being present/in-progress or a failure in cancellation. Cancellation cause was {} ({})", new Object[]{allBrokerIds, cancellationProposalBuilder.cancellationEvent(), cancellationProposalBuilder.cancellationMode()});
        } else {
            LOG.info("Cancelled the broker removal operations for brokers {} due to {} ({}). (new brokers {})", new Object[]{cancelledRemovalOperations, cancellationProposalBuilder.cancellationEvent(), cancellationProposalBuilder.cancellationMode(), allBrokerIds});
        }
        return !cancelledRemovalOperations.isEmpty();
    }

    private boolean tryCancelBrokerRemoval(BrokerRemovalStateTracker stateTracker, BrokerRemovalCancellationProposal.BrokerRemovalCancellationProposalBuilder cancellationProposalBuilder) {
        ImmutableSet<Integer> brokerIds = stateTracker.brokerIds();
        LOG.info("Attempting to set cancelled state due to {} with mode {} on broker removal operation for brokers {}", new Object[]{cancellationProposalBuilder.cancellationEvent(), cancellationProposalBuilder.cancellationMode(), brokerIds});
        String errMsg = String.format("The broker removal operation for brokers %s was canceled,  due to a %s event.", brokerIds, cancellationProposalBuilder.cancellationEvent());
        BrokerRemovalCanceledException cancelException = new BrokerRemovalCanceledException(errMsg);
        cancellationProposalBuilder.setEventException((Exception)cancelException);
        boolean shouldCancelRemoval = stateTracker.maybeCancel(cancellationProposalBuilder.build());
        if (shouldCancelRemoval) {
            LOG.info("Successfully set canceled status on broker removal task for brokers {}. Proceeding with cancellation of the operation", brokerIds);
            boolean wasCanceled = this.balanceEngine.cancelBrokerRemoval(brokerIds, String.format("An incoming %s event cancels the broker removal operation.", cancellationProposalBuilder.cancellationEvent()));
            if (wasCanceled) {
                LOG.info("Successfully canceled the broker removal operation for brokers {}.", brokerIds);
            } else {
                LOG.error("Did not succeed in canceling the broker removal operation for brokers {}", brokerIds);
            }
            return wasCanceled;
        }
        LOG.info("Will not cancel broker removal operation for brokers {}. (the operation is in state {})", brokerIds, (Object)stateTracker.currentState());
        return false;
    }

    public List<BrokerRemovalDescriptionInternal> brokerRemovals() {
        if (!this.balanceEngine.isActive()) {
            String msg = "Received request to describe broker removals while Databalancer is not started.";
            LOG.error(msg);
            throw new BalancerOfflineException(msg);
        }
        long now = this.time.milliseconds();
        long historyCutOffTimeMs = now - this.taskHistoryRetentionPeriodMs;
        DataBalanceEngineContext dataBalanceEngineContext = this.balanceEngine.getDataBalanceEngineContext();
        ApiStatePersistenceStore persistenceStore = dataBalanceEngineContext.getPersistenceStore();
        if (persistenceStore == null) {
            return Collections.emptyList();
        }
        LOG.debug("Returning broker removal records from {} with task retention milliseconds: {}", (Object)now, (Object)this.taskHistoryRetentionPeriodMs);
        List sortedDescriptions = persistenceStore.getAllBrokerRemovalStateRecords().values().stream().peek(removalDescription -> LOG.debug(removalDescription.toString())).filter(removalDescription -> removalDescription.lastUpdateTime() > historyCutOffTimeMs).sorted(Comparator.comparingLong(BrokerRemovalStateRecord::lastUpdateTime)).flatMap(r -> r.toRemovalDescriptions().stream()).collect(Collectors.toList());
        HashSet<BrokerRemovalDescriptionInternal> brokerRemovals = new HashSet<BrokerRemovalDescriptionInternal>();
        for (BrokerRemovalDescriptionInternal descriptionInternal : sortedDescriptions) {
            brokerRemovals.remove(descriptionInternal);
            brokerRemovals.add(descriptionInternal);
        }
        return new ArrayList<BrokerRemovalDescriptionInternal>(brokerRemovals);
    }

    public BalancerStatusDescriptionInternal balancerStatus() {
        AtomicBoolean incrementalBalancingEnabled = new AtomicBoolean(this.kafkaConfig.getBoolean("confluent.balancer.incremental.balancing.enabled"));
        boolean v2AdditionEnabled = this.kafkaConfig.getBoolean("confluent.balancer.v2.addition.enabled");
        AtomicBoolean isDefaultGoalsConfig = new AtomicBoolean(true);
        ArrayList triggeringGoals = new ArrayList();
        ArrayList rebalancingGoals = new ArrayList();
        Optional<SbcGoalsConfig> goalsConfigOpt = this.balanceEngine.latestSbcGoalsConfig();
        goalsConfigOpt.ifPresent(goalsConfig -> {
            incrementalBalancingEnabled.set(goalsConfig.isIncrementalBalancingEnabled());
            if (incrementalBalancingEnabled.get()) {
                List incrementalBalancingGoalNames = goalsConfig.incrementalBalancingGoals().goals().stream().map(goal -> goal.getClass().getName()).collect(Collectors.toList());
                isDefaultGoalsConfig.set(incrementalBalancingGoalNames.equals(KafkaCruiseControlConfig.INCREMENTAL_BALANCING_DEFAULT_GOALS_LIST));
                triggeringGoals.addAll(incrementalBalancingGoalNames);
                rebalancingGoals.addAll(incrementalBalancingGoalNames);
            } else {
                List triggeringGoalsNames = goalsConfig.triggeringGoals().goals().stream().map(goal -> goal.getClass().getName()).collect(Collectors.toList());
                List rebalancingGoalsNames = goalsConfig.rebalancingGoals().goals().stream().map(goal -> goal.getClass().getName()).collect(Collectors.toList());
                isDefaultGoalsConfig.set(triggeringGoalsNames.equals(KafkaCruiseControlConfig.DEFAULT_ANOMALY_DETECTION_GOALS_LIST) && rebalancingGoalsNames.equals(KafkaCruiseControlConfig.DEFAULT_GOALS_LIST));
                triggeringGoals.addAll(triggeringGoalsNames);
                rebalancingGoals.addAll(rebalancingGoalsNames);
            }
        });
        return new BalancerStatusDescriptionInternal(this.balancerStatusTracker.currentState().status(), Collections.singleton(this.balancerStatusTracker.brokerId()), (Exception)this.balancerStatusTracker.exception().orElse(null), incrementalBalancingEnabled.get(), v2AdditionEnabled, isDefaultGoalsConfig.get(), triggeringGoals, rebalancingGoals);
    }

    public synchronized void triggerEvenClusterLoadTask(List<String> goalList) {
        this.validateActiveBalancer("Received request to trigger even cluster load task while Databalancer is not started.");
        String uuid = String.format("user-triggered-even-cluster-load-task-%d", this.time.milliseconds());
        this.balanceEngine.triggerEvenClusterLoadTask(goalList, uuid);
    }

    public synchronized void computeEvenClusterLoadPlan(List<String> goalList, ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<EvenClusterLoadPlanInternal> callback) {
        this.validateActiveBalancer("Received request to compute an even cluster load plan while Databalancer is not started.");
        String uuid = String.format("user-initiated-computation-of-even-cluster-load-plan-%d", this.time.milliseconds());
        this.balanceEngine.computeEvenClusterLoadPlan(goalList, uuid, callback);
    }

    private void validateActiveBalancer(String errorMessage) {
        if (!this.balanceEngine.isActive()) {
            LOG.error(errorMessage);
            throw new BalancerOfflineException(errorMessage);
        }
    }

    public EvenClusterLoadStatusDescriptionInternal evenClusterLoadStatus() {
        return this.balanceEngine.evenClusterLoadStatus(this.kafkaConfig);
    }

    private static boolean isBalancerEnabled(KafkaConfig kafkaConfig) {
        return kafkaConfig.confluentConfig().selfBalanceEnable();
    }

    public synchronized void scheduleBrokerRemoval(BrokerRemovalRequest removalRequest, AliveBrokersMetadata brokersSnapshot) {
        if (!this.balanceEngine.isActive()) {
            String msg = String.format("Received request to remove brokers %s while DataBalancer is not started.", removalRequest);
            LOG.error(msg);
            throw new BalancerOfflineException(msg);
        }
        if (this.validateAndCheckNoOp(removalRequest)) {
            return;
        }
        this.overrideAllPendingBrokerAdditions(BrokerAdditionStateMachine.BrokerAdditionEvent.BROKER_REMOVAL_REQUEST_OVERRIDES.withBrokers(removalRequest.brokersEligibleForRemoval), String.format("broker removal request (for brokers %s)", removalRequest.brokersEligibleForRemoval));
        Map<Integer, Optional<Long>> brokerEpochs = removalRequest.brokersEligibleForRemoval.stream().collect(Collectors.toMap(id -> id, arg_0 -> ((AliveBrokersMetadata)brokersSnapshot).epochFor(arg_0)));
        String uid = BrokerRemovalCallback.uuid(brokerEpochs.keySet(), this.time.milliseconds());
        LOG.info("Submitting broker removal operation with UUID {} for brokers with epochs {}", (Object)uid, brokerEpochs);
        this.balanceEngine.removeBrokers(brokerEpochs, removalRequest.shouldShutdown, uid);
    }

    private boolean validateAndCheckNoOp(BrokerRemovalRequest removalRequest) {
        long now = this.time.milliseconds();
        long historyCutOffTimeMs = now - this.taskHistoryRetentionPeriodMs;
        if (!removalRequest.nonExistentBrokers.isEmpty()) {
            Set persistedRemovalBrokerIds = this.balanceEngine.getDataBalanceEngineContext().getPersistenceStore().getAllBrokerRemovalStateRecords().entrySet().stream().filter(kv -> ((BrokerRemovalStateRecord)kv.getValue()).lastUpdateTime() > historyCutOffTimeMs).flatMap(kv -> ((ImmutableSet)kv.getKey()).stream()).collect(Collectors.toSet());
            if (!persistedRemovalBrokerIds.containsAll(removalRequest.nonExistentBrokers)) {
                List nonExistentBrokerIds = removalRequest.nonExistentBrokers.stream().filter(nonExistentBrokerId -> !persistedRemovalBrokerIds.contains(nonExistentBrokerId)).collect(Collectors.toList());
                throw new InvalidBrokerRemovalException(String.format("Unknown broker ids specified %s", nonExistentBrokerIds));
            }
            if (removalRequest.brokersEligibleForRemoval.isEmpty()) {
                LOG.info("The broker removal request {} is a no-op because all of its requested brokers were removed.", (Object)removalRequest);
                return true;
            }
            LOG.info("Performing a no-op for a subset of broker ids ({}) in the broker removal request {} because the brokers were already removed.", (Object)removalRequest.nonExistentBrokers, (Object)removalRequest);
        }
        return false;
    }

    private void overrideAllPendingBrokerAdditions(BrokerAdditionStateMachine.AdditionEvent event, String cause) {
        this.balanceEngine.getDataBalanceEngineContext().additionContext().overrideAllPendingBrokerAdditions(event, cause);
    }

    private void activateEngine(Optional<AliveBrokersMetadata> aliveBrokersMetadataOpt) {
        this.activateEngine(aliveBrokersMetadataOpt, EngineInitializationContext.EngineStartupType.ON_FAILOVER);
    }

    private void activateEngine(Optional<AliveBrokersMetadata> aliveBrokersMetadataOpt, EngineInitializationContext.EngineStartupType startupType) {
        this.balanceEngine.onActivation(new EngineInitializationContext(this.kafkaConfig, this.bootstrapServerEndpointOpt, startupType, aliveBrokersMetadataOpt, new BrokerRemovalMetricRegistry(), this.balancerStatusTracker));
    }

    private void deactivateEngine(BalancerStatusStateMachine.BalancerEvent balancerEvent) {
        this.balanceEngine.onDeactivation(balancerEvent);
    }

    public DataBalanceEngine getBalanceEngine() {
        return this.balanceEngine;
    }

    void setBalanceEngine(DataBalanceEngine balanceEngine) {
        this.balanceEngine = balanceEngine;
    }

    private void enableDatabalancerMetric() {
        LOG.info("Registering metric {}", (Object)"ActiveBalancerCount");
        this.dataBalancerMetricsRegistry.newGauge(KafkaDataBalanceManager.class, "ActiveBalancerCount", () -> this.balanceEngine.isActive() ? 1 : 0, false);
    }

    private void disableDatabalancerMetric() {
        LOG.info("De-registering metric {}", (Object)"ActiveBalancerCount");
        this.dataBalancerMetricsRegistry.clearLongLivedMetric(KafkaDataBalanceManager.class, "ActiveBalancerCount");
    }

    public KafkaConfig getKafkaConfig() {
        return this.kafkaConfig;
    }

    public long taskHistoryRetentionMs() {
        return this.taskHistoryRetentionPeriodMs;
    }

    class BrokerRemovalMetricRegistry {
        BrokerRemovalMetricRegistry() {
        }

        public AtomicReference<String> registerBrokerRemovalMetric(Set<Integer> brokerIds) {
            AtomicReference<String> stateReference = new AtomicReference<String>("NOT_STARTED");
            for (Integer brokerId : brokerIds) {
                KafkaDataBalanceManager.this.dataBalancerMetricsRegistry.newGauge(ConfluentDataBalanceEngine.class, KafkaDataBalanceManager.BROKER_REMOVAL_STATE_METRIC_NAME, stateReference::get, true, DataBalancerMetricsRegistry.brokerIdMetricTag(brokerId));
            }
            return stateReference;
        }
    }

    static class DataBalanceEngineFactory {
        private final DataBalanceEngine activeDataBalanceEngine;
        private final DataBalanceEngine inactiveDataBalanceEngine;

        DataBalanceEngineFactory(DataBalancerMetricsRegistry dataBalancerMetricsRegistry, KafkaConfig config) {
            this(new ConfluentDataBalanceEngine(dataBalancerMetricsRegistry, config), new NoOpDataBalanceEngine());
        }

        DataBalanceEngineFactory(DataBalanceEngine activeBalanceEngine, DataBalanceEngine inactiveBalanceEngine) {
            this.activeDataBalanceEngine = Objects.requireNonNull(activeBalanceEngine);
            this.inactiveDataBalanceEngine = Objects.requireNonNull(inactiveBalanceEngine);
        }

        DataBalanceEngine getActiveDataBalanceEngine() {
            return this.activeDataBalanceEngine;
        }

        DataBalanceEngine getInactiveDataBalanceEngine() {
            return this.inactiveDataBalanceEngine;
        }

        void shutdown(KafkaConfig kafkaConfig) throws InterruptedException {
            this.activeDataBalanceEngine.shutdown(kafkaConfig);
            this.inactiveDataBalanceEngine.shutdown(kafkaConfig);
        }
    }
}

