/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SelfHealingStateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(SelfHealingStateTracker.class);
    private final int selfHealingMaximumRounds;
    private final Map<String, Integer> iterationsByGoalName;

    public SelfHealingStateTracker(KafkaCruiseControlConfig config) {
        this(config.getInt("self.healing.maximum.rounds"), new HashMap<String, Integer>());
    }

    SelfHealingStateTracker(int selfHealingMaximumRounds, Map<String, Integer> iterationsByGoalName) {
        this.selfHealingMaximumRounds = selfHealingMaximumRounds;
        this.iterationsByGoalName = iterationsByGoalName;
    }

    public synchronized Collection<String> allInProgressGoals() {
        HashMap<String, Integer> copy = new HashMap<String, Integer>(this.iterationsByGoalName);
        return Collections.unmodifiableMap(copy).keySet();
    }

    public synchronized boolean isInProgress(String goalName) {
        return this.iterationsByGoalName.containsKey(goalName);
    }

    public synchronized void recordIteration(String goalName) {
        int updatedNumberOfIterations = this.iterationsByGoalName.compute(goalName, (key, currentNumberOfIterations) -> currentNumberOfIterations == null ? 1 : currentNumberOfIterations + 1);
        if (updatedNumberOfIterations >= this.selfHealingMaximumRounds) {
            LOG.info("Goal {} is considered SUCCEEDED because it reached maximum number of iteration {}", (Object)goalName, (Object)this.selfHealingMaximumRounds);
            this.iterationsByGoalName.remove(goalName);
        } else {
            LOG.info("Goal {} is considered IN_PROGRESS. Current number of iteration: {}", (Object)goalName, (Object)updatedNumberOfIterations);
        }
    }

    public synchronized void markGoalAsSuccessful(String goalName) {
        Optional.ofNullable(this.iterationsByGoalName.remove(goalName)).ifPresent(iterations -> LOG.info("Goal {}'s IN_PROGRESS status is cleared and has finished balancing the cluster after {} iterations", (Object)goalName, iterations));
    }
}

