/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.monitoring;

import io.confluent.connect.replicator.monitoring.entities.Metric;
import io.confluent.connect.replicator.monitoring.entities.Task;
import io.confluent.connect.replicator.monitoring.entities.WorkerMetrics;
import io.confluent.connect.replicator.monitoring.jmx.MBeanServerProvider;
import io.confluent.connect.replicator.monitoring.jmx.PlatformMBeanServerProvider;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/WorkerMetrics")
@Produces(value={"application/json"})
public class WorkerMetricsResource {
    public static final String REPLICATOR_PREFIX = "confluent.replicator";
    public static final String CONNECTOR_TASK_NAME_PROPERTY = "confluent-replicator-task";
    public static final String CONNECTOR_TASK_METRICS_PROPERTY = "confluent-replicator-task-metrics";
    public static final String CONNECTOR_TASK_TOPIC_PARTITION_PROPERTY = "confluent-replicator-task-topic-partition";
    public static final String METRIC_TYPE_PROPERTY = "type";
    public static final String REPLICATOR_ATTRIBUTE_PREFIX = "confluent-replicator";
    public static final String SOURCE_CLUSTER_ATTRIBUTE = "confluent-replicator-source-cluster";
    public static final String DEST_CLUSTER_ATTRIBUTE = "confluent-replicator-destination-cluster";
    public static final String DEST_TOPIC_ATTRIBUTE = "confluent-replicator-destination-topic-name";
    public static final String REPLICATOR_TOPIC_PARTITION_ATTRIBUTE_PREFIX = "confluent-replicator-task-topic-partition";
    public static final String MESSAGE_LAG_ATTRIBUTE = "confluent-replicator-task-topic-partition-message-lag";
    public static final String THROUGHPUT_ATTRIBUTE = "confluent-replicator-task-topic-partition-throughput";
    public static final String LATENCY_ATTRIBUTE = "confluent-replicator-task-topic-partition-latency";
    private MBeanServerProvider mbeanServerProvider = new PlatformMBeanServerProvider();

    @GET
    @Path(value="{connectorName}")
    public WorkerMetrics getWorkerMetrics(@PathParam(value="connectorName") String connectorName) {
        WorkerMetrics workerMetrics = new WorkerMetrics(connectorName, null, null);
        MBeanServer mbeanServer = this.mbeanServerProvider.getMbeanServer();
        HashMap discoveredMetrics = new HashMap();
        try {
            for (ObjectName name : mbeanServer.queryNames(new ObjectName("confluent.replicator:*"), null)) {
                String connectorTaskName = name.getKeyProperty(CONNECTOR_TASK_NAME_PROPERTY);
                String type = name.getKeyProperty(METRIC_TYPE_PROPERTY);
                if (!type.equals(CONNECTOR_TASK_METRICS_PROPERTY) || !connectorTaskName.substring(0, connectorTaskName.lastIndexOf("-")).equals(connectorName)) continue;
                String srcClusterId = mbeanServer.getAttribute(name, SOURCE_CLUSTER_ATTRIBUTE).toString();
                String destClusterId = mbeanServer.getAttribute(name, DEST_CLUSTER_ATTRIBUTE).toString();
                workerMetrics.srcClusterId = srcClusterId;
                workerMetrics.destClusterId = destClusterId;
                if (!discoveredMetrics.containsKey(connectorTaskName)) {
                    discoveredMetrics.put(connectorTaskName, new ArrayList());
                }
                String srcTopicPartition = name.getKeyProperty("confluent-replicator-task-topic-partition");
                String srcTopic = srcTopicPartition.substring(0, srcTopicPartition.lastIndexOf("-"));
                String srcPartition = srcTopicPartition.substring(srcTopicPartition.lastIndexOf("-") + 1);
                String destTopic = mbeanServer.getAttribute(name, DEST_TOPIC_ATTRIBUTE).toString();
                String messageLag = mbeanServer.getAttribute(name, MESSAGE_LAG_ATTRIBUTE).toString();
                String throughput = mbeanServer.getAttribute(name, THROUGHPUT_ATTRIBUTE).toString();
                String latency = mbeanServer.getAttribute(name, LATENCY_ATTRIBUTE).toString();
                Metric metric = new Metric(System.currentTimeMillis(), this.convertToDecimal(throughput), this.convertToDecimal(messageLag), this.convertToDecimal(latency), srcTopic, Integer.valueOf(srcPartition), destTopic);
                ((List)discoveredMetrics.get(connectorTaskName)).add(metric);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String taskId : discoveredMetrics.keySet()) {
            Task task = new Task(taskId, null, null);
            for (Metric metric : (List)discoveredMetrics.get(taskId)) {
                task.addMetric(metric);
            }
            workerMetrics.addTask(task);
        }
        return workerMetrics;
    }

    public void setMBeanServerProvider(MBeanServerProvider mbeanServerProvider) {
        this.mbeanServerProvider = mbeanServerProvider;
    }

    private BigDecimal convertToDecimal(String metricValue) {
        BigDecimal convertedValue = BigDecimal.valueOf(0.0);
        if (metricValue.equals("NaN")) {
            return convertedValue;
        }
        try {
            convertedValue = new BigDecimal(metricValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return convertedValue;
    }
}

