/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Objects;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.CellImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.DelegationTokenImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.TenantImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.node.MetadataImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.raft.OffsetAndEpoch;

public final class MetadataImage {
    public static final MetadataImage EMPTY = new MetadataImage(MetadataProvenance.EMPTY, FeaturesImage.EMPTY, ClusterImage.EMPTY, TopicsImage.EMPTY, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ClusterLinksImage.EMPTY, BrokerReplicaExclusionsImage.EMPTY, CellImage.EMPTY, TenantImage.EMPTY, ScramImage.EMPTY, DelegationTokenImage.EMPTY, NoOpMetadataEncryptor.INSTANCE);
    private final MetadataProvenance provenance;
    private final MetadataEncryptor encryptor;
    private final FeaturesImage features;
    private final ClusterImage cluster;
    private final TopicsImage topics;
    private final ConfigurationsImage configs;
    private final ClientQuotasImage clientQuotas;
    private final ProducerIdsImage producerIds;
    private final AclsImage acls;
    private final ClusterLinksImage clusterLinks;
    private final BrokerReplicaExclusionsImage replicaExclusions;
    private final CellImage cells;
    private final TenantImage tenants;
    private final ScramImage scram;
    private final DelegationTokenImage delegationTokens;

    public MetadataImage(MetadataProvenance provenance, FeaturesImage features, ClusterImage cluster, TopicsImage topics, ConfigurationsImage configs, ClientQuotasImage clientQuotas, ProducerIdsImage producerIds, AclsImage acls, ClusterLinksImage clusterLinks, BrokerReplicaExclusionsImage replicaExclusions, CellImage cells, TenantImage tenants, ScramImage scram, DelegationTokenImage delegationTokens, MetadataEncryptor encryptor) {
        this.provenance = provenance;
        this.features = features;
        this.cluster = cluster;
        this.topics = topics;
        this.configs = configs;
        this.clientQuotas = clientQuotas;
        this.producerIds = producerIds;
        this.acls = acls;
        this.clusterLinks = clusterLinks;
        this.replicaExclusions = replicaExclusions;
        this.cells = cells;
        this.tenants = tenants;
        this.scram = scram;
        this.delegationTokens = delegationTokens;
        this.encryptor = encryptor;
    }

    public boolean isEmpty() {
        return this.encryptor.isEmpty() && this.features.isEmpty() && this.cluster.isEmpty() && this.topics.isEmpty() && this.configs.isEmpty() && this.clientQuotas.isEmpty() && this.producerIds.isEmpty() && this.acls.isEmpty() && this.clusterLinks.isEmpty() && this.replicaExclusions.isEmpty() && this.cells.isEmpty() && this.tenants.isEmpty() && this.scram.isEmpty() && this.delegationTokens.isEmpty();
    }

    public MetadataProvenance provenance() {
        return this.provenance;
    }

    public OffsetAndEpoch highestOffsetAndEpoch() {
        return new OffsetAndEpoch(this.provenance.lastContainedOffset(), this.provenance.lastContainedEpoch());
    }

    public long offset() {
        return this.provenance.lastContainedOffset();
    }

    public FeaturesImage features() {
        return this.features;
    }

    public ClusterImage cluster() {
        return this.cluster;
    }

    public TopicsImage topics() {
        return this.topics;
    }

    public ConfigurationsImage configs() {
        return this.configs;
    }

    public ClientQuotasImage clientQuotas() {
        return this.clientQuotas;
    }

    public ProducerIdsImage producerIds() {
        return this.producerIds;
    }

    public AclsImage acls() {
        return this.acls;
    }

    public ClusterLinksImage clusterLinks() {
        return this.clusterLinks;
    }

    public BrokerReplicaExclusionsImage brokerReplicaExclusions() {
        return this.replicaExclusions;
    }

    public CellImage cells() {
        return this.cells;
    }

    public TenantImage tenants() {
        return this.tenants;
    }

    public MetadataEncryptor encryptor() {
        return this.encryptor;
    }

    public ScramImage scram() {
        return this.scram;
    }

    public DelegationTokenImage delegationTokens() {
        return this.delegationTokens;
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        this.features.write(writer, options);
        this.encryptor.writeInstallRecord(writer, options);
        this.cluster.write(writer, options);
        this.cells.write(writer, options);
        this.tenants.write(writer, options);
        this.topics.write(writer, options);
        this.configs.write(writer, options, this.encryptor);
        this.clientQuotas.write(writer, options);
        this.producerIds.write(writer, options);
        this.acls.write(writer, options);
        this.clusterLinks.write(writer, options);
        this.replicaExclusions.write(writer, options);
        this.scram.write(writer, options);
        this.delegationTokens.write(writer, options);
        writer.close(true);
    }

    MetadataImage copyWithEncryptor(MetadataEncryptor newEncryptor) {
        return new MetadataImage(this.provenance, this.features, this.cluster, this.topics, this.configs, this.clientQuotas, this.producerIds, this.acls, this.clusterLinks, this.replicaExclusions, this.cells, this.tenants, this.scram, this.delegationTokens, newEncryptor);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        MetadataImage other = (MetadataImage)o;
        return this.provenance.equals(other.provenance) && this.features.equals(other.features) && this.cluster.equals(other.cluster) && this.topics.equals(other.topics) && this.configs.equals(other.configs) && this.clientQuotas.equals(other.clientQuotas) && this.producerIds.equals(other.producerIds) && this.acls.equals(other.acls) && this.clusterLinks.equals(other.clusterLinks) && this.replicaExclusions.equals(other.replicaExclusions) && this.encryptor.id().equals((Object)other.encryptor.id()) && this.cells.equals(other.cells) && this.tenants.equals(other.tenants) && this.scram.equals(other.scram) && this.delegationTokens.equals(other.delegationTokens);
    }

    public int hashCode() {
        return Objects.hash(this.provenance, this.features, this.cluster, this.topics, this.configs, this.clientQuotas, this.producerIds, this.acls, this.clusterLinks, this.replicaExclusions, this.encryptor.id(), this.cells, this.tenants, this.scram, this.delegationTokens);
    }

    public String toString() {
        return new MetadataImageNode(this).stringify();
    }
}

