/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.writer;

import java.util.function.Consumer;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.writer.UnwritableMetadataException;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.server.common.MetadataVersion;

public final class ImageWriterOptions {
    private final MetadataVersion metadataVersion;
    private final MetadataVersion requestedMetadataVersion;
    private final Consumer<UnwritableMetadataException> lossHandler;
    private final KafkaConfigSchema configSchema;

    private ImageWriterOptions(MetadataVersion metadataVersion, Consumer<UnwritableMetadataException> lossHandler, MetadataVersion orgMetadataVersion, KafkaConfigSchema configSchema) {
        this.metadataVersion = metadataVersion;
        this.lossHandler = lossHandler;
        this.requestedMetadataVersion = orgMetadataVersion;
        this.configSchema = configSchema;
    }

    public MetadataVersion metadataVersion() {
        return this.metadataVersion;
    }

    public void handleLoss(String loss) {
        this.lossHandler.accept(new UnwritableMetadataException(this.requestedMetadataVersion, loss));
    }

    public KafkaConfigSchema configSchema() {
        return this.configSchema;
    }

    public static class Builder {
        private MetadataVersion metadataVersion;
        private MetadataVersion requestedMetadataVersion;
        private Consumer<UnwritableMetadataException> lossHandler = e -> {
            throw e;
        };
        private KafkaConfigSchema configSchema = KafkaConfigSchema.EMPTY;

        public Builder() {
            this.metadataVersion = MetadataVersion.latest();
        }

        public Builder(MetadataImage image) {
            this.metadataVersion = image.features().metadataVersion();
        }

        public Builder setMetadataVersion(MetadataVersion metadataVersion) {
            this.setRequestedMetadataVersion(metadataVersion);
            if (metadataVersion.isLessThan(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION)) {
                this.setRawMetadataVersion(MetadataVersion.MINIMUM_KRAFT_VERSION);
            } else {
                this.setRawMetadataVersion(metadataVersion);
            }
            return this;
        }

        public Builder setRawMetadataVersion(MetadataVersion metadataVersion) {
            this.metadataVersion = metadataVersion;
            return this;
        }

        public void setRequestedMetadataVersion(MetadataVersion orgMetadataVersion) {
            this.requestedMetadataVersion = orgMetadataVersion;
        }

        public MetadataVersion metadataVersion() {
            return this.metadataVersion;
        }

        public MetadataVersion requestedMetadataVersion() {
            return this.requestedMetadataVersion;
        }

        public Builder setLossHandler(Consumer<UnwritableMetadataException> lossHandler) {
            this.lossHandler = lossHandler;
            return this;
        }

        public Builder setConfigSchema(KafkaConfigSchema configSchema) {
            this.configSchema = configSchema;
            return this;
        }

        public ImageWriterOptions build() {
            return new ImageWriterOptions(this.metadataVersion, this.lossHandler, this.requestedMetadataVersion, this.configSchema);
        }
    }
}

