/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter;

import com.google.inject.Module;
import com.netflix.governator.InjectorBuilder;
import com.netflix.governator.LifecycleInjector;
import com.netflix.governator.LifecycleInjectorCreator;
import com.netflix.governator.spi.InjectorCreator;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.extensions.SchemaRegistryResourceExtension;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.schema.exporter.SchemaExporterModule;
import io.confluent.schema.exporter.storage.DekExporterUpdateHandler;
import io.confluent.schema.exporter.storage.SchemaExporterService;
import io.confluent.schema.exporter.storage.SchemaExporterUpdateHandler;
import io.confluent.schema.exporter.web.rest.resources.SchemaExporterResource;
import java.io.IOException;
import javax.ws.rs.core.Configurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExporterResourceExtension
implements SchemaRegistryResourceExtension {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaExporterResourceExtension.class);
    private LifecycleInjector injector;
    private SchemaExporterService exporterService;

    public void register(Configurable<?> configurable, SchemaRegistryConfig schemaRegistryConfig, SchemaRegistry schemaRegistry) throws SchemaRegistryException {
        LOG.debug("registering injector");
        this.injector = (LifecycleInjector)InjectorBuilder.fromModules((Module[])new Module[]{new SchemaExporterModule(schemaRegistry)}).createInjector((InjectorCreator)new LifecycleInjectorCreator());
        LOG.debug("done registering injector");
        LOG.debug("registering rest classes");
        configurable.register(this.injector.getInstance(SchemaExporterResource.class));
        LOG.debug("done registering rest classes");
        this.exporterService = (SchemaExporterService)this.injector.getInstance(SchemaExporterService.class);
        SchemaExporterUpdateHandler schemaHandler = (SchemaExporterUpdateHandler)schemaRegistry.properties().get("exportHandler");
        schemaHandler.setExporterService(this.exporterService);
        DekExporterUpdateHandler dekHandler = (DekExporterUpdateHandler)schemaRegistry.properties().get("dekExportHandler");
        if (dekHandler != null) {
            dekHandler.setExporterService(this.exporterService);
        } else {
            LOG.info("DekRegistryResourceExtension not registered before SchemaExporterResourceExtension");
        }
    }

    public boolean initialized() {
        return this.exporterService != null && this.exporterService.initialized();
    }

    public void close() throws IOException {
        if (this.injector != null) {
            this.injector.close();
            this.injector = null;
        }
    }
}

