/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.client.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.rest.utils.UrlList;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.confluent.schema.exporter.client.rest.entities.CreateExporterRequest;
import io.confluent.schema.exporter.client.rest.entities.CreateExporterResponse;
import io.confluent.schema.exporter.client.rest.entities.ExporterInfo;
import io.confluent.schema.exporter.client.rest.entities.ExporterStatus;
import io.confluent.schema.exporter.client.rest.entities.UpdateExporterRequest;
import io.confluent.schema.exporter.client.rest.entities.UpdateExporterResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.kafka.common.Configurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExporterRestService
extends RestService
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(ExporterRestService.class);
    private static final TypeReference<List<String>> STRINGS_TYPE = new TypeReference<List<String>>(){};
    private static final TypeReference<ExporterInfo> INFO_TYPE = new TypeReference<ExporterInfo>(){};
    private static final TypeReference<Map<String, String>> CONFIG_TYPE = new TypeReference<Map<String, String>>(){};
    private static final TypeReference<ExporterStatus> STATUS_TYPE = new TypeReference<ExporterStatus>(){};
    private static final TypeReference<CreateExporterResponse> CREATE_EXPORTER_RESPONSE_TYPE = new TypeReference<CreateExporterResponse>(){};
    private static final TypeReference<UpdateExporterResponse> UPDATE_EXPORTER_RESPONSE_TYPE = new TypeReference<UpdateExporterResponse>(){};
    private static final TypeReference<Void> VOID_TYPE = new TypeReference<Void>(){};

    public ExporterRestService(UrlList baseUrls) {
        super(baseUrls);
    }

    public ExporterRestService(List<String> baseUrls) {
        super(baseUrls);
    }

    public ExporterRestService(String baseUrlConfig) {
        super(baseUrlConfig);
    }

    public List<String> listExporters() throws IOException, RestClientException {
        return this.listExporters(DEFAULT_REQUEST_PROPERTIES);
    }

    public List<String> listExporters(Map<String, String> requestProperties) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/exporters");
        String path = builder.build(new Object[0]).toString();
        return (List)this.httpRequest(path, "GET", null, requestProperties, STRINGS_TYPE);
    }

    public ExporterInfo getExporter(String name) throws IOException, RestClientException {
        return this.getExporter(DEFAULT_REQUEST_PROPERTIES, name);
    }

    public ExporterInfo getExporter(Map<String, String> requestProperties, String name) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/exporters/{name}");
        String path = builder.build(new Object[]{name}).toString();
        return (ExporterInfo)this.httpRequest(path, "GET", null, requestProperties, INFO_TYPE);
    }

    public Map<String, String> getExporterConfig(String name) throws IOException, RestClientException {
        return this.getExporterConfig(DEFAULT_REQUEST_PROPERTIES, name);
    }

    public Map<String, String> getExporterConfig(Map<String, String> requestProperties, String name) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/exporters/{name}/config");
        String path = builder.build(new Object[]{name}).toString();
        return (Map)this.httpRequest(path, "GET", null, requestProperties, CONFIG_TYPE);
    }

    public ExporterStatus getExporterStatus(String name) throws IOException, RestClientException {
        return this.getExporterStatus(DEFAULT_REQUEST_PROPERTIES, name);
    }

    public ExporterStatus getExporterStatus(Map<String, String> requestProperties, String name) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/exporters/{name}/status");
        String path = builder.build(new Object[]{name}).toString();
        return (ExporterStatus)this.httpRequest(path, "GET", null, requestProperties, STATUS_TYPE);
    }

    public CreateExporterResponse createExporter(Map<String, String> requestProperties, String name, List<String> subjects, ExporterInfo.ContextType contextType, String context, String kekRenameFormat, String subjectRenameFormat, Map<String, String> config) throws IOException, RestClientException {
        CreateExporterRequest request = new CreateExporterRequest();
        request.setName(name);
        request.setSubjects(subjects);
        request.setContextType(contextType);
        request.setContext(context);
        request.setKekRenameFormat(kekRenameFormat);
        request.setSubjectRenameFormat(subjectRenameFormat);
        request.setConfig(config);
        return this.createExporter(requestProperties, request);
    }

    public CreateExporterResponse createExporter(String name, List<String> subjects, ExporterInfo.ContextType contextType, String context, Map<String, String> config) throws IOException, RestClientException {
        return this.createExporter(name, subjects, contextType, context, null, null, config);
    }

    public CreateExporterResponse createExporter(String name, List<String> subjects, ExporterInfo.ContextType contextType, String context, String kekRenameFormat, String subjectRenameFormat, Map<String, String> config) throws IOException, RestClientException {
        CreateExporterRequest request = new CreateExporterRequest();
        request.setName(name);
        request.setSubjects(subjects);
        request.setContextType(contextType);
        request.setContext(context);
        request.setKekRenameFormat(kekRenameFormat);
        request.setSubjectRenameFormat(subjectRenameFormat);
        request.setConfig(config);
        return this.createExporter(DEFAULT_REQUEST_PROPERTIES, request);
    }

    public CreateExporterResponse createExporter(Map<String, String> requestProperties, CreateExporterRequest request) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/exporters");
        String path = builder.build(new Object[0]).toString();
        return (CreateExporterResponse)this.httpRequest(path, "POST", request.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, CREATE_EXPORTER_RESPONSE_TYPE);
    }

    public UpdateExporterResponse putExporter(Map<String, String> requestProperties, String name, List<String> subjects, ExporterInfo.ContextType contextType, String context, String kekRenameFormat, String subjectRenameFormat, Map<String, String> config) throws IOException, RestClientException {
        UpdateExporterRequest request = new UpdateExporterRequest();
        request.setSubjects(subjects);
        request.setContextType(contextType);
        request.setContext(context);
        request.setKekRenameFormat(kekRenameFormat);
        request.setSubjectRenameFormat(subjectRenameFormat);
        request.setConfig(config);
        return this.updateExporter(requestProperties, name, request);
    }

    public UpdateExporterResponse putExporter(String name, List<String> subjects, ExporterInfo.ContextType contextType, String context, String kekRenameFormat, String subjectRenameFormat, Map<String, String> config) throws IOException, RestClientException {
        UpdateExporterRequest request = new UpdateExporterRequest();
        request.setSubjects(subjects);
        request.setContextType(contextType);
        request.setContext(context);
        request.setKekRenameFormat(kekRenameFormat);
        request.setSubjectRenameFormat(subjectRenameFormat);
        request.setConfig(config);
        return this.updateExporter(DEFAULT_REQUEST_PROPERTIES, name, request);
    }

    public UpdateExporterResponse updateExporter(Map<String, String> requestProperties, String name, UpdateExporterRequest request) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/exporters/{name}");
        String path = builder.build(new Object[]{name}).toString();
        return (UpdateExporterResponse)this.httpRequest(path, "PUT", request.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, UPDATE_EXPORTER_RESPONSE_TYPE);
    }

    public UpdateExporterResponse putExporterConfig(String name, Map<String, String> config) throws IOException, RestClientException {
        return this.putExporterConfig(DEFAULT_REQUEST_PROPERTIES, name, config);
    }

    public UpdateExporterResponse putExporterConfig(Map<String, String> requestProperties, String name, Map<String, String> config) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/exporters/{name}/config");
        String path = builder.build(new Object[]{name}).toString();
        return (UpdateExporterResponse)this.httpRequest(path, "PUT", JacksonMapper.INSTANCE.writeValueAsString(config).getBytes(StandardCharsets.UTF_8), requestProperties, UPDATE_EXPORTER_RESPONSE_TYPE);
    }

    public UpdateExporterResponse pauseExporter(String name) throws IOException, RestClientException {
        return this.pauseExporter(DEFAULT_REQUEST_PROPERTIES, name);
    }

    public UpdateExporterResponse pauseExporter(Map<String, String> requestProperties, String name) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/exporters/{name}/pause");
        String path = builder.build(new Object[]{name}).toString();
        return (UpdateExporterResponse)this.httpRequest(path, "PUT", null, requestProperties, UPDATE_EXPORTER_RESPONSE_TYPE);
    }

    public UpdateExporterResponse resumeExporter(String name) throws IOException, RestClientException {
        return this.resumeExporter(DEFAULT_REQUEST_PROPERTIES, name);
    }

    public UpdateExporterResponse resumeExporter(Map<String, String> requestProperties, String name) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/exporters/{name}/resume");
        String path = builder.build(new Object[]{name}).toString();
        return (UpdateExporterResponse)this.httpRequest(path, "PUT", null, requestProperties, UPDATE_EXPORTER_RESPONSE_TYPE);
    }

    public UpdateExporterResponse resetExporter(String name) throws IOException, RestClientException {
        return this.resetExporter(DEFAULT_REQUEST_PROPERTIES, name);
    }

    public UpdateExporterResponse resetExporter(Map<String, String> requestProperties, String name) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/exporters/{name}/reset");
        String path = builder.build(new Object[]{name}).toString();
        return (UpdateExporterResponse)this.httpRequest(path, "PUT", null, requestProperties, UPDATE_EXPORTER_RESPONSE_TYPE);
    }

    public void deleteExporter(String name) throws IOException, RestClientException {
        this.deleteExporter(DEFAULT_REQUEST_PROPERTIES, name);
    }

    public void deleteExporter(Map<String, String> requestProperties, String name) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/exporters/{name}");
        String path = builder.build(new Object[]{name}).toString();
        this.httpRequest(path, "DELETE", null, requestProperties, VOID_TYPE);
    }
}

