/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.metrics;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import java.io.Closeable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MetricsManager
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsManager.class);
    public static final String KEY = "metricsManager";
    static final String METRIC_GROUP = "exporter";
    static final String TENANT_TAG = "tenant";
    static final String NUM_EXPORTERS = "num_exporters";
    private final Map<String, TenantMetrics> tenantMetrics = new ConcurrentHashMap<String, TenantMetrics>();
    private final Metrics metrics;

    @Inject
    public MetricsManager(SchemaRegistry schemaRegistry) {
        this.metrics = ((KafkaSchemaRegistry)schemaRegistry).getMetricsContainer().getMetrics();
        schemaRegistry.properties().put(KEY, this);
    }

    public long getExporterCount(String tenant) {
        TenantMetrics tenantMetrics = this.getOrCreateTenantMetrics(tenant);
        return tenantMetrics.getSensor(MetricDescriptor.NUM_EXPORTERS_MD, null, null).get();
    }

    public void incrementExporterCount(String tenant) {
        TenantMetrics tenantMetrics = this.getOrCreateTenantMetrics(tenant);
        tenantMetrics.getSensor(MetricDescriptor.NUM_EXPORTERS_MD, null, null).add(1L);
    }

    public void decrementExporterCount(String tenant) {
        TenantMetrics tenantMetrics = this.getOrCreateTenantMetrics(tenant);
        tenantMetrics.getSensor(MetricDescriptor.NUM_EXPORTERS_MD, null, null).add(-1L);
    }

    private TenantMetrics getOrCreateTenantMetrics(String tenant) {
        return this.tenantMetrics.computeIfAbsent(tenant, x$0 -> new TenantMetrics((String)x$0));
    }

    @Override
    public void close() {
        this.metrics.close();
    }

    private static enum MetricDescriptor {
        NUM_EXPORTERS_MD("num_exporters", "exporter", "Number of exporters");

        public final String metricName;
        public final String group;
        public final String description;

        private MetricDescriptor(String metricName, String group, String description) {
            this.metricName = metricName;
            this.group = group;
            this.description = description;
        }
    }

    private class MetricSensor {
        private final AtomicLong count = new AtomicLong(0L);
        private final Sensor sensor;

        public MetricSensor(String tenant, MetricDescriptor md, String tagKey, String tagValue) {
            String sensorName = tagKey == null ? md.metricName + "." + tenant : md.metricName + "." + tenant + "." + tagKey + "." + tagValue;
            this.sensor = MetricsManager.this.metrics.sensor(sensorName);
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            tags.put(MetricsManager.TENANT_TAG, tenant);
            if (tagKey != null) {
                tags.put(tagKey, tagValue);
            }
            MetricName metricNameCount = new MetricName(md.metricName, md.group, md.description, tags);
            this.sensor.add(metricNameCount, (MeasurableStat)new Value());
        }

        public long get() {
            return this.count.get();
        }

        public void add(long delta) {
            this.sensor.record((double)this.count.addAndGet(delta));
        }

        public void set(long number) {
            this.count.set(number);
            this.sensor.record((double)number);
        }

        public void reset() {
            this.count.set(0L);
            this.sensor.record(0.0);
        }
    }

    private class TenantMetrics {
        private final String tenant;
        private final Map<String, MetricSensor> sensors = new ConcurrentHashMap<String, MetricSensor>();

        public TenantMetrics(String tenant) {
            this.tenant = tenant;
        }

        private MetricSensor getSensor(MetricDescriptor md, String tagKey, String tagValue) {
            String sensorName = tagKey == null ? md.metricName + "." + this.tenant : md.metricName + "." + this.tenant + "." + tagKey;
            return this.sensors.computeIfAbsent(sensorName, k -> new MetricSensor(this.tenant, md, tagKey, tagValue));
        }
    }
}

