/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import io.confluent.schema.exporter.metrics.MetricsManager;
import io.confluent.schema.exporter.storage.SchemaExporter;
import io.confluent.schema.exporter.storage.SchemaExporterInfo;
import io.kcache.CacheUpdateHandler;
import java.io.IOException;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExporterCacheUpdateHandler
implements CacheUpdateHandler<SchemaExporter, SchemaExporterInfo> {
    private static final Logger log = LoggerFactory.getLogger(SchemaExporterCacheUpdateHandler.class);
    private MetricsManager metricsManager;

    public SchemaExporterCacheUpdateHandler(MetricsManager metricsManager) {
        this.metricsManager = metricsManager;
    }

    public void handleUpdate(SchemaExporter key, SchemaExporterInfo value, SchemaExporterInfo oldValue, TopicPartition tp, long offset, long timestamp) {
        String tenant = key.getTenant();
        if (value == null) {
            if (oldValue != null) {
                this.metricsManager.decrementExporterCount(tenant);
            }
        } else if (oldValue == null) {
            this.metricsManager.incrementExporterCount(tenant);
        }
    }

    public void close() throws IOException {
    }
}

