/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SubjectKey;
import io.confluent.kafka.schemaregistry.storage.SubjectValue;
import io.confluent.schema.exporter.storage.AbstractSchemaExporterTask;
import io.confluent.schema.exporter.storage.SchemaExporter;
import io.confluent.schema.exporter.storage.SchemaExporterInfo;
import io.confluent.schema.exporter.storage.SchemaExporterService;
import io.confluent.schema.exporter.storage.SchemaExporterStatus;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExporterRunningTask
extends AbstractSchemaExporterTask {
    private static final Logger log = LoggerFactory.getLogger(SchemaExporterRunningTask.class);
    private final SchemaRegistryKey key;
    private final SchemaRegistryValue value;
    private final long offset;
    private final long timestamp;
    private final Map<SchemaExporter, AbstractSchemaExporterTask.OffsetTimestamp> latestValues;

    public SchemaExporterRunningTask(SchemaExporterService exporterService, SchemaExporter exporter, SchemaRegistryKey key, SchemaRegistryValue value, long offset, long timestamp, Map<SchemaExporter, AbstractSchemaExporterTask.OffsetTimestamp> latestValues) {
        super(exporterService, exporter);
        this.key = key;
        this.value = value;
        this.offset = offset;
        this.timestamp = timestamp;
        this.latestValues = latestValues;
    }

    @Override
    public void run() {
        block14: {
            SchemaExporterStatus status;
            if (!this.exporterService().isLeader()) {
                return;
            }
            if (!"default".equals(this.tenant())) {
                this.schemaRegistry().setTenant(this.tenant());
            }
            if ((status = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)this.exporter())) == null || status.getState() != SchemaExporterStatus.State.RUNNING || status.getOffset() >= this.offset) {
                return;
            }
            try {
                if (this.key instanceof SubjectKey) {
                    SchemaExporterInfo info = (SchemaExporterInfo)this.exporterService().exporterInfos().get((Object)this.exporter());
                    if (info == null) {
                        return;
                    }
                    List<String> subjects = SchemaExporterService.getSubjects(info.getSubjects());
                    boolean checkMode = subjects.contains(":*:");
                    SchemaRegistryClient client = this.getSchemaRegistryClient(info.getConfig());
                    long lastOffset = status.getOffset();
                    AbstractSchemaExporterTask.OffsetTimestamp latestValue = this.latestValues.get(this.exporter());
                    if (latestValue != null && latestValue.getOffset() > lastOffset) {
                        lastOffset = latestValue.getOffset();
                    }
                    if (lastOffset < this.offset - 1L) {
                        for (String subjectOrPrefix : subjects) {
                            this.exportValues(this.exporter(), client, info, status, subjectOrPrefix, lastOffset, this.offset, checkMode);
                        }
                    }
                    String tenantPrefix = this.tenant().equals("default") ? "" : this.tenant() + "_";
                    SubjectKey subjectKey = (SubjectKey)this.key;
                    SubjectValue subjectValue = (SubjectValue)this.value;
                    String subject = subjectKey.getSubject();
                    boolean doExport = false;
                    if (!tenantPrefix.isEmpty()) {
                        if (subject.startsWith(tenantPrefix)) {
                            subject = subject.substring(tenantPrefix.length());
                            doExport = true;
                        }
                    } else {
                        doExport = true;
                    }
                    if (doExport && this.matches(subjects, subject)) {
                        this.export(this.exporter(), client, info, status, this.tenant(), subjectKey, subjectValue, checkMode);
                    }
                }
                this.latestValues.put(this.exporter(), new AbstractSchemaExporterTask.OffsetTimestamp(this.offset, this.timestamp));
            }
            catch (Throwable t) {
                String trace = this.trace(t);
                log.error("Error during export: " + trace);
                status = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)this.exporter());
                if (status == null) break block14;
                status.setState(SchemaExporterStatus.State.PAUSED);
                status.setTrace(trace);
                this.exporterService().exporterStatuses().put((Object)this.exporter(), (Object)status);
            }
        }
    }
}

