/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.rest.RestConfigException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.types.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExporterServerConfig
extends SchemaRegistryConfig {
    private static final Logger log = LoggerFactory.getLogger(SchemaExporterServerConfig.class);
    public static final String EXPORTER_CONFIG_TOPIC_CONFIG = "exporter.config.topic";
    public static final String EXPORTER_STATE_TOPIC_CONFIG = "exporter.state.topic";
    public static final String EXPORTER_MAX_EXPORTERS_CONFIG = "exporter.max.exporters";
    public static final String EXPORTER_NUM_THREADS_CONFIG = "exporter.num.threads";
    public static final String EXPORTER_MAX_RETRIES_CONFIG = "exporter.max.retries";
    public static final String EXPORTER_RETRIES_WAIT_MS_CONFIG = "exporter.retries.wait.ms";
    public static final String EXPORTER_RETRIES_MAX_WAIT_MS_CONFIG = "exporter.retries.max.wait.ms";
    public static final String PASSWORD_ENCODER_SECRET_CONFIG = "password.encoder.secret";
    public static final String PASSWORD_ENCODER_OLD_SECRET_CONFIG = "password.encoder.old.secret";
    public static final String PASSWORD_ENCODER_KEYFACTORY_ALGORITHM_CONFIG = "password.encoder.keyfactory.algorithm";
    public static final String PASSWORD_ENCODER_CIPHER_ALGORITHM_CONFIG = "password.encoder.cipher.algorithm";
    public static final String PASSWORD_ENCODER_KEY_LENGTH_CONFIG = "password.encoder.key.length";
    public static final String PASSWORD_ENCODER_ITERATIONS_CONFIG = "password.encoder.iterations";
    protected static final String EXPORTER_CONFIG_TOPIC_DEFAULT = "_exporter_configs";
    protected static final String EXPORTER_STATE_TOPIC_DEFAULT = "_exporter_states";
    protected static final int EXPORTER_MAX_EXPORTERS_DEFAULT = 10;
    protected static final int EXPORTER_NUM_THREADS_DEFAULT = 10;
    protected static final int EXPORTER_MAX_RETRIES_DEFAULT = 1;
    protected static final int EXPORTER_RETRIES_WAIT_MS_DEFAULT = 1000;
    protected static final int EXPORTER_RETRIES_MAX_WAIT_MS_DEFAULT = 20000;
    protected static final String PASSWORD_ENCODER_CIPHER_ALGORITHM_DEFAULT = "AES/CBC/PKCS5Padding";
    protected static final int PASSWORD_ENCODER_KEY_LENGTH_DEFAULT = 128;
    protected static final int PASSWORD_ENCODER_ITERATIONS_DEFAULT = 4096;
    protected static final String EXPORTER_CONFIG_TOPIC_DOC = "The topic used to persist exporter configs.";
    protected static final String EXPORTER_STATE_TOPIC_DOC = "The topic used to persist exporter states.";
    protected static final String EXPORTER_MAX_EXPORTERS_DOC = "Maximum number of exporters per tenant.";
    protected static final String EXPORTER_NUM_THREADS_DOC = "The number of threads for performing exports.";
    protected static final String EXPORTER_MAX_RETRIES_DOC = "Maximum number of times to retry exporter operations.";
    protected static final String EXPORTER_RETRIES_WAIT_MS_DOC = "Maximum time in milliseconds to wait before the first retry.";
    protected static final String EXPORTER_RETRIES_MAX_WAIT_MS_DOC = "Maximum time in milliseconds to wait before any retry.";
    protected static final String PASSWORD_ENCODER_SECRET_DOC = "The secret used for encoding dynamically configured passwords for this server.";
    protected static final String PASSWORD_ENCODER_OLD_SECRET_DOC = "The old secret that was used for encoding dynamically configured passwords. This is required only when the secret is updated. If specified, all dynamically encoded passwords are decoded using this old secret and re-encoded using password.encoder.secret when server starts up.";
    protected static final String PASSWORD_ENCODER_KEYFACTORY_ALGORITHM_DOC = "The SecretKeyFactory algorithm used for encoding dynamically configured passwords. Default is PBKDF2WithHmacSHA512 if available and PBKDF2WithHmacSHA1 otherwise.";
    protected static final String PASSWORD_ENCODER_CIPHER_ALGORITHM_DOC = "The Cipher algorithm used for encoding dynamically configured passwords.";
    protected static final String PASSWORD_ENCODER_KEY_LENGTH_DOC = "The key length used for encoding dynamically configured passwords.";
    protected static final String PASSWORD_ENCODER_ITERATIONS_DOC = "The iteration count used for encoding dynamically configured passwords.";
    private static final ConfigDef serverConfig = SchemaExporterServerConfig.baseSchemaRegistryConfigDef().define("exporter.config.topic", ConfigDef.Type.STRING, (Object)"_exporter_configs", ConfigDef.Importance.HIGH, "The topic used to persist exporter configs.").define("exporter.state.topic", ConfigDef.Type.STRING, (Object)"_exporter_states", ConfigDef.Importance.HIGH, "The topic used to persist exporter states.").define("exporter.max.exporters", ConfigDef.Type.INT, (Object)10, ConfigDef.Importance.LOW, "Maximum number of exporters per tenant.").define("exporter.num.threads", ConfigDef.Type.INT, (Object)10, ConfigDef.Importance.LOW, "The number of threads for performing exports.").define("exporter.max.retries", ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.LOW, "Maximum number of times to retry exporter operations.").define("exporter.retries.wait.ms", ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, "Maximum time in milliseconds to wait before the first retry.").define("exporter.retries.max.wait.ms", ConfigDef.Type.INT, (Object)20000, ConfigDef.Importance.LOW, "Maximum time in milliseconds to wait before any retry.").define("password.encoder.secret", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.MEDIUM, "The secret used for encoding dynamically configured passwords for this server.").define("password.encoder.old.secret", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.MEDIUM, "The old secret that was used for encoding dynamically configured passwords. This is required only when the secret is updated. If specified, all dynamically encoded passwords are decoded using this old secret and re-encoded using password.encoder.secret when server starts up.").define("password.encoder.keyfactory.algorithm", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "The SecretKeyFactory algorithm used for encoding dynamically configured passwords. Default is PBKDF2WithHmacSHA512 if available and PBKDF2WithHmacSHA1 otherwise.").define("password.encoder.cipher.algorithm", ConfigDef.Type.STRING, (Object)"AES/CBC/PKCS5Padding", ConfigDef.Importance.LOW, "The Cipher algorithm used for encoding dynamically configured passwords.").define("password.encoder.key.length", ConfigDef.Type.INT, (Object)128, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)8), ConfigDef.Importance.LOW, "The key length used for encoding dynamically configured passwords.").define("password.encoder.iterations", ConfigDef.Type.INT, (Object)4096, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1024), ConfigDef.Importance.LOW, "The iteration count used for encoding dynamically configured passwords.");

    private static Properties getPropsFromFile(String propsFile) throws RestConfigException {
        Properties props = new Properties();
        if (propsFile == null) {
            return props;
        }
        try (FileInputStream propStream = new FileInputStream(propsFile);){
            props.load(propStream);
        }
        catch (IOException e) {
            throw new RestConfigException("Couldn't load properties from " + propsFile, (Throwable)e);
        }
        return props;
    }

    public SchemaExporterServerConfig(String propsFile) throws RestConfigException {
        this(SchemaExporterServerConfig.getPropsFromFile(propsFile));
    }

    public SchemaExporterServerConfig(Properties props) throws RestConfigException {
        super(serverConfig, props);
    }

    public String exporterConfigTopic() {
        return this.getString(EXPORTER_CONFIG_TOPIC_CONFIG);
    }

    public String exporterStateTopic() {
        return this.getString(EXPORTER_STATE_TOPIC_CONFIG);
    }

    public int exporterMaxExporters() {
        return this.getInt(EXPORTER_MAX_EXPORTERS_CONFIG);
    }

    public int exporterNumThreads() {
        return this.getInt(EXPORTER_NUM_THREADS_CONFIG);
    }

    public int exporterMaxRetries() {
        return this.getInt(EXPORTER_MAX_RETRIES_CONFIG);
    }

    public int exporterRetriesWaitMs() {
        return this.getInt(EXPORTER_RETRIES_WAIT_MS_CONFIG);
    }

    public int exporterRetriesMaxWaitMs() {
        return this.getInt(EXPORTER_RETRIES_MAX_WAIT_MS_CONFIG);
    }

    public Optional<Password> passwordEncoderSecret() {
        return Optional.ofNullable(this.getPassword(PASSWORD_ENCODER_SECRET_CONFIG));
    }

    public Optional<Password> passwordEncoderOldSecret() {
        return Optional.ofNullable(this.getPassword(PASSWORD_ENCODER_OLD_SECRET_CONFIG));
    }

    public String passwordEncoderCipherAlgorithm() {
        return this.getString(PASSWORD_ENCODER_CIPHER_ALGORITHM_CONFIG);
    }

    public Optional<String> passwordEncoderKeyFactoryAlgorithm() {
        return Optional.ofNullable(this.getString(PASSWORD_ENCODER_KEYFACTORY_ALGORITHM_CONFIG));
    }

    public int passwordEncoderKeyLength() {
        return this.getInt(PASSWORD_ENCODER_KEY_LENGTH_CONFIG);
    }

    public int passwordEncoderIterations() {
        return this.getInt(PASSWORD_ENCODER_ITERATIONS_CONFIG);
    }
}

