/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.web.rest.exceptions;

import io.confluent.rest.exceptions.RestException;
import io.confluent.rest.exceptions.RestNotFoundException;
import io.confluent.schema.exporter.web.rest.exceptions.RestConflictException;

public class ExporterErrors {
    public static final String EXPORTER_NOT_FOUND_MESSAGE_FORMAT = "Exporter '%s' not found.";
    public static final int EXPORTER_NOT_FOUND_ERROR_CODE = 40450;
    public static final String MISSING_OR_INVALID_EXPORTER_NAME_FORMAT = "Missing or invalid exporter name: '%s'.";
    public static final int MISSING_OR_INVALID_EXPORTER_NAME_CODE = 40950;
    public static final String MISSING_OR_INVALID_EXPORTER_CONFIG_FORMAT = "Missing or invalid exporter config: '%s'.";
    public static final int MISSING_OR_INVALID_EXPORTER_CONFIG_CODE = 40951;
    public static final String INVALID_EXPORTER_SUBJECTS_FORMAT = "Exporter subjects must be of size 1 if containing a wildcard: '%s'.";
    public static final int INVALID_EXPORTER_SUBJECTS_CODE = 40952;
    public static final String MISSING_OR_INVALID_EXPORTER_CONTEXT_FORMAT = "Missing or invalid context: '%s'.";
    public static final int MISSING_OR_INVALID_EXPORTER_CONTEXT_CODE = 40953;
    public static final String ALREADY_EXISTS_MESSAGE_FORMAT = "Exporter '%s' already exists.";
    public static final int ALREADY_EXISTS_ERROR_CODE = 40960;
    public static final String ALREADY_RUNNING_MESSAGE_FORMAT = "Exporter '%s' is already running.";
    public static final int ALREADY_RUNNING_ERROR_CODE = 40961;
    public static final String ALREADY_STARTING_MESSAGE_FORMAT = "Exporter '%s' must finish starting.";
    public static final int ALREADY_STARTING_ERROR_CODE = 40962;
    public static final String NOT_PAUSED_MESSAGE_FORMAT = "Exporter '%s' must be paused first.";
    public static final int NOT_PAUSED_ERROR_CODE = 40963;
    public static final String TOO_MANY_EXPORTERS_MESSAGE_FORMAT = "A maximum of %d exporters already exist.";
    public static final int TOO_MANY_EXPORTERS_ERROR_CODE = 40964;

    public static RestException exporterNotFoundException(String name) {
        return new RestNotFoundException(String.format(EXPORTER_NOT_FOUND_MESSAGE_FORMAT, name), 40450);
    }

    public static RestException invalidOrMissingExporterName(String name) {
        return new RestConflictException(String.format(MISSING_OR_INVALID_EXPORTER_NAME_FORMAT, name), 40950);
    }

    public static RestException invalidOrMissingExporterConfig(String name) {
        return new RestConflictException(String.format(MISSING_OR_INVALID_EXPORTER_CONFIG_FORMAT, name), 40951);
    }

    public static RestException invalidExporterSubjects(String name) {
        return new RestConflictException(String.format(INVALID_EXPORTER_SUBJECTS_FORMAT, name), 40952);
    }

    public static RestException invalidOrMissingContext(String name) {
        return new RestConflictException(String.format(MISSING_OR_INVALID_EXPORTER_CONTEXT_FORMAT, name), 40953);
    }

    public static RestException alreadyExistsException(String name) {
        return new RestConflictException(String.format(ALREADY_EXISTS_MESSAGE_FORMAT, name), 40960);
    }

    public static RestException alreadyRunningException(String name) {
        return new RestConflictException(String.format(ALREADY_RUNNING_MESSAGE_FORMAT, name), 40961);
    }

    public static RestException alreadyStartingException(String name) {
        return new RestConflictException(String.format(ALREADY_STARTING_MESSAGE_FORMAT, name), 40962);
    }

    public static RestException notPausedException(String name) {
        return new RestConflictException(String.format(NOT_PAUSED_MESSAGE_FORMAT, name), 40963);
    }

    public static RestException tooManyExportersException(int maxExporters) {
        return new RestConflictException(String.format(TOO_MANY_EXPORTERS_MESSAGE_FORMAT, maxExporters), 40964);
    }
}

