/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kafka.common.AliveBrokersMetadata;
import kafka.common.BalancerStatusDescriptionInternal;
import kafka.common.BrokerAdditionDescriptionInternal;
import kafka.common.BrokerRemovalDescriptionInternal;
import kafka.common.CellLoadDescriptionInternal;
import kafka.common.EvenClusterLoadPlanInternal;
import kafka.common.EvenClusterLoadStatusDescriptionInternal;
import kafka.common.TopicsMetadataSnapshot;
import kafka.controller.ClusterBalanceManager;
import org.apache.kafka.clients.admin.BalancerStatus;
import org.apache.kafka.common.errors.BalancerLoadError;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.raft.LeaderAndEpoch;

class NoOpClusterBalanceManager
implements ClusterBalanceManager {
    String clusterBalancerClassName;
    Exception clusterBalancerClassLoadException;

    public NoOpClusterBalanceManager(String clusterBalancerClassName, Exception clusterBalancerClassLoadException) {
        this.clusterBalancerClassName = clusterBalancerClassName;
        this.clusterBalancerClassLoadException = clusterBalancerClassLoadException;
    }

    public String name() {
        return "NoOpClusterBalanceManager";
    }

    public Exception getClusterBalancerClassLoadException() {
        return this.clusterBalancerClassLoadException;
    }

    public String getClusterBalancerClassName() {
        return this.clusterBalancerClassName;
    }

    public void onControllerChange(LeaderAndEpoch leader) {
    }

    public void onMetadataUpdate(MetadataDelta metadataDelta, MetadataImage newMetadataImage, LoaderManifest loaderManifest) {
    }

    @Override
    public void scheduleZkBrokerRemoval(List<Integer> brokersToRemove, boolean shouldShutdown, TopicsMetadataSnapshot topicsMetadataSnapshot, AliveBrokersMetadata aliveBrokersMetadata, ClusterBalanceManager.BalanceManagerOperationInvocationClientCallback cb) {
        this.scheduleKraftBrokerRemoval(brokersToRemove, shouldShutdown, cb);
    }

    @Override
    public void scheduleKraftBrokerRemoval(List<Integer> brokersToRemove, boolean shouldShutdown, ClusterBalanceManager.BalanceManagerOperationInvocationClientCallback cb) {
        cb.respond(new ApiError(Errors.BALANCER_LOAD_ERROR, String.format("Request to remove brokers %s failed because the data balancer class (%s) was not loaded successfully", brokersToRemove, this.clusterBalancerClassName)));
    }

    @Override
    public void onBrokersStartup(Set<Integer> emptyBrokers, Set<Integer> newBrokers, AliveBrokersMetadata aliveBrokersMetadata) {
    }

    @Override
    public void onBrokersFailure(Set<Integer> deadBrokers) {
    }

    @Override
    public void onAlteredExclusions(Set<Integer> newExclusions, Set<Integer> removedExclusions) {
    }

    @Override
    public void brokerRemovals(ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<List<BrokerRemovalDescriptionInternal>> cb) {
        cb.respond(new ApiError(Errors.BALANCER_LOAD_ERROR, String.format("Request to list the broker removals failed because the data balancer class (%s) was not loaded successfully", this.clusterBalancerClassName)), Optional.empty());
    }

    @Override
    public void brokerAdditions(ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<List<BrokerAdditionDescriptionInternal>> cb) {
        cb.respond(new ApiError(Errors.BALANCER_LOAD_ERROR, String.format("Request to list the broker additions is rejected because the data balancer class (%s) was not loaded successfully", this.clusterBalancerClassName)), Optional.empty());
    }

    @Override
    public void balancerStatus(ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<BalancerStatusDescriptionInternal> cb) {
        BalancerLoadError loadError = new BalancerLoadError(String.format("Failed when loading data balancer class: %s", this.clusterBalancerClassName), (Throwable)this.clusterBalancerClassLoadException);
        BalancerStatusDescriptionInternal disabledResponse = new BalancerStatusDescriptionInternal(BalancerStatus.LOAD_FAILURE, new HashSet<Integer>(), (Exception)loadError);
        cb.respond(new ApiError(Errors.NONE), Optional.of(disabledResponse));
    }

    @Override
    public void evenClusterLoadStatus(ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<EvenClusterLoadStatusDescriptionInternal> cb) {
        cb.respond(new ApiError(Errors.BALANCER_LOAD_ERROR, String.format("Request to describe the even cluster load status is rejected because the data balancer class (%s) was not loaded successfully", this.clusterBalancerClassName)), Optional.empty());
    }

    @Override
    public void triggerEvenClusterLoadTask(List<String> goalList, ClusterBalanceManager.BalanceManagerOperationInvocationClientCallback cb) {
        cb.respond(new ApiError(Errors.BALANCER_LOAD_ERROR, String.format("Request to trigger the even cluster load task is rejected because the data balancer class (%s) was not loaded successfully", this.clusterBalancerClassName)));
    }

    @Override
    public void computeEvenClusterLoadPlan(List<String> goalList, ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<EvenClusterLoadPlanInternal> cb) {
        cb.respond(new ApiError(Errors.BALANCER_LOAD_ERROR, String.format("Request to trigger the even cluster load task is rejected because the data balancer class (%s) was not loaded successfully", this.clusterBalancerClassName)), Optional.empty());
    }

    @Override
    public void onBrokerHealthChange(Set<Integer> newlyPromotedBrokers, Set<Integer> newlyDemotedBrokers, AliveBrokersMetadata aliveBrokersMetadata) {
    }

    @Override
    public void cellLoad(List<Integer> cellIds, ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<CellLoadDescriptionInternal> cb) {
    }
}

