/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.ConfigFlag$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.Deserializer$;
import kafka.durability.events.DeserializerTrait;
import kafka.durability.events.HealthCheckEvent;
import kafka.durability.events.broker.DeletePartitionEvent;
import kafka.durability.events.broker.DeleteRecordsEvent;
import kafka.durability.events.broker.EpochChangeEvent;
import kafka.durability.events.broker.InjectStateEvent;
import kafka.durability.events.broker.IsrExpandEvent;
import kafka.durability.events.broker.OffsetChangeEvent;
import kafka.durability.events.broker.RetentionChangeEvent;
import kafka.durability.events.broker.RetentionType$;
import kafka.durability.events.broker.StartOffsetChangeEvent;
import kafka.durability.events.broker.StartOffsetChangeEvent$;
import kafka.durability.events.controller.AbstractControllerDurabilityEvent;
import kafka.durability.materialization.AbstractDurabilityEventsMaterialize;
import kafka.durability.materialization.validation.BrokerValidator;
import kafka.server.ReplicaManager;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tMe\u0001B\u0013'\u00015B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\ts\u0001\u0011)\u0019!C!u!I\u0001\t\u0001B\u0001B\u0003%1(\u0011\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"A\u0011\n\u0001B\u0001B\u0003%!\nC\u0003X\u0001\u0011\u0005\u0001\f\u0003\u0005_\u0001\t\u0007I\u0011\t\u0014`\u0011\u00191\u0007\u0001)A\u0005A\")q\r\u0001C!Q\"Aa\u000f\u0001EC\u0002\u0013\u0005s\u000fC\u0004\u0002\u0006\u0001!\t%a\u0002\t\u000f\u0005E\u0002\u0001\"\u0003\u00024!9\u0011q\n\u0001\u0005\n\u0005E\u0003\u0002CA6\u0001\u0011\u0005a%!\u001c\t\u0015\u0005\u0005\u0005!%A\u0005\u0002\u0019\n\u0019\t\u0003\u0006\u0002\u001a\u0002\t\n\u0011\"\u0001'\u00037C\u0001\"a(\u0001\t\u00031\u0013\u0011\u0015\u0005\u000b\u0003+\u0004\u0011\u0013!C\u0001M\u0005\r\u0005BCAl\u0001E\u0005I\u0011\u0001\u0014\u0002\u001c\"9\u0011\u0011\u001c\u0001\u0005\n\u0005m\u0007\"CA~\u0001E\u0005I\u0011BA\u007f\u0011!\u0011\t\u0001\u0001C\u0001M\t\r\u0001B\u0003B\t\u0001E\u0005I\u0011\u0001\u0014\u0002\u0004\"Q!1\u0003\u0001\u0012\u0002\u0013\u0005a%a'\t\u0011\tU\u0001\u0001\"\u0001'\u0005/A!Ba\n\u0001#\u0003%\tAJAB\u0011!\u0011I\u0003\u0001C\u0001M\t-\u0002\u0002\u0003B\u0018\u0001\u0011\u0005aE!\r\t\u0015\t\u0005\u0003!%A\u0005\u0002\u0019\n\u0019\t\u0003\u0005\u0003D\u0001!\tA\nB#\u0011!\u0011\u0019\u0006\u0001C\u0001M\tU\u0003b\u0002B1\u0001\u0011%!1\r\u0005\b\u0005[\u0002A\u0011\u0001B8\u0011\u001d\u0011y\b\u0001C\u0001\u0005\u0003CqAa\"\u0001\t\u0003\u0011I\tC\u0005\u0003\u0012\u0002\t\n\u0011\"\u0001\u0002\u0004\n\t#I]8lKJ$UO]1cS2LG/_#wK:$8/T1uKJL\u0017\r\\5{K*\u0011q\u0005K\u0001\u0010[\u0006$XM]5bY&T\u0018\r^5p]*\u0011\u0011FK\u0001\u000bIV\u0014\u0018MY5mSRL(\"A\u0016\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\f\t\u0003_Aj\u0011AJ\u0005\u0003c\u0019\u00121%\u00112tiJ\f7\r\u001e#ve\u0006\u0014\u0017\u000e\\5us\u00163XM\u001c;t\u001b\u0006$XM]5bY&TX-\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0005Q:T\"A\u001b\u000b\u0005YR\u0013AB:feZ,'/\u0003\u00029k\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018A\u00013c+\u0005Y\u0004C\u0001\u001f?\u001b\u0005i$BA\u001d)\u0013\tyTH\u0001\u0007EkJ\f'-\u001b7jif$%)A\u0002eE\u0002J!!\u000f\u0019\u0002\u0011I,\u0007o\u001c:uKJ\u0004\"\u0001R$\u000e\u0003\u0015S!A\u0012\u0015\u0002\u000b\u0005,H-\u001b;\n\u0005!+%!D!vI&$(+\u001a9peR,'/\u0001\u0003uS6,\u0007CA&V\u001b\u0005a%BA'O\u0003\u0015)H/\u001b7t\u0015\ty\u0005+\u0001\u0004d_6lwN\u001c\u0006\u0003WES!AU*\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0016aA8sO&\u0011a\u000b\u0014\u0002\u0005)&lW-\u0001\u0004=S:LGO\u0010\u000b\u00063j[F,\u0018\t\u0003_\u0001AQA\r\u0004A\u0002MBQ!\u000f\u0004A\u0002mBQA\u0011\u0004A\u0002\rCQ!\u0013\u0004A\u0002)\u000b\u0011B^1mS\u0012\fGo\u001c:\u0016\u0003\u0001\u0004\"!\u00193\u000e\u0003\tT!a\u0019\u0014\u0002\u0015Y\fG.\u001b3bi&|g.\u0003\u0002fE\ny!I]8lKJ4\u0016\r\\5eCR|'/\u0001\u0006wC2LG-\u0019;pe\u0002\n!\u0002\\8hO\u0016\u0014h*Y7f+\u0005I\u0007C\u00016t\u001d\tY\u0017\u000f\u0005\u0002m_6\tQN\u0003\u0002oY\u00051AH]8pizR\u0011\u0001]\u0001\u0006g\u000e\fG.Y\u0005\u0003e>\fa\u0001\u0015:fI\u00164\u0017B\u0001;v\u0005\u0019\u0019FO]5oO*\u0011!o\\\u0001\u0007Y><w-\u001a:\u0016\u0003a\u00042!_A\u0001\u001b\u0005Q(BA>}\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tih0\u0001\u0005usB,7/\u00194f\u0015\u0005y\u0018aA2p[&\u0019\u00111\u0001>\u0003\r1{wmZ3s\u0003-i\u0017\r^3sS\u0006d\u0017N_3\u0015\t\u0005%\u0011\u0011\u0003\t\u0005\u0003\u0017\ti!D\u0001p\u0013\r\tya\u001c\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019b\u0003a\u0001\u0003+\taA]3d_J$\u0007\u0003CA\f\u0003C\t)#!\n\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\t\u0001bY8ogVlWM\u001d\u0006\u0004\u0003?\u0001\u0016aB2mS\u0016tGo]\u0005\u0005\u0003G\tIB\u0001\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3\u0011\r\u0005-\u0011qEA\u0016\u0013\r\tIc\u001c\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003\u0017\ti#C\u0002\u00020=\u0014AAQ=uK\u0006AR.\u0019;fe&\fG.\u001b>f\u0013:TWm\u0019;fIN#\u0018\r^3\u0015\t\u0005U\u00121\b\t\u0005\u0003\u0017\t9$C\u0002\u0002:=\u0014A!\u00168ji\"9\u0011Q\b\u0007A\u0002\u0005}\u0012\u0001E5oU\u0016\u001cGo\u0015;bi\u0016,e/\u001a8u!\u0011\t\t%a\u0013\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\naA\u0019:pW\u0016\u0014(bAA%Q\u00051QM^3oiNLA!!\u0014\u0002D\t\u0001\u0012J\u001c6fGR\u001cF/\u0019;f\u000bZ,g\u000e^\u0001\u001d[\u0006$XM]5bY&TXm\u00144gg\u0016$8\t[1oO\u0016,e/\u001a8u)!\t)$a\u0015\u0002^\u0005\u001d\u0004bBA+\u001b\u0001\u0007\u0011qK\u0001\u0012_\u001a47/\u001a;DQ\u0006tw-Z#wK:$\b\u0003BA!\u00033JA!a\u0017\u0002D\t\trJ\u001a4tKR\u001c\u0005.\u00198hK\u00163XM\u001c;\t\u000f\u0005}S\u00021\u0001\u0002b\u0005)1\u000f^1uKB\u0019A(a\u0019\n\u0007\u0005\u0015TH\u0001\bQCJ$\u0018\u000e^5p]N#\u0018\r^3\t\r\u0005%T\u00021\u0001j\u0003!iW\r^1eCR\f\u0017\u0001H7bi\u0016\u0014\u0018.\u00197ju\u0016$U\r\\3uKJ+7m\u001c:e\u000bZ,g\u000e\u001e\u000b\u000b\u0003k\ty'!\u001f\u0002|\u0005u\u0004bBA9\u001d\u0001\u0007\u00111O\u0001\u0013I\u0016dW\r^3SK\u000e|'\u000fZ:Fm\u0016tG\u000f\u0005\u0003\u0002B\u0005U\u0014\u0002BA<\u0003\u0007\u0012!\u0003R3mKR,'+Z2pe\u0012\u001cXI^3oi\"9\u0011q\f\bA\u0002\u0005\u0005\u0004\u0002CA5\u001dA\u0005\t\u0019A5\t\u0013\u0005}d\u0002%AA\u0002\u0005%\u0011aG;qI\u0006$Xm\u00148ms\u000e{W.\\5u'R\f'\u000f^(gMN,G/\u0001\u0014nCR,'/[1mSj,G)\u001a7fi\u0016\u0014VmY8sI\u00163XM\u001c;%I\u00164\u0017-\u001e7uIM*\"!!\"+\u0007%\f9i\u000b\u0002\u0002\nB!\u00111RAK\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006E\u0015!C;oG\",7m[3e\u0015\r\t\u0019j\\\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAL\u0003\u001b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0019j\u0017\r^3sS\u0006d\u0017N_3EK2,G/\u001a*fG>\u0014H-\u0012<f]R$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003;SC!!\u0003\u0002\b\u0006yR.\u0019;fe&\fG.\u001b>f\u0011&<\u0007nV1uKJl\u0017M]6DQ\u0006tw-Z:\u0015!\u0005U\u00121UAX\u0003s\u000b\u0019-!4\u0002P\u0006E\u0007bBAS#\u0001\u0007\u0011qU\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\tI+a+\u000e\u00039K1!!,O\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!!-\u0012\u0001\u0004\t\u0019,A\u0003fa>\u001c\u0007\u000e\u0005\u0003\u0002\f\u0005U\u0016bAA\\_\n\u0019\u0011J\u001c;\t\u000f\u0005m\u0016\u00031\u0001\u0002>\u0006\u0019\u0001n^7\u0011\t\u0005-\u0011qX\u0005\u0004\u0003\u0003|'\u0001\u0002'p]\u001eDq!!2\u0012\u0001\u0004\t9-A\u0002jgJ\u0004RA[Ae\u0003gK1!a3v\u0005\r\u0019V\r\u001e\u0005\b\u0003?\n\u0002\u0019AA1\u0011!\tI'\u0005I\u0001\u0002\u0004I\u0007\"CAj#A\u0005\t\u0019AA\u0005\u0003Y!(/[4hKJ,GMQ=Fa>\u001c\u0007n\u00115b]\u001e,\u0017!K7bi\u0016\u0014\u0018.\u00197ju\u0016D\u0015n\u001a5XCR,'/\\1sW\u000eC\u0017M\\4fg\u0012\"WMZ1vYR$c'A\u0015nCR,'/[1mSj,\u0007*[4i/\u0006$XM]7be.\u001c\u0005.\u00198hKN$C-\u001a4bk2$HeN\u0001\"[\u0006\\WmR3oKJL7m\u0015;beR|eMZ:fi\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u000b\u000f\u0003;\f\u0019/!<\u0002p\u0006M\u0018Q_A}!\u0011\t\t%a8\n\t\u0005\u0005\u00181\t\u0002\u0017'R\f'\u000f^(gMN,Go\u00115b]\u001e,WI^3oi\"9\u0011Q\u001d\u000bA\u0002\u0005\u001d\u0018AA5e!\u0011\tI+!;\n\u0007\u0005-hJ\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\"9\u0011\u0011\u0017\u000bA\u0002\u0005M\u0006bBAy)\u0001\u0007\u0011QX\u0001\fgR\f'\u000f^(gMN,G\u000fC\u0004\u0002<R\u0001\r!!0\t\u000f\u0005]H\u00031\u0001\u00024\u00061an\u001c3f\u0013\u0012D\u0011\"!2\u0015!\u0003\u0005\r!a2\u0002W5\f7.Z$f]\u0016\u0014\u0018nY*uCJ$xJ\u001a4tKR\u001c\u0005.\u00198hK\u00163XM\u001c;%I\u00164\u0017-\u001e7uIY*\"!a@+\t\u0005\u001d\u0017qQ\u0001\u0017[\u0006$XM]5bY&TXm\u0015;beR|eMZ:fiRQ\u0011Q\u0007B\u0003\u0005\u0013\u0011YA!\u0004\t\u000f\t\u001da\u00031\u0001\u0002^\u000612\u000f^1si>3gm]3u\u0007\"\fgnZ3Fm\u0016tG\u000fC\u0004\u0002`Y\u0001\r!!\u0019\t\u0011\u0005%d\u0003%AA\u0002%D\u0011Ba\u0004\u0017!\u0003\u0005\r!!\u0003\u0002\u0017Y\fG.\u001b3bi\u0016Du+T\u0001![\u0006$XM]5bY&TXm\u0015;beR|eMZ:fi\u0012\"WMZ1vYR$3'\u0001\u0011nCR,'/[1mSj,7\u000b^1si>3gm]3uI\u0011,g-Y;mi\u0012\"\u0014aG7bi\u0016\u0014\u0018.\u00197ju\u0016,\u0005o\\2i\u0007\"\fgnZ3Fm\u0016tG\u000f\u0006\u0005\u00026\te!1\u0005B\u0013\u0011\u001d\u0011Y\"\u0007a\u0001\u0005;\t\u0001#\u001a9pG\"\u001c\u0005.\u00198hK\u00163XM\u001c;\u0011\t\u0005\u0005#qD\u0005\u0005\u0005C\t\u0019E\u0001\tFa>\u001c\u0007n\u00115b]\u001e,WI^3oi\"9\u0011qL\rA\u0002\u0005\u0005\u0004\u0002CA53A\u0005\t\u0019A5\u0002K5\fG/\u001a:jC2L'0Z#q_\u000eD7\t[1oO\u0016,e/\u001a8uI\u0011,g-Y;mi\u0012\u001a\u0014A\u0005;sk:\u001c\u0017\r^3Fa>\u001c\u0007n\u00115bS:$B!!\u000e\u0003.!9\u0011qL\u000eA\u0002\u0005\u0005\u0014!G7bi\u0016\u0014\u0018.\u00197ju\u0016L5KU#ya\u0006tG-\u0012<f]R$\u0002\"!\u000e\u00034\tu\"q\b\u0005\b\u0005ka\u0002\u0019\u0001B\u001c\u00039I7O]#ya\u0006tG-\u0012<f]R\u0004B!!\u0011\u0003:%!!1HA\"\u00059I5O]#ya\u0006tG-\u0012<f]RDq!a\u0018\u001d\u0001\u0004\t\t\u0007\u0003\u0005\u0002jq\u0001\n\u00111\u0001j\u0003\rj\u0017\r^3sS\u0006d\u0017N_3J'J+\u0005\u0010]1oI\u00163XM\u001c;%I\u00164\u0017-\u001e7uIM\nq$\\1uKJL\u0017\r\\5{KJ+G/\u001a8uS>t7\t[1oO\u0016,e/\u001a8u)\u0019\t)Da\u0012\u0003R!9!\u0011\n\u0010A\u0002\t-\u0013\u0001\u0006:fi\u0016tG/[8o\u0007\"\fgnZ3Fm\u0016tG\u000f\u0005\u0003\u0002B\t5\u0013\u0002\u0002B(\u0003\u0007\u0012ACU3uK:$\u0018n\u001c8DQ\u0006tw-Z#wK:$\bbBA0=\u0001\u0007\u0011\u0011M\u0001\u001b[\u0006$XM]5bY&TX\rR3mKR,\u0007+\u0019:uSRLwN\u001c\u000b\u0005\u0003k\u00119\u0006C\u0004\u0003Z}\u0001\rAa\u0017\u0002)\u0011,G.\u001a;f!\u0006\u0014H/\u001b;j_:,e/\u001a8u!\u0011\t\tE!\u0018\n\t\t}\u00131\t\u0002\u0015\t\u0016dW\r^3QCJ$\u0018\u000e^5p]\u00163XM\u001c;\u0002!5\fG/\u001a:jC2L'0Z*uCR,G\u0003CA\u001b\u0005K\u00129G!\u001b\t\u000f\u0005}\u0003\u00051\u0001\u0002b!9\u0011\u0011\u0017\u0011A\u0002\u0005M\u0006b\u0002B6A\u0001\u0007\u0011q]\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\f!c\u001d;bY\u0016$v\u000e]5d\u0013\u0012,e/\u001a8ugR1\u0011\u0011\u0002B9\u0005{BqAa\u001d\"\u0001\u0004\u0011)(A\u0003fm\u0016tG\u000f\u0005\u0003\u0003x\teTBAA$\u0013\u0011\u0011Y(a\u0012\u0003/\u0005\u00137\u000f\u001e:bGR$UO]1cS2LG/_#wK:$\bbBA0C\u0001\u0007\u0011\u0011M\u0001\u001aG\",7m['jgNLgn\u001a+pa&\u001cG)\u001a7fi&|g\u000e\u0006\u0004\u00026\t\r%Q\u0011\u0005\b\u0005g\u0012\u0003\u0019\u0001B;\u0011\u001d\tyF\ta\u0001\u0003C\n\u0011\u0003[1oI2,7\u000b^1mK\u00163XM\u001c;t)!\tIAa#\u0003\u000e\n=\u0005b\u0002B:G\u0001\u0007!Q\u000f\u0005\b\u0003?\u001a\u0003\u0019AA1\u0011!\tIg\tI\u0001\u0002\u0004I\u0017a\u00075b]\u0012dWm\u0015;bY\u0016,e/\u001a8ug\u0012\"WMZ1vYR$3\u0007")
public class BrokerDurabilityEventsMaterialize
extends AbstractDurabilityEventsMaterialize {
    private Logger logger;
    private final ReplicaManager replicaManager;
    private final AuditReporter reporter;
    private final BrokerValidator validator;
    private volatile boolean bitmap$0;

    @Override
    public DurabilityDB db() {
        return super.db();
    }

    @Override
    public BrokerValidator validator() {
        return this.validator;
    }

    @Override
    public String loggerName() {
        return BrokerDurabilityEventsMaterialize.class.getName();
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean materialize(ConsumerRecord<byte[], byte[]> record) {
        void deserialize_value;
        void deserialize_key;
        byte[] byArray = (byte[])((byte[])record.value()).clone();
        byte[] byArray2 = (byte[])((byte[])record.key()).clone();
        Deserializer$ deserialize_this = Deserializer$.MODULE$;
        Object var15_4 = null;
        byArray2 = null;
        byArray = null;
        AbstractDurabilityEvent event = DeserializerTrait.deserialize$(deserialize_this, (byte[])deserialize_key, (byte[])deserialize_value);
        String metadata = new StringBuilder(24).append("Durability audits topic ").append(Utils$.MODULE$.consumerRecordMetadata(record)).toString();
        if (event instanceof HealthCheckEvent) {
            HealthCheckEvent healthCheckEvent = (HealthCheckEvent)event;
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("DurabilityMaterialization: Materialization request for ").append(event.eventType()).append(" ").append(event).toString());
            if (healthCheckEvent.nodeId() == Utils$.MODULE$.getBrokerId(this.replicaManager)) {
                this.materializeHealthCheck(healthCheckEvent);
            }
            return true;
        }
        if (event instanceof InjectStateEvent) {
            InjectStateEvent injectStateEvent = (InjectStateEvent)event;
            this.materializeInjectedState(injectStateEvent);
            return true;
        }
        Option<PartitionState> stateOpt = this.db().fetchPartitionState(event.topicIdPartition().topicPartition());
        if (stateOpt.isEmpty()) {
            return false;
        }
        PartitionState state = (PartitionState)stateOpt.get();
        if (event.epoch() == state.latestEpoch() && record.timestamp() < state.latestTimestamp()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(104).append("Ignoring event ").append(event).append(" with epoch ").append(event.epoch()).append(" as it's from retry and duplicate.").append("Current epoch is ").append(state.latestEpoch()).append(" and state ts: record ts: ").append(record.timestamp()).toString());
            return false;
        }
        this.checkMissingTopicDeletion(event, state);
        if (event.epoch() < state.latestEpoch() || this.staleTopicIdEvents(event, state)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Ignoring event ").append(event).append(". Current state is ").append(state).toString());
            return this.handleStaleEvents(event, state, metadata);
        }
        state.latestTimestamp_$eq(record.timestamp());
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("DurabilityMaterialization: Materialization request for ").append(event.eventType()).append(" ").append(event).append(" for state: ").append(state).toString());
        if (event instanceof OffsetChangeEvent) {
            OffsetChangeEvent offsetChangeEvent = (OffsetChangeEvent)event;
            this.materializeOffsetChangeEvent(offsetChangeEvent, state, metadata);
        } else if (event instanceof DeleteRecordsEvent) {
            DeleteRecordsEvent deleteRecordsEvent = (DeleteRecordsEvent)event;
            this.materializeDeleteRecordEvent(deleteRecordsEvent, state, metadata, false);
        } else if (event instanceof EpochChangeEvent) {
            EpochChangeEvent epochChangeEvent = (EpochChangeEvent)event;
            this.materializeEpochChangeEvent(epochChangeEvent, state, metadata);
        } else if (event instanceof IsrExpandEvent) {
            IsrExpandEvent isrExpandEvent = (IsrExpandEvent)event;
            this.materializeISRExpandEvent(isrExpandEvent, state, metadata);
        } else if (event instanceof RetentionChangeEvent) {
            RetentionChangeEvent retentionChangeEvent = (RetentionChangeEvent)event;
            this.materializeRetentionChangeEvent(retentionChangeEvent, state);
        } else if (event instanceof StartOffsetChangeEvent) {
            StartOffsetChangeEvent startOffsetChangeEvent = (StartOffsetChangeEvent)event;
            this.materializeStartOffset(startOffsetChangeEvent, state, metadata, true);
        } else {
            if (event instanceof DeletePartitionEvent) {
                DeletePartitionEvent deletePartitionEvent = (DeletePartitionEvent)event;
                this.materializeDeletePartition(deletePartitionEvent);
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("DurabilityMaterialization: Materialization done for ").append(event).append(" ").append(state).append(" ").append(metadata).toString());
                return true;
            }
            if (event instanceof AbstractControllerDurabilityEvent) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Broker materialization rejected for ControllerDurabilityEvent ").append(event).toString());
                return false;
            }
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("DurabilityMaterialization: Ignoring unexpected durability event type ").append(event.eventType()).append(": ").append(event).append(",").append(" ").append(metadata).toString());
            return false;
        }
        this.materializeState(state, event.epoch(), event.topicIdPartition());
        this.db().addPartition(event.topicIdPartition().topicPartition(), state);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("DurabilityMaterialization: Materialization done for ").append(event).append(" ").append(state).toString());
        return true;
    }

    private void materializeInjectedState(InjectStateEvent injectStateEvent) {
        Option<PartitionState> stateOpt = this.db().fetchPartitionState(injectStateEvent.topicIdPartition().topicPartition());
        if (stateOpt.isEmpty()) {
            return;
        }
        PartitionState state = (PartitionState)stateOpt.get();
        if (injectStateEvent.removePartition()) {
            this.db().deletePartition(injectStateEvent.topicIdPartition().topicPartition());
        } else {
            if (injectStateEvent.epoch() != -1) {
                state.latestEpoch_$eq(injectStateEvent.epoch());
            }
            if (injectStateEvent.highWatermark() != -1L) {
                state.highWatermark_$eq(injectStateEvent.highWatermark());
            }
            if (injectStateEvent.logStartOffset() != -1L) {
                state.committedStartOffset_$eq(injectStateEvent.logStartOffset());
                state.startOffset_$eq(injectStateEvent.logStartOffset());
            }
            if (injectStateEvent.config() != -1L) {
                state.config_$eq(injectStateEvent.config());
            }
            this.db().addPartition(injectStateEvent.topicIdPartition().topicPartition(), state);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Updated the durabilityDB due to injected Event ").append(injectStateEvent).append(" with new state ").append(state).toString());
    }

    private void materializeOffsetChangeEvent(OffsetChangeEvent offsetChangeEvent, PartitionState state, String metadata) {
        this.materializeHighWatermarkChanges(offsetChangeEvent.topicIdPartition().topicPartition(), offsetChangeEvent.epoch(), offsetChangeEvent.highWatermark(), offsetChangeEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(offsetChangeEvent.topicIdPartition(), offsetChangeEvent.epoch(), offsetChangeEvent.logStartOffset(), offsetChangeEvent.highWatermark(), offsetChangeEvent.nodeId(), offsetChangeEvent.isr()), state, metadata, this.materializeStartOffset$default$4());
    }

    public void materializeDeleteRecordEvent(DeleteRecordsEvent deleteRecordsEvent, PartitionState state, String metadata, boolean updateOnlyCommitStartOffset) {
        state.committedStartOffset_$eq(Math.max(state.committedStartOffset(), deleteRecordsEvent.trimOffset()));
        state.lapseWatchStartTime_$eq(0L);
        if (updateOnlyCommitStartOffset) {
            return;
        }
        this.materializeHighWatermarkChanges(deleteRecordsEvent.topicIdPartition().topicPartition(), deleteRecordsEvent.epoch(), deleteRecordsEvent.highWatermark(), deleteRecordsEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(deleteRecordsEvent.topicIdPartition(), deleteRecordsEvent.epoch(), deleteRecordsEvent.logStartOffset(), deleteRecordsEvent.highWatermark(), deleteRecordsEvent.nodeId(), this.makeGenericStartOffsetChangeEvent$default$6()), state, metadata, this.materializeStartOffset$default$4());
    }

    public String materializeDeleteRecordEvent$default$3() {
        return "";
    }

    public boolean materializeDeleteRecordEvent$default$4() {
        return false;
    }

    public void materializeHighWatermarkChanges(TopicPartition topicPartition, int epoch, long hwm, Set<Object> isr, PartitionState state, String metadata, boolean triggeredByEpochChange) {
        this.validator().validateDBHighWatermark(topicPartition, epoch, hwm, state, metadata, triggeredByEpochChange);
        if (this.validator().isInSync(isr)) {
            this.validator().validateLocalLogEndOffset(topicPartition, epoch, hwm, state, metadata);
        }
        state.highWatermark_$eq(hwm);
    }

    public String materializeHighWatermarkChanges$default$6() {
        return "";
    }

    public boolean materializeHighWatermarkChanges$default$7() {
        return false;
    }

    private StartOffsetChangeEvent makeGenericStartOffsetChangeEvent(TopicIdPartition id, int epoch, long startOffset, long hwm, int nodeId, Set<Object> isr) {
        return StartOffsetChangeEvent$.MODULE$.apply(id, epoch, hwm, startOffset, (byte)RetentionType$.MODULE$.Other().id(), -1L, isr, nodeId);
    }

    private Set<Object> makeGenericStartOffsetChangeEvent$default$6() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1}));
    }

    public void materializeStartOffset(StartOffsetChangeEvent startOffsetChangeEvent, PartitionState state, String metadata, boolean validateHWM) {
        block11: {
            block10: {
                Enumeration.Value value;
                Enumeration.Value value2;
                block9: {
                    if (this.validator().isInSync(startOffsetChangeEvent.isr()) && state.committedStartOffset() < startOffsetChangeEvent.logStartOffset() && this.validator().validateDBLogStartOffset(startOffsetChangeEvent, state, metadata)) {
                        this.validator().validateLocalLogStartOffset(startOffsetChangeEvent.topicIdPartition(), startOffsetChangeEvent.logStartOffset(), metadata);
                        state.committedStartOffset_$eq(startOffsetChangeEvent.logStartOffset());
                        state.lapseWatchStartTime_$eq(0L);
                    }
                    if (state.startOffset() <= 0L) {
                        state.committedStartOffset_$eq(Math.max(startOffsetChangeEvent.logStartOffset(), state.committedStartOffset()));
                        state.lapseWatchStartTime_$eq(0L);
                    }
                    if (validateHWM) {
                        this.materializeHighWatermarkChanges(startOffsetChangeEvent.topicIdPartition().topicPartition(), startOffsetChangeEvent.epoch(), startOffsetChangeEvent.highWatermark(), startOffsetChangeEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7());
                    }
                    state.startOffset_$eq(startOffsetChangeEvent.logStartOffset());
                    Enumeration.Value value3 = RetentionType$.MODULE$.apply(startOffsetChangeEvent.retentionType());
                    Enumeration.Value value4 = RetentionType$.MODULE$.SizeBasedRetention();
                    if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                        state.retentionSz_$eq(startOffsetChangeEvent.retentionValue());
                        return;
                    }
                    value2 = RetentionType$.MODULE$.apply(startOffsetChangeEvent.retentionType());
                    value = RetentionType$.MODULE$.TimeBasedRetention();
                    if (value2 != null) break block9;
                    if (value != null) {
                        return;
                    }
                    break block10;
                }
                if (!value2.equals(value)) break block11;
            }
            state.retentionMs_$eq(startOffsetChangeEvent.retentionValue());
            return;
        }
    }

    public String materializeStartOffset$default$3() {
        return "";
    }

    public boolean materializeStartOffset$default$4() {
        return false;
    }

    public void materializeEpochChangeEvent(EpochChangeEvent epochChangeEvent, PartitionState state, String metadata) {
        this.validator().validateDBEpochChange(epochChangeEvent, state, metadata);
        this.materializeHighWatermarkChanges(epochChangeEvent.topicIdPartition().topicPartition(), epochChangeEvent.epoch(), epochChangeEvent.highWatermark(), epochChangeEvent.isr(), state, metadata, true);
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(epochChangeEvent.topicIdPartition(), epochChangeEvent.epoch(), epochChangeEvent.logStartOffset(), epochChangeEvent.highWatermark(), epochChangeEvent.nodeId(), epochChangeEvent.isr()), state, metadata, this.materializeStartOffset$default$4());
        this.validator().validateEpochChangeWithLocal(epochChangeEvent, metadata);
        state.epochChain().put((Object)BoxesRunTime.boxToInteger((int)epochChangeEvent.epoch()), (Object)BoxesRunTime.boxToLong((long)epochChangeEvent.firstOffset()));
        this.truncateEpochChain(state);
    }

    public String materializeEpochChangeEvent$default$3() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public void truncateEpochChain(PartitionState state) {
        if (((Tuple2)state.epochChain().min(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Long$.MODULE$)))._2$mcJ$sp() < state.startOffset() && state.epochChain().size() > 2) {
            BufferedIterator iterator = ((List)state.epochChain().toList().sortWith((Function2 & Serializable)(cur, next) -> BoxesRunTime.boxToBoolean((boolean)BrokerDurabilityEventsMaterialize.$anonfun$truncateEpochChain$1(cur, next)))).iterator().buffered();
            boolean continueLoop = true;
            while (iterator.hasNext() && continueLoop) {
                void var10_9;
                void var6_6;
                void var9_8;
                void var5_5;
                Tuple2 tuple2 = (Tuple2)iterator.next();
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                int curEpoch = tuple2._1$mcI$sp();
                long curFirstOffset = tuple2._2$mcJ$sp();
                if (!iterator.hasNext()) continue;
                Tuple2 tuple22 = (Tuple2)iterator.head();
                if (tuple22 == null) {
                    throw new MatchError(null);
                }
                int nextEpoch = tuple22._1$mcI$sp();
                long nextFirstOffset = tuple22._2$mcJ$sp();
                if (var5_5 < var9_8 && var6_6 <= var10_9) {
                    if (var6_6 < state.startOffset() && var10_9 < state.startOffset()) {
                        state.epochChain().remove((Object)BoxesRunTime.boxToInteger((int)var5_5));
                        continue;
                    }
                    continueLoop = false;
                    continue;
                }
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(117).append("Epoch chain map is not in the sorted order: \ncurrent (Epoch, firstOffset) are (").append((int)var5_5).append(", ").append((long)var6_6).append(")\n").append("next (Epoch, firstOffset) are (").append((int)var9_8).append(", ").append((long)var10_9).append(")").toString());
                }
                continueLoop = false;
            }
            return;
        }
    }

    public void materializeISRExpandEvent(IsrExpandEvent isrExpandEvent, PartitionState state, String metadata) {
        if (Utils$.MODULE$.getBrokerId(this.replicaManager) != isrExpandEvent.expandBrokerId()) {
            return;
        }
        this.validator().validateEpochChainWithLocal(isrExpandEvent.topicIdPartition().topicPartition(), state, metadata);
    }

    public String materializeISRExpandEvent$default$3() {
        return "";
    }

    public void materializeRetentionChangeEvent(RetentionChangeEvent retentionChangeEvent, PartitionState state) {
        if (retentionChangeEvent.timeMs() != state.retentionMs() || retentionChangeEvent.size() != state.retentionSz()) {
            state.committedStartOffset_$eq(Math.max(state.committedStartOffset(), state.startOffset()));
            state.lapseWatchStartTime_$eq(0L);
            state.retentionSz_$eq(retentionChangeEvent.size());
            state.retentionMs_$eq(retentionChangeEvent.timeMs());
        }
        if (retentionChangeEvent.isCompacted()) {
            state.config_$eq(ConfigFlag$.MODULE$.OnceCompacted().id());
            return;
        }
    }

    public void materializeDeletePartition(DeletePartitionEvent deletePartitionEvent) {
        this.db().deletePartition(deletePartitionEvent.topicIdPartition().topicPartition());
    }

    private void materializeState(PartitionState state, int epoch, TopicIdPartition topicIdPartition) {
        if (epoch != -1) {
            state.latestEpoch_$eq(epoch);
        }
        state.topicId_$eq(topicIdPartition.topicId());
    }

    public boolean staleTopicIdEvents(AbstractDurabilityEvent event, PartitionState state) {
        Uuid uuid = state.topicId();
        Uuid uuid2 = Uuid.ZERO_UUID;
        if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
            Uuid uuid3 = event.topicIdPartition().topicId();
            Uuid uuid4 = Uuid.ZERO_UUID;
            if (!(uuid3 != null ? !uuid3.equals(uuid4) : uuid4 != null)) {
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void checkMissingTopicDeletion(AbstractDurabilityEvent event, PartitionState state) {
        v0 = state.topicId();
        var4_3 = Uuid.ZERO_UUID;
        if (!(v0 == null ? var4_3 != null : v0.equals(var4_3) == false)) ** GOTO lbl-1000
        v1 = event.topicIdPartition().topicId();
        var5_4 = Uuid.ZERO_UUID;
        if (!(v1 == null ? var5_4 != null : v1.equals(var5_4) == false)) ** GOTO lbl-1000
        v2 = event.topicIdPartition().topicId();
        var6_5 = state.topicId();
        if (v2 == null ? var6_5 != null : v2.equals(var6_5) == false) {
            reset = true;
        } else lbl-1000:
        // 3 sources

        {
            v3 = event instanceof EpochChangeEvent ? (var7_7 = (EpochChangeEvent)event).epoch() == 0 && var7_7.firstOffset() == 0L && var7_7.highWatermark() <= 0L : (reset = false);
        }
        if (reset) {
            this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkMissingTopicDeletion$1(kafka.durability.events.AbstractDurabilityEvent kafka.durability.db.PartitionState ), ()Ljava/lang/String;)((AbstractDurabilityEvent)event, (PartitionState)state));
            state.reset();
            state.topicId_$eq(event.topicIdPartition().topicId());
            this.reporter.resetTopicPartition(event.topicIdPartition().topicPartition());
            return;
        }
    }

    public boolean handleStaleEvents(AbstractDurabilityEvent event, PartitionState state, String metadata) {
        if (event instanceof DeleteRecordsEvent) {
            DeleteRecordsEvent deleteRecordsEvent = (DeleteRecordsEvent)event;
            this.materializeDeleteRecordEvent(deleteRecordsEvent, state, metadata, true);
            return true;
        }
        return false;
    }

    public String handleStaleEvents$default$3() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$truncateEpochChain$1(Tuple2 cur, Tuple2 next) {
        return cur._1$mcI$sp() < next._1$mcI$sp();
    }

    public static final /* synthetic */ String $anonfun$checkMissingTopicDeletion$1(AbstractDurabilityEvent event$2, PartitionState state$3) {
        return new StringBuilder(44).append("Durability partition reset for ").append(event$2).append(" old topicID ").append(state$3.topicId()).toString();
    }

    public BrokerDurabilityEventsMaterialize(ReplicaManager replicaManager, DurabilityDB db, AuditReporter reporter, Time time) {
        this.replicaManager = replicaManager;
        this.reporter = reporter;
        super(db, reporter, time);
        this.validator = new BrokerValidator(replicaManager, reporter, time);
    }
}

