/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import kafka.log.AbstractLog;
import kafka.log.LogCleaner$;
import kafka.log.LogManager;
import kafka.log.SegmentDeletionThrottlerConfig;
import kafka.log.SegmentDeletionThrottlerConfig$;
import kafka.log.TierLogComponents;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer$;
import kafka.server.ProducerIdQuotaManager;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class LogManager$ {
    public static final LogManager$ MODULE$ = new LogManager$();
    private static final String LockFileName = ".lock";
    private static final String RecoveryPointCheckpointFile = "recovery-point-offset-checkpoint";
    private static final String LogStartOffsetCheckpointFile = "log-start-offset-checkpoint";

    public String LockFileName() {
        return LockFileName;
    }

    public boolean waitForAllToComplete(Seq<Future<?>> jobs, Function1<Throwable, BoxedUnit> callback) {
        return jobs.count((Function1 & Serializable)future -> BoxesRunTime.boxToBoolean((boolean)LogManager$.$anonfun$waitForAllToComplete$1(callback, future))) == 0;
    }

    public String RecoveryPointCheckpointFile() {
        return RecoveryPointCheckpointFile;
    }

    public String LogStartOffsetCheckpointFile() {
        return LogStartOffsetCheckpointFile;
    }

    public LogManager apply(KafkaConfig config, Seq<String> initialOfflineDirs, ConfigRepository configRepository, Scheduler kafkaScheduler, Time time, BrokerTopicStats brokerTopicStats, Metrics metrics, LogDirFailureChannel logDirFailureChannel, TierLogComponents tierLogComponents, boolean keepPartitionMetadataFile, Option<ProducerIdQuotaManager> producerIdQuotaManager, Optional<E2EChecksumStore> checksumStoreOpt) {
        Map<String, Object> defaultProps = config.extractLogConfigMap();
        KafkaServer$.MODULE$.augmentWithKafkaConfig(defaultProps, config);
        LogConfig.validateBrokerLogConfigValues(defaultProps, (boolean)false);
        LogConfig defaultLogConfig = new LogConfig(defaultProps);
        CleanerConfig cleanerConfig = LogCleaner$.MODULE$.cleanerConfig(config);
        Seq x$1 = (Seq)config.logDirs().map((Function1 & Serializable)x$28 -> new File((String)x$28).getAbsoluteFile());
        Seq x$2 = (Seq)initialOfflineDirs.map((Function1 & Serializable)x$29 -> new File((String)x$29).getAbsoluteFile());
        int x$6 = Predef$.MODULE$.Integer2int(config.numRecoveryThreadsPerDataDir());
        long x$7 = Predef$.MODULE$.Long2long(config.logFlushSchedulerIntervalMs());
        long x$8 = config.logFlushOffsetCheckpointIntervalMs();
        long x$9 = config.logFlushStartOffsetCheckpointIntervalMs();
        int x$10 = Predef$.MODULE$.Integer2int(config.confluentConfig().tierPartitionStateCommitIntervalMs());
        long x$11 = Predef$.MODULE$.Long2long(config.logCleanupIntervalMs());
        SegmentDeletionThrottlerConfig x$12 = new SegmentDeletionThrottlerConfig(time, config, SegmentDeletionThrottlerConfig$.MODULE$.DefaultDiskCheckDelayMs());
        int x$13 = Predef$.MODULE$.Integer2int(config.transactionMaxTimeoutMs());
        ProducerStateManagerConfig x$14 = new ProducerStateManagerConfig(Predef$.MODULE$.Integer2int(config.producerIdExpirationMs()), Predef$.MODULE$.Boolean2boolean(config.transactionPartitionVerificationEnable()));
        int x$15 = Predef$.MODULE$.Integer2int(config.producerIdExpirationCheckIntervalMs());
        MetadataVersion x$24 = config.interBrokerProtocolVersion();
        boolean x$26 = config.migrationEnabled();
        return new LogManager((Seq<File>)x$1, (Seq<File>)x$2, configRepository, defaultLogConfig, cleanerConfig, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, producerIdQuotaManager, x$24, kafkaScheduler, brokerTopicStats, metrics, logDirFailureChannel, tierLogComponents, time, keepPartitionMetadataFile, checksumStoreOpt, x$26);
    }

    /*
     * WARNING - void declaration
     */
    public void createProducerStateSensors(Metrics metrics) {
        void add_stat;
        void add_stat2;
        void add_metricName;
        void add_stat3;
        Sensor expiredProducersRestoredSensor = metrics.sensor("ExpiredProducersRestored");
        Meter meter = new Meter(metrics.metricName("expired-producers-restored-rate", "log-manager-metrics", "The number of non zero sequences (restoring an expired producer) per second found on new producer state."), metrics.metricName("expired-producers-restored-total", "log-manager-metrics", "The total number of non zero sequences (restoring an expired producer) found on new producer state"));
        if (expiredProducersRestoredSensor == null) {
            throw null;
        }
        expiredProducersRestoredSensor.add((CompoundStat)add_stat3, null);
        meter = null;
        Sensor duplicateSequenceTimeSensor = metrics.sensor("DuplicateSequenceTime");
        Max max = new Max();
        MetricName metricName = metrics.metricName("duplicate-sequence-time-max", "log-manager-metrics", "The max time between duplicate batches");
        if (duplicateSequenceTimeSensor == null) {
            throw null;
        }
        duplicateSequenceTimeSensor.add((MetricName)add_metricName, (MeasurableStat)add_stat2, null);
        metricName = null;
        max = null;
        Avg avg = new Avg();
        MetricName add_metricName2 = metrics.metricName("duplicate-sequence-time-avg", "log-manager-metrics", "The avg time between duplicate batches");
        duplicateSequenceTimeSensor.add(add_metricName2, (MeasurableStat)add_stat, null);
    }

    public Iterable<TopicPartition> findStrayReplicas(int brokerId, TopicsImage newTopicsImage, Iterable<AbstractLog> logs) {
        return (Iterable)logs.flatMap((Function1 & Serializable)log -> {
            int partitionId;
            Uuid topicId = (Uuid)log.topicId().getOrElse((Function0 & Serializable)() -> {
                throw new RuntimeException(new StringBuilder(87).append("The log dir ").append(log).append(" does not have a topic ID, ").append("which is not allowed when running in KRaft mode.").toString());
            });
            Option option = Option$.MODULE$.apply((Object)newTopicsImage.getPartition(topicId, partitionId = log.topicPartition().partition()));
            if (option instanceof Some) {
                PartitionRegistration partition = (PartitionRegistration)((Some)option).value();
                if (!ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Object)BoxesRunTime.boxToInteger((int)brokerId))) {
                    BrokerMetadataPublisher$ info_this = BrokerMetadataPublisher$.MODULE$;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = LogManager$.$anonfun$findStrayReplicas$3(log, partition, brokerId);
                        Object var9_8 = null;
                        info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                    }
                    Object var7_7 = null;
                    return new Some((Object)log.topicPartition());
                }
                return None$.MODULE$;
            }
            if (None$.MODULE$.equals(option)) {
                BrokerMetadataPublisher$ info_this = BrokerMetadataPublisher$.MODULE$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = LogManager$.$anonfun$findStrayReplicas$4(log, topicId);
                    Object var10_10 = null;
                    info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                }
                Object var8_9 = null;
                return new Some((Object)log.topicPartition());
            }
            throw new MatchError((Object)option);
        });
    }

    public Iterable<TopicPartition> findStrayReplicas(int brokerId, LeaderAndIsrRequest request, Iterable<AbstractLog> logs) {
        AbstractControlRequest.Type type = request.requestType();
        AbstractControlRequest.Type type2 = AbstractControlRequest.Type.FULL;
        if (type == null ? type2 != null : !type.equals(type2)) {
            throw new RuntimeException("Cannot use incremental LeaderAndIsrRequest to find strays.");
        }
        HashMap partitions = new HashMap();
        request.data().topicStates().forEach(topicState -> topicState.partitionStates().forEach(partition -> partitions.put(new TopicPartition(topicState.topicName(), partition.partitionIndex()), topicState.topicId())));
        return (Iterable)logs.flatMap((Function1 & Serializable)log -> {
            Uuid topicId = (Uuid)log.topicId().getOrElse((Function0 & Serializable)() -> {
                throw new RuntimeException(new StringBuilder(87).append("The log dir ").append(log).append(" does not have a topic ID, ").append("which is not allowed when running in KRaft mode.").toString());
            });
            Option option = Option$.MODULE$.apply(partitions.get(log.topicPartition()));
            if (option instanceof Some) {
                Uuid id = (Uuid)((Some)option).value();
                if (id.equals((Object)topicId)) {
                    return None$.MODULE$;
                }
                BrokerMetadataPublisher$ info_this = BrokerMetadataPublisher$.MODULE$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = LogManager$.$anonfun$findStrayReplicas$9(log, id, topicId);
                    Object var7_6 = null;
                    info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                }
                Object var5_5 = null;
                return new Some((Object)log.topicPartition());
            }
            if (None$.MODULE$.equals(option)) {
                BrokerMetadataPublisher$ info_this = BrokerMetadataPublisher$.MODULE$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = LogManager$.$anonfun$findStrayReplicas$10(log);
                    Object var8_8 = null;
                    info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                }
                Object var6_7 = null;
                return new Some((Object)log.topicPartition());
            }
            throw new MatchError((Object)option);
        });
    }

    public static final /* synthetic */ boolean $anonfun$waitForAllToComplete$1(Function1 callback$1, Future future) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> future.get());
        if (try_ instanceof Success) {
            return false;
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            callback$1.apply((Object)e);
            return true;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ String $anonfun$findStrayReplicas$3(AbstractLog log$6, PartitionRegistration partition$1, int brokerId$1) {
        return new StringBuilder(91).append("Found stray log dir ").append(log$6).append(": the current replica assignment ").append(partition$1.replicas).append(" ").append("does not contain the local brokerId ").append(brokerId$1).append(".").toString();
    }

    public static final /* synthetic */ String $anonfun$findStrayReplicas$4(AbstractLog log$6, Uuid topicId$5) {
        return new StringBuilder(71).append("Found stray log dir ").append(log$6).append(": the topicId ").append(topicId$5).append(" does not exist in the metadata image").toString();
    }

    public static final /* synthetic */ String $anonfun$findStrayReplicas$9(AbstractLog log$7, Uuid id$1, Uuid topicId$6) {
        return new StringBuilder(68).append("Found stray log dir ").append(log$7).append(": this partition now exists with topic ID ").append(id$1).append(" not ").append(topicId$6).append(".").toString();
    }

    public static final /* synthetic */ String $anonfun$findStrayReplicas$10(AbstractLog log$7) {
        return new StringBuilder(88).append("Found stray log dir ").append(log$7).append(": this partition does not exist in the new full LeaderAndIsrRequest.").toString();
    }

    private LogManager$() {
    }
}

