/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.server.AlterPartitionItem;
import kafka.server.AlterPartitionManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.NodeToControllerChannelManager;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.Scheduler;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001\u0002\u000e\u001c\u0001\u0001B\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\tm\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003:\u0011!1\u0005A!b\u0001\n\u00039\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u0011A\u0003!Q1A\u0005\u0002EC\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t-\u0002\u0011)\u0019!C\u0001/\"Aa\f\u0001B\u0001B\u0003%\u0001\f\u0003\u0005`\u0001\t\u0015\r\u0011\"\u0001a\u0011!9\u0007A!A!\u0002\u0013\t\u0007\"\u00025\u0001\t\u0003I\u0007\u0002C9\u0001\u0005\u0004%\ta\u0007:\t\u000f\u0005\r\u0001\u0001)A\u0005g\"I\u0011Q\u0001\u0001C\u0002\u0013%\u0011q\u0001\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\n!9\u00111\u0004\u0001\u0005B\u0005u\u0001bBA\u0013\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003O\u0001A\u0011IA\u0015\u0011!\tY\u0006\u0001C\u00017\u0005u\u0001\u0002CA/\u0001\u0011\u00051$!\b\t\u000f\u0005}\u0003\u0001\"\u0003\u0002b!9\u0011q\u0010\u0001\u0005\n\u0005\u0005\u0005bBAd\u0001\u0011\u0005\u0011\u0011\u001a\u0002\u001d\t\u00164\u0017-\u001e7u\u00032$XM\u001d)beRLG/[8o\u001b\u0006t\u0017mZ3s\u0015\taR$\u0001\u0004tKJ4XM\u001d\u0006\u0002=\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\"O-\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0015*\u001b\u0005Y\u0012B\u0001\u0016\u001c\u0005U\tE\u000e^3s!\u0006\u0014H/\u001b;j_:l\u0015M\\1hKJ\u0004\"\u0001L\u0018\u000e\u00035R!AL\u000f\u0002\u000bU$\u0018\u000e\\:\n\u0005Aj#a\u0002'pO\u001eLgnZ\u0001\u0019G>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014X#A\u001a\u0011\u0005!\"\u0014BA\u001b\u001c\u0005yqu\u000eZ3U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'/A\rd_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\u0005I\u0004C\u0001\u001eD\u001b\u0005Y$B\u0001\u001f>\u0003\u0011)H/\u001b7\u000b\u0005qq$B\u0001\u0010@\u0015\t\u0001\u0015)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011[$!C*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u0005i&lW-F\u0001I!\tIU*D\u0001K\u0015\tq3J\u0003\u0002M}\u000511m\\7n_:L!A\u0014&\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\tEJ|7.\u001a:JIV\t!\u000b\u0005\u0002#'&\u0011Ak\t\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003M\u0011'o\\6fe\u0016\u0003xn\u00195TkB\u0004H.[3s+\u0005A\u0006c\u0001\u0012Z7&\u0011!l\t\u0002\n\rVt7\r^5p]B\u0002\"A\t/\n\u0005u\u001b#\u0001\u0002'p]\u001e\fAC\u0019:pW\u0016\u0014X\t]8dQN+\b\u000f\u001d7jKJ\u0004\u0013aF7fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8TkB\u0004H.[3s+\u0005\t\u0007c\u0001\u0012ZEB\u00111-Z\u0007\u0002I*\u0011A*P\u0005\u0003M\u0012\u0014q\"T3uC\u0012\fG/\u0019,feNLwN\\\u0001\u0019[\u0016$\u0018\rZ1uCZ+'o]5p]N+\b\u000f\u001d7jKJ\u0004\u0013A\u0002\u001fj]&$h\bF\u0004kW2lgn\u001c9\u0011\u0005!\u0002\u0001\"B\u0019\u000e\u0001\u0004\u0019\u0004\"B\u001c\u000e\u0001\u0004I\u0004\"\u0002$\u000e\u0001\u0004A\u0005\"\u0002)\u000e\u0001\u0004\u0011\u0006\"\u0002,\u000e\u0001\u0004A\u0006\"B0\u000e\u0001\u0004\t\u0017\u0001E;og\u0016tG/S:s+B$\u0017\r^3t+\u0005\u0019\b\u0003\u0002;yuzl\u0011!\u001e\u0006\u0003yYT\u0011a^\u0001\u0005U\u00064\u0018-\u0003\u0002zk\n\u0019Q*\u00199\u0011\u0005mdX\"A&\n\u0005u\\%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003Q}L1!!\u0001\u001c\u0005I\tE\u000e^3s!\u0006\u0014H/\u001b;j_:LE/Z7\u0002#Ut7/\u001a8u\u0013N\u0014X\u000b\u001d3bi\u0016\u001c\b%A\bj]\u001ad\u0017n\u001a5u%\u0016\fX/Z:u+\t\tI\u0001\u0005\u0003\u0002\f\u0005UQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\r\u0005$x.\\5d\u0015\r\t\u0019\"^\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\f\u0003\u001b\u0011Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017\u0001E5oM2Lw\r\u001b;SKF,Xm\u001d;!\u0003\u0015\u0019H/\u0019:u)\t\ty\u0002E\u0002#\u0003CI1!a\t$\u0005\u0011)f.\u001b;\u0002\u0011MDW\u000f\u001e3po:\faa];c[&$HCCA\u0016\u0003\u007f\tI%!\u0014\u0002RA1\u0011QFA\u0018\u0003gi!!!\u0005\n\t\u0005E\u0012\u0011\u0003\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003BA\u001b\u0003wi!!a\u000e\u000b\u0007\u0005eR$A\u0002ba&LA!!\u0010\u00028\taA*Z1eKJ\fe\u000eZ%te\"9\u0011\u0011\t\u000bA\u0002\u0005\r\u0013\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o!\rY\u0018QI\u0005\u0004\u0003\u000fZ%\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u001d\tY\u0005\u0006a\u0001\u0003g\tA\u0002\\3bI\u0016\u0014\u0018I\u001c3JgJDa!a\u0014\u0015\u0001\u0004\u0011\u0016aD2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\t\u000f\u0005MC\u00031\u0001\u0002V\u0005!\u0002O]8qC\u001e\fG/Z%n[\u0016$\u0017.\u0019;fYf\u00042AIA,\u0013\r\tIf\t\u0002\b\u0005>|G.Z1o\u0003ai\u0017-\u001f2f!J|\u0007/Y4bi\u0016L5O]\"iC:<Wm]\u0001\u0015G2,\u0017M]%o\r2Lw\r\u001b;SKF,Xm\u001d;\u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\u0005\u0003?\t\u0019\u0007C\u0004\u0002f]\u0001\r!a\u001a\u00027%tg\r\\5hQR\fE\u000e^3s!\u0006\u0014H/\u001b;j_:LE/Z7t!\u0015\tI'!\u001f\u007f\u001d\u0011\tY'!\u001e\u000f\t\u00055\u00141O\u0007\u0003\u0003_R1!!\u001d \u0003\u0019a$o\\8u}%\tA%C\u0002\u0002x\r\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002|\u0005u$aA*fc*\u0019\u0011qO\u0012\u0002\u0019\t,\u0018\u000e\u001c3SKF,Xm\u001d;\u0015\r\u0005\r\u0015\u0011YAb!\u001d\u0011\u0013QQAE\u0003;K1!a\"$\u0005\u0019!V\u000f\u001d7feA!\u00111RAL\u001d\u0011\ti)a%\u000e\u0005\u0005=%bAAI\u0017\u0006A!/Z9vKN$8/\u0003\u0003\u0002\u0016\u0006=\u0015!F!mi\u0016\u0014\b+\u0019:uSRLwN\u001c*fcV,7\u000f^\u0005\u0005\u00033\u000bYJA\u0004Ck&dG-\u001a:\u000b\t\u0005U\u0015q\u0012\t\t\u0003?\u000bI+a+\u000226\u0011\u0011\u0011\u0015\u0006\u0005\u0003G\u000b)+A\u0004nkR\f'\r\\3\u000b\u0007\u0005\u001d6%\u0001\u0006d_2dWm\u0019;j_:L1!_AQ!\rY\u0018QV\u0005\u0004\u0003_[%\u0001B+vS\u0012\u0004B!a-\u0002<:!\u0011QWA\\!\r\tigI\u0005\u0004\u0003s\u001b\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002>\u0006}&AB*ue&twMC\u0002\u0002:\u000eBq!!\u001a\u0019\u0001\u0004\t9\u0007\u0003\u0004\u0002Fb\u0001\raW\u0001\fEJ|7.\u001a:Fa>\u001c\u0007.\u0001\u000fiC:$G.Z!mi\u0016\u0014\b+\u0019:uSRLwN\u001c*fgB|gn]3\u0015\u0019\u0005-\u0017q[Aq\u0003W\fy/!=\u0011\t\u00055\u00171[\u0007\u0003\u0003\u001fT1!!5L\u0003!\u0001(o\u001c;pG>d\u0017\u0002BAk\u0003\u001f\u0014a!\u0012:s_J\u001c\bbBAm3\u0001\u0007\u00111\\\u0001\u000ee\u0016\fX/Z:u\u0011\u0016\fG-\u001a:\u0011\t\u00055\u0015Q\\\u0005\u0005\u0003?\fyIA\u0007SKF,Xm\u001d;IK\u0006$WM\u001d\u0005\b\u0003GL\u0002\u0019AAs\u0003I\tG\u000e^3s!\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9\u0011\t\u00055\u0015q]\u0005\u0005\u0003S\fyI\u0001\fBYR,'\u000fU1si&$\u0018n\u001c8SKN\u0004xN\\:f\u0011\u0019\ti/\u0007a\u00017\u0006y1/\u001a8u\u0005J|7.\u001a:Fa>\u001c\u0007\u000eC\u0004\u0002fe\u0001\r!a\u001a\t\u000f\u0005M\u0018\u00041\u0001\u0002\u001e\u0006yAo\u001c9jG:\u000bW.Z:Cs&#7\u000f")
public class DefaultAlterPartitionManager
implements AlterPartitionManager,
Logging {
    private final NodeToControllerChannelManager controllerChannelManager;
    private final Scheduler scheduler;
    private final Time time;
    private final int brokerId;
    private final Function0<Object> brokerEpochSupplier;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final Map<TopicPartition, AlterPartitionItem> unsentIsrUpdates;
    private final AtomicBoolean inflightRequest;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public NodeToControllerChannelManager controllerChannelManager() {
        return this.controllerChannelManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Time time() {
        return this.time;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Function0<Object> brokerEpochSupplier() {
        return this.brokerEpochSupplier;
    }

    public Function0<MetadataVersion> metadataVersionSupplier() {
        return this.metadataVersionSupplier;
    }

    public Map<TopicPartition, AlterPartitionItem> unsentIsrUpdates() {
        return this.unsentIsrUpdates;
    }

    private AtomicBoolean inflightRequest() {
        return this.inflightRequest;
    }

    @Override
    public void start() {
        this.controllerChannelManager().start();
    }

    @Override
    public void shutdown() {
        this.controllerChannelManager().shutdown();
    }

    @Override
    public CompletableFuture<LeaderAndIsr> submit(TopicIdPartition topicIdPartition, LeaderAndIsr leaderAndIsr, int controllerEpoch, boolean propagateImmediately) {
        CompletableFuture<LeaderAndIsr> future = new CompletableFuture<LeaderAndIsr>();
        AlterPartitionItem alterPartitionItem = new AlterPartitionItem(topicIdPartition, leaderAndIsr, future, controllerEpoch);
        if (this.unsentIsrUpdates().putIfAbsent(alterPartitionItem.topicIdPartition().topicPartition(), alterPartitionItem) == null) {
            this.maybePropagateIsrChanges();
        } else {
            future.completeExceptionally((Throwable)new OperationNotAttemptedException(new StringBuilder(50).append("Failed to enqueue ISR change state ").append(leaderAndIsr).append(" for partition ").append(topicIdPartition).toString()));
        }
        return future;
    }

    public void maybePropagateIsrChanges() {
        if (!this.unsentIsrUpdates().isEmpty() && this.inflightRequest().compareAndSet(false, true)) {
            ListBuffer inflightAlterPartitionItems = new ListBuffer();
            this.unsentIsrUpdates().values().forEach(item -> inflightAlterPartitionItems.append(item));
            this.sendRequest((Seq<AlterPartitionItem>)inflightAlterPartitionItems.toSeq());
            return;
        }
    }

    public void clearInFlightRequest() {
        if (!this.inflightRequest().compareAndSet(true, false)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Attempting to clear AlterPartition in-flight flag when no apparent request is in-flight");
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendRequest(Seq<AlterPartitionItem> inflightAlterPartitionItems) {
        void var6_5;
        void var5_4;
        long brokerEpoch = this.brokerEpochSupplier().apply$mcJ$sp();
        Tuple2<AlterPartitionRequest.Builder, scala.collection.mutable.Map<Uuid, String>> tuple2 = this.buildRequest(inflightAlterPartitionItems, brokerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        AlterPartitionRequest.Builder request = (AlterPartitionRequest.Builder)tuple2._1();
        scala.collection.mutable.Map topicNamesByIds = (scala.collection.mutable.Map)tuple2._2();
        this.debug((Function0<String>)((Function0 & Serializable)() -> DefaultAlterPartitionManager.$anonfun$sendRequest$1((AlterPartitionRequest.Builder)var5_4)));
        this.controllerChannelManager().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)var5_4, new ControllerRequestCompletionHandler(this, brokerEpoch, inflightAlterPartitionItems, (scala.collection.mutable.Map)var6_5){
            private final /* synthetic */ DefaultAlterPartitionManager $outer;
            private final long brokerEpoch$1;
            private final Seq inflightAlterPartitionItems$2;
            private final scala.collection.mutable.Map topicNamesByIds$1;

            public void onComplete(ClientResponse response) {
                Errors errors;
                this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Received AlterPartition response ").append(response).toString());
                try {
                    if (response.authenticationException() != null) {
                        errors = Errors.NETWORK_EXCEPTION;
                    } else if (response.versionMismatch() != null) {
                        errors = Errors.UNSUPPORTED_VERSION;
                    } else {
                        AlterPartitionResponse body = (AlterPartitionResponse)response.responseBody();
                        errors = this.$outer.handleAlterPartitionResponse(response.requestHeader(), body, this.brokerEpoch$1, (Seq<AlterPartitionItem>)this.inflightAlterPartitionItems$2, (scala.collection.mutable.Map<Uuid, String>)this.topicNamesByIds$1);
                    }
                }
                finally {
                    this.$outer.clearInFlightRequest();
                }
                Errors error = errors;
                if (Errors.NONE.equals(error)) {
                    this.$outer.maybePropagateIsrChanges();
                    return;
                }
                this.$outer.scheduler().scheduleOnce("send-alter-partition", () -> $this.$outer.maybePropagateIsrChanges(), 50L);
            }

            public void onTimeout() {
                throw new IllegalStateException("Encountered unexpected timeout when sending AlterPartition to the controller");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerEpoch$1 = brokerEpoch$1;
                this.inflightAlterPartitionItems$2 = inflightAlterPartitionItems$2;
                this.topicNamesByIds$1 = topicNamesByIds$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.kafka.clients.ClientResponse )}, serializedLambda);
            }
        });
    }

    private Tuple2<AlterPartitionRequest.Builder, scala.collection.mutable.Map<Uuid, String>> buildRequest(Seq<AlterPartitionItem> inflightAlterPartitionItems, long brokerEpoch) {
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionSupplier().apply();
        HashMap topicNamesByIds = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef canUseTopicIds = BooleanRef.create((boolean)metadataVersion.isTopicIdsSupported());
        AlterPartitionRequestData message = new AlterPartitionRequestData().setBrokerId(this.brokerId()).setBrokerEpoch(brokerEpoch);
        inflightAlterPartitionItems.groupBy((Function1 & Serializable)x$2 -> x$2.topicIdPartition().topic()).foreach((Function1 & Serializable)x0$1 -> {
            DefaultAlterPartitionManager.$anonfun$buildRequest$2(canUseTopicIds, topicNamesByIds, message, metadataVersion, x0$1);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)new AlterPartitionRequest.Builder(message, canUseTopicIds.elem), (Object)topicNamesByIds);
    }

    public Errors handleAlterPartitionResponse(RequestHeader requestHeader, AlterPartitionResponse alterPartitionResp, long sentBrokerEpoch, Seq<AlterPartitionItem> inflightAlterPartitionItems, scala.collection.mutable.Map<Uuid, String> topicNamesByIds) {
        AlterPartitionResponseData data = alterPartitionResp.data();
        Errors errors = Errors.forCode((short)data.errorCode());
        if (Errors.STALE_BROKER_EPOCH.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Broker had a stale broker epoch (").append(sentBrokerEpoch).append("), retrying.").toString());
        } else if (Errors.CLUSTER_AUTHORIZATION_FAILED.equals(errors)) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Broker is not authorized to send AlterPartition to controller", (Function0<Throwable>)(Function0 & Serializable)() -> Errors.CLUSTER_AUTHORIZATION_FAILED.exception("Broker is not authorized to send AlterPartition to controller"));
        } else if (Errors.NONE.equals(errors)) {
            HashMap partitionResponses = HashMap$.MODULE$.empty();
            data.topics().forEach(topic -> {
                String topicName;
                String string = topicName = requestHeader.apiVersion() > 1 ? (String)topicNamesByIds.get((Object)topic.topicId()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()) : topic.topicName();
                if (topicName == null || topicName.isEmpty()) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Received an unexpected topic ").append(topic).append(" in the alter partition response, ignoring it.").toString());
                    return;
                }
                topic.partitions().forEach(partition -> {
                    TopicPartition tp = new TopicPartition(topicName, partition.partitionIndex());
                    partitionResponses.update((Object)tp, partition);
                });
            });
            inflightAlterPartitionItems.foreach((Function1 & Serializable)inflightAlterPartition -> {
                Option option = partitionResponses.get((Object)inflightAlterPartition.topicIdPartition().topicPartition());
                if (option instanceof Some) {
                    AlterPartitionResponseData.PartitionData response = (AlterPartitionResponseData.PartitionData)((Some)option).value();
                    this.unsentIsrUpdates().remove(inflightAlterPartition.topicIdPartition().topicPartition());
                    Errors error = Errors.forCode((short)response.errorCode());
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Controller response returned for AlterIsr request for ").append(inflightAlterPartition.topicIdPartition()).append(": ").append(response).toString());
                    Errors errors = error;
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                        return BoxesRunTime.boxToBoolean((boolean)inflightAlterPartition.future().complete(LeaderAndIsr$.MODULE$.apply(response.leaderId(), response.leaderEpoch(), (List<Object>)CollectionConverters$.MODULE$.ListHasAsScala(response.isr()).asScala().toList().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3))), inflightAlterPartition.leaderAndIsr().leaderRecoveryState(), response.partitionEpoch(), inflightAlterPartition.leaderAndIsr().clusterLinkState())));
                    }
                    return BoxesRunTime.boxToBoolean((boolean)inflightAlterPartition.future().completeExceptionally(error.exception()));
                }
                if (None$.MODULE$.equals(option)) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Partition ").append(inflightAlterPartition.topicIdPartition()).append(" was sent but not included in the response").toString());
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            });
        } else {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(88).append("Controller returned an unexpected top-level error when handling AlterPartition request: ").append(errors).toString());
        }
        return Errors.forCode((short)data.errorCode());
    }

    public static final /* synthetic */ String $anonfun$sendRequest$1(AlterPartitionRequest.Builder request$1) {
        return new StringBuilder(37).append("Sending AlterPartition to controller ").append(request$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$buildRequest$3(MetadataVersion metadataVersion$1, AlterPartitionRequestData.TopicData topicData$1, AlterPartitionItem item) {
        LeaderRecoveryState leaderRecoveryState = item.leaderAndIsr().leaderRecoveryState();
        LeaderRecoveryState leaderRecoveryState2 = LeaderRecoveryState.RECOVERING;
        AlterPartitionRequestData.PartitionData partitionData = new AlterPartitionRequestData.PartitionData().setPartitionIndex(item.topicIdPartition().partition()).setLeaderEpoch(item.leaderAndIsr().leaderEpoch()).setNewIsrWithEpochs(CollectionConverters$.MODULE$.SeqHasAsJava(item.leaderAndIsr().isrWithBrokerEpoch()).asJava()).setPartitionEpoch(item.leaderAndIsr().partitionEpoch()).setIsUnclean(!(leaderRecoveryState != null ? !leaderRecoveryState.equals(leaderRecoveryState2) : leaderRecoveryState2 != null));
        if (metadataVersion$1.isLeaderRecoverySupported()) {
            partitionData.setLeaderRecoveryState(item.leaderAndIsr().leaderRecoveryState().value());
        }
        item.leaderAndIsr().clusterLinkState().foreach((Function1 & Serializable)linkState -> {
            partitionData.setClusterLinkState(new AlterPartitionRequestData.ClusterLinkState().setLinkedLeaderEpoch(linkState.linkedLeaderEpoch()).setLinkFailed(linkState.linkFailed()));
            if (linkState.linkFailed()) {
                return partitionData.setMirrorTopicError(linkState.error().code());
            }
            return BoxedUnit.UNIT;
        });
        return topicData$1.partitions().add(partitionData);
    }

    public static final /* synthetic */ void $anonfun$buildRequest$2(BooleanRef canUseTopicIds$1, HashMap topicNamesByIds$2, AlterPartitionRequestData message$1, MetadataVersion metadataVersion$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topicName = (String)x0$1._1();
            Seq items = (Seq)x0$1._2();
            Uuid topicId = ((AlterPartitionItem)items.head()).topicIdPartition().topicId();
            Uuid uuid = topicId;
            Uuid uuid2 = Uuid.ZERO_UUID;
            canUseTopicIds$1.elem = canUseTopicIds$1.elem & (uuid == null ? uuid2 != null : !uuid.equals(uuid2));
            topicNamesByIds$2.update((Object)topicId, (Object)topicName);
            AlterPartitionRequestData.TopicData topicData = new AlterPartitionRequestData.TopicData().setTopicName(topicName).setTopicId(topicId);
            message$1.topics().add(topicData);
            items.foreach((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)DefaultAlterPartitionManager.$anonfun$buildRequest$3(metadataVersion$1, topicData, item)));
            return;
        }
        throw new MatchError(null);
    }

    public DefaultAlterPartitionManager(NodeToControllerChannelManager controllerChannelManager, Scheduler scheduler, Time time, int brokerId, Function0<Object> brokerEpochSupplier, Function0<MetadataVersion> metadataVersionSupplier) {
        this.controllerChannelManager = controllerChannelManager;
        this.scheduler = scheduler;
        this.time = time;
        this.brokerId = brokerId;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.metadataVersionSupplier = metadataVersionSupplier;
        this.unsentIsrUpdates = new ConcurrentHashMap<TopicPartition, AlterPartitionItem>();
        this.inflightRequest = new AtomicBoolean(false);
    }
}

