/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import kafka.server.PartitionMetadata;
import kafka.server.PartitionMetadataFile$;
import kafka.server.PartitionMetadataFile$PartitionMetadataFileFormatter$;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InconsistentTopicIdException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Uw!\u0002\u0016,\u0011\u0003\u0001d!\u0002\u001a,\u0011\u0003\u0019\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004b\u0002\u001f\u0002\u0005\u0004%I!\u0010\u0005\u0007\r\u0006\u0001\u000b\u0011\u0002 \t\u000f\u001d\u000b!\u0019!C\u0005\u0011\"1\u0011+\u0001Q\u0001\n%CqAU\u0001C\u0002\u0013%1\u000b\u0003\u0004X\u0003\u0001\u0006I\u0001\u0016\u0005\u00061\u0006!\t!W\u0004\u0006E\u0006A\ta\u0019\u0004\u0006K\u0006A\tA\u001a\u0005\u0006u-!\ta\u001a\u0005\u0006Q.!\t!\u001b\u0004\u0005s\u0006\u0001!\u0010C\u0005\u0002\u00069\u0011\t\u0011)A\u0005U\"Q\u0011q\u0001\b\u0003\u0002\u0003\u0006I!!\u0003\t\rirA\u0011AA\b\u0011\u001d\tiC\u0004C\u0001\u0003_1QAM\u0016\u0001\u0003cA!\"a\r\u0014\u0005\u000b\u0007I\u0011AA\u001b\u0011%\t9d\u0005B\u0001B\u0003%!\f\u0003\u0006\u0002:M\u0011\t\u0011)A\u0005\u0003wAaAO\n\u0005\u0002\u0005e\u0003\"CA1'\t\u0007I\u0011BA2\u0011!\t\u0019h\u0005Q\u0001\n\u0005\u0015\u0004\"CA;'\t\u0007I\u0011BA2\u0011!\t9h\u0005Q\u0001\n\u0005\u0015\u0004\"CA='\t\u0007I\u0011BA>\u0011!\t\u0019i\u0005Q\u0001\n\u0005u\u0004\u0002CAC'\t\u0007I\u0011B\u001f\t\u000f\u0005\u001d5\u0003)A\u0005}!I\u0011\u0011R\nA\u0002\u0013%\u00111\u0012\u0005\n\u0003?\u001b\u0002\u0019!C\u0005\u0003CC\u0001\"!,\u0014A\u0003&\u0011Q\u0012\u0005\b\u0003o\u001bB\u0011AA]\u0011\u001d\tyl\u0005C\u0001\u0003\u0003Dq!!\f\u0014\t\u0003\ty\u0003C\u0004\u0002DN!\t!!2\t\u000f\u000557\u0003\"\u0001\u0002F\"9\u0011qZ\n\u0005\u0002\u0005\u0005\u0007bBAi'\u0011\u0005\u00131[\u0001\u0016!\u0006\u0014H/\u001b;j_:lU\r^1eCR\fg)\u001b7f\u0015\taS&\u0001\u0004tKJ4XM\u001d\u0006\u0002]\u0005)1.\u00194lC\u000e\u0001\u0001CA\u0019\u0002\u001b\u0005Y#!\u0006)beRLG/[8o\u001b\u0016$\u0018\rZ1uC\u001aKG.Z\n\u0003\u0003Q\u0002\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00011\u0003e\u0001\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019$jY\u0016t\u0017-\\3\u0016\u0003y\u0002\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\t1\fgn\u001a\u0006\u0002\u0007\u0006!!.\u0019<b\u0013\t)\u0005I\u0001\u0004TiJLgnZ\u0001\u001b!\u0006\u0014H/\u001b;j_:lU\r^1eCR\fg)\u001b7f]\u0006lW\rI\u0001\u0013/\"LG/Z*qC\u000e,7\u000fU1ui\u0016\u0014h.F\u0001J!\tQu*D\u0001L\u0015\taU*A\u0003sK\u001e,\u0007P\u0003\u0002O\u0005\u0006!Q\u000f^5m\u0013\t\u00016JA\u0004QCR$XM\u001d8\u0002']C\u0017\u000e^3Ta\u0006\u001cWm\u001d)biR,'O\u001c\u0011\u0002\u001d\r+(O]3oiZ+'o]5p]V\tA\u000b\u0005\u00026+&\u0011aK\u000e\u0002\u0004\u0013:$\u0018aD\"veJ,g\u000e\u001e,feNLwN\u001c\u0011\u0002\u000f9,wOR5mKR\u0011!\f\u0019\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\n\u000b!![8\n\u0005}c&\u0001\u0002$jY\u0016DQ!Y\u0005A\u0002i\u000b1\u0001Z5s\u0003y\u0001\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019$jY\u00164uN]7biR,'\u000f\u0005\u0002e\u00175\t\u0011A\u0001\u0010QCJ$\u0018\u000e^5p]6+G/\u00193bi\u00064\u0015\u000e\\3G_Jl\u0017\r\u001e;feN\u00111\u0002\u000e\u000b\u0002G\u00061Ao\u001c$jY\u0016$\"A\u001b;\u0011\u0005-\u0014hB\u00017q!\tig'D\u0001o\u0015\tyw&\u0001\u0004=e>|GOP\u0005\u0003cZ\na\u0001\u0015:fI\u00164\u0017BA#t\u0015\t\th\u0007C\u0003v\u001b\u0001\u0007a/\u0001\u0003eCR\f\u0007CA\u0019x\u0013\tA8FA\tQCJ$\u0018\u000e^5p]6+G/\u00193bi\u0006\u00141\u0004U1si&$\u0018n\u001c8NKR\fG-\u0019;b%\u0016\fGMQ;gM\u0016\u0014XcA>\u0002\u0018M\u0019a\u0002\u000e?\u0011\u0007u\f\t!D\u0001\u007f\u0015\tyX&A\u0003vi&d7/C\u0002\u0002\u0004y\u0014q\u0001T8hO&tw-\u0001\u0005m_\u000e\fG/[8o\u0003\u0019\u0011X-\u00193feB\u00191,a\u0003\n\u0007\u00055AL\u0001\bCk\u001a4WM]3e%\u0016\fG-\u001a:\u0015\r\u0005E\u0011\u0011FA\u0016!\u0011!g\"a\u0005\u0011\t\u0005U\u0011q\u0003\u0007\u0001\t\u001d\tIB\u0004b\u0001\u00037\u0011\u0011\u0001V\t\u0005\u0003;\t\u0019\u0003E\u00026\u0003?I1!!\t7\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!NA\u0013\u0013\r\t9C\u000e\u0002\u0004\u0003:L\bBBA\u0003#\u0001\u0007!\u000eC\u0004\u0002\bE\u0001\r!!\u0003\u0002\tI,\u0017\r\u001a\u000b\u0002mN\u00191\u0003\u000e?\u0002\t\u0019LG.Z\u000b\u00025\u0006)a-\u001b7fA\u0005!Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u0004B!!\u0010\u0002V5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0002m_\u001eTA!!\u0012\u0002H\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0005\u0003\u0013\nY%A\u0004ti>\u0014\u0018mZ3\u000b\u00079\niE\u0003\u0003\u0002P\u0005E\u0013AB1qC\u000eDWM\u0003\u0002\u0002T\u0005\u0019qN]4\n\t\u0005]\u0013q\b\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0015\r\u0005m\u0013QLA0!\t\t4\u0003\u0003\u0004\u00024]\u0001\rA\u0017\u0005\b\u0003s9\u0002\u0019AA\u001e\u0003\u0011\u0001\u0018\r\u001e5\u0016\u0005\u0005\u0015\u0004\u0003BA4\u0003_j!!!\u001b\u000b\t\u0005M\u00121\u000e\u0006\u0004\u0003[\u0012\u0015a\u00018j_&!\u0011\u0011OA5\u0005\u0011\u0001\u0016\r\u001e5\u0002\u000bA\fG\u000f\u001b\u0011\u0002\u0011Q,W\u000e\u001d)bi\"\f\u0011\u0002^3naB\u000bG\u000f\u001b\u0011\u0002\t1|7m[\u000b\u0003\u0003{\u00022aPA@\u0013\r\t\t\t\u0011\u0002\u0007\u001f\nTWm\u0019;\u0002\u000b1|7m\u001b\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\nq\u0002Z5sif$v\u000e]5d\u0013\u0012|\u0005\u000f^\u000b\u0003\u0003\u001b\u0003R!NAH\u0003'K1!!%7\u0005\u0019y\u0005\u000f^5p]B!\u0011QSAN\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006-\u0013AB2p[6|g.\u0003\u0003\u0002\u001e\u0006]%\u0001B+vS\u0012\f1\u0003Z5sif$v\u000e]5d\u0013\u0012|\u0005\u000f^0%KF$B!a)\u0002*B\u0019Q'!*\n\u0007\u0005\u001dfG\u0001\u0003V]&$\b\"CAVC\u0005\u0005\t\u0019AAG\u0003\rAH%M\u0001\u0011I&\u0014H/\u001f+pa&\u001c\u0017\nZ(qi\u0002B3AIAY!\r)\u00141W\u0005\u0004\u0003k3$\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\rI,7m\u001c:e)\u0011\t\u0019+a/\t\u000f\u0005u6\u00051\u0001\u0002\u0014\u00069Ao\u001c9jG&#\u0017AC7bs\n,g\t\\;tQR\u0011\u00111U\u0001\u0007KbL7\u000f^:\u0015\u0005\u0005\u001d\u0007cA\u001b\u0002J&\u0019\u00111\u001a\u001c\u0003\u000f\t{w\u000e\\3b]\u00069\u0011n]#naRL\u0018A\u00023fY\u0016$X-\u0001\u0005u_N#(/\u001b8h)\u0005Q\u0007")
public class PartitionMetadataFile
implements Logging {
    private final File file;
    private final LogDirFailureChannel logDirFailureChannel;
    private final Path path;
    private final Path tempPath;
    private final Object lock;
    private final String logDir;
    private volatile Option<Uuid> dirtyTopicIdOpt;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static File newFile(File dir) {
        return PartitionMetadataFile$.MODULE$.newFile(dir);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File file() {
        return this.file;
    }

    private Path path() {
        return this.path;
    }

    private Path tempPath() {
        return this.tempPath;
    }

    private Object lock() {
        return this.lock;
    }

    private String logDir() {
        return this.logDir;
    }

    private Option<Uuid> dirtyTopicIdOpt() {
        return this.dirtyTopicIdOpt;
    }

    private void dirtyTopicIdOpt_$eq(Option<Uuid> x$1) {
        this.dirtyTopicIdOpt = x$1;
    }

    public void record(Uuid topicId) {
        this.dirtyTopicIdOpt().foreach((Function1 & Serializable)dirtyTopicId -> {
            PartitionMetadataFile.$anonfun$record$1(topicId, dirtyTopicId);
            return BoxedUnit.UNIT;
        });
        this.dirtyTopicIdOpt_$eq((Option<Uuid>)new Some((Object)topicId));
    }

    public void maybeFlush() {
        this.dirtyTopicIdOpt().foreach((Function1 & Serializable)x$1 -> {
            PartitionMetadataFile.$anonfun$maybeFlush$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public PartitionMetadata read() {
        Object object = this.lock();
        synchronized (object) {
            PartitionMetadata partitionMetadata = this.liftedTree1$1();
            return partitionMetadata;
        }
    }

    public boolean exists() {
        return this.file().exists();
    }

    public boolean isEmpty() {
        return this.file().length() == 0L;
    }

    public void delete() {
        Files.delete(this.file().toPath());
    }

    public String toString() {
        return new StringBuilder(28).append("PartitionMetadataFile(path=").append(this.path()).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$record$1(Uuid topicId$1, Uuid dirtyTopicId) {
        Uuid uuid = dirtyTopicId;
        if (uuid == null ? topicId$1 != null : !uuid.equals(topicId$1)) {
            throw new InconsistentTopicIdException(new StringBuilder(59).append("Tried to record topic ID ").append(topicId$1).append(" to file ").append("but had already recorded ").append(dirtyTopicId).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$maybeFlush$2(PartitionMetadataFile $this, Uuid topicId) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream($this.tempPath().toFile());
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8));){
                writer.write(PartitionMetadataFile$PartitionMetadataFileFormatter$.MODULE$.toFile(new PartitionMetadata(PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion(), topicId)));
                writer.flush();
                fileOutputStream.getFD().sync();
            }
            Utils.atomicMoveWithFallback((Path)$this.tempPath(), (Path)$this.path(), (boolean)false);
        }
        catch (IOException e) {
            String msg = new StringBuilder(47).append("Error while writing to partition metadata file ").append($this.file().getAbsolutePath()).toString();
            $this.logDirFailureChannel.maybeAddOfflineLogDir($this.logDir(), msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
        $this.dirtyTopicIdOpt_$eq((Option<Uuid>)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$maybeFlush$1(PartitionMetadataFile $this, Uuid x$1) {
        Object object = $this.lock();
        synchronized (object) {
            $this.dirtyTopicIdOpt().foreach((Function1 & Serializable)topicId -> {
                PartitionMetadataFile.$anonfun$maybeFlush$2($this, topicId);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private final /* synthetic */ PartitionMetadata liftedTree1$1() {
        try {
            PartitionMetadata partitionMetadata;
            try (BufferedReader reader = Files.newBufferedReader(this.path(), StandardCharsets.UTF_8);){
                partitionMetadata = new PartitionMetadataReadBuffer(this.file().getAbsolutePath(), reader).read();
            }
            return partitionMetadata;
        }
        catch (IOException e) {
            String msg = new StringBuilder(44).append("Error while reading partition metadata file ").append(this.file().getAbsolutePath()).toString();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir(), msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    public PartitionMetadataFile(File file, LogDirFailureChannel logDirFailureChannel) {
        this.file = file;
        this.logDirFailureChannel = logDirFailureChannel;
        this.path = file.toPath().toAbsolutePath();
        this.tempPath = Paths.get(new StringBuilder(4).append(((Object)this.path()).toString()).append(".tmp").toString(), new String[0]);
        this.lock = new Object();
        this.logDir = file.getParentFile().getParent();
        this.dirtyTopicIdOpt = None$.MODULE$;
    }

    public static class PartitionMetadataReadBuffer<T>
    implements Logging {
        private final String location;
        private final BufferedReader reader;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        public PartitionMetadata read() {
            PartitionMetadata partitionMetadata;
            String line = null;
            try {
                Uuid metadataTopicId;
                block11: {
                    block7: {
                        String version;
                        block8: {
                            Object object;
                            block10: {
                                block9: {
                                    Object object2;
                                    line = this.reader.readLine();
                                    String[] stringArray = PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$WhiteSpacesPattern().split(line);
                                    if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray))) break block7;
                                    new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2));
                                    if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 2) != 0) break block7;
                                    version = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1);
                                    if (StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(version)) != PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion()) break block8;
                                    line = this.reader.readLine();
                                    String[] stringArray2 = PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$WhiteSpacesPattern().split(line);
                                    if (stringArray2 == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray2))) break block9;
                                    new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object));
                                    if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) break block10;
                                }
                                throw this.malformedLineException$1(line);
                            }
                            metadataTopicId = Uuid.fromString((String)((String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1)));
                            if (metadataTopicId.equals((Object)Uuid.ZERO_UUID)) {
                                throw new IOException(new StringBuilder(46).append("Invalid topic ID in partition metadata file (").append(this.location).append(")").toString());
                            }
                            break block11;
                        }
                        throw new IOException(new StringBuilder(52).append("Unrecognized version of partition metadata file (").append(this.location).append("): ").append(version).toString());
                    }
                    throw this.malformedLineException$1(line);
                }
                partitionMetadata = new PartitionMetadata(PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion(), metadataTopicId);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.malformedLineException$1(line);
            }
            return partitionMetadata;
        }

        private final IOException malformedLineException$1(String line) {
            return new IOException(new StringBuilder(40).append("Malformed line in checkpoint file (").append(this.location).append("): '").append(line).append("'").toString());
        }

        public PartitionMetadataReadBuffer(String location, BufferedReader reader) {
            this.location = location;
            this.reader = reader;
        }
    }
}

