/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.server.AbstractQuotaChannelManager;
import kafka.server.ActiveTenantsManager;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientSensors;
import kafka.server.ProducerIdQuotaManagerConfig;
import kafka.server.QuotaType$ProducerId$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.storage.internals.log.ProducerIdQuotaRecorder;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f\u0001B\r\u001b\u0001}A\u0001b\r\u0001\u0003\u0006\u0004%I\u0001\u000e\u0005\tq\u0001\u0011\t\u0011)A\u0005k!A\u0011\b\u0001BC\u0002\u0013%!\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003<\u0011!y\u0004A!b\u0001\n\u0013\u0001\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u0011%\u0003!Q1A\u0005R)C\u0011\"\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0013*\t\u0011M\u0003!Q1A\u0005\nQC\u0001B\u0019\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\tG\u0002\u0011)\u0019!C\u0005I\"A\u0001\u000f\u0001B\u0001B\u0003%Q\rC\u0003r\u0001\u0011\u0005!\u000fC\u0004{\u0001\t\u0007I\u0011B>\t\r}\u0004\u0001\u0015!\u0003}\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aq!a\u0003\u0001\t\u0003\ni\u0001C\u0004\u0002.\u0001!\t&a\f\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0003bBA>\u0001\u0011%\u0011Q\u0010\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011\u001d\ty\t\u0001C\u0005\u0003#Cq!a'\u0001\t\u0013\tiJ\u0001\fQe>$WoY3s\u0013\u0012\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0015\tYB$\u0001\u0004tKJ4XM\u001d\u0006\u0002;\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001!IA\u0011\u0011EI\u0007\u00025%\u00111E\u0007\u0002\u0013\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'\u000f\u0005\u0002&c5\taE\u0003\u0002(Q\u0005\u0019An\\4\u000b\u0005%R\u0013!C5oi\u0016\u0014h.\u00197t\u0015\tYC&A\u0004ti>\u0014\u0018mZ3\u000b\u0005ui#B\u0001\u00180\u0003\u0019\t\u0007/Y2iK*\t\u0001'A\u0002pe\u001eL!A\r\u0014\u0003/A\u0013x\u000eZ;dKJLE-U;pi\u0006\u0014VmY8sI\u0016\u0014\u0018AB2p]\u001aLw-F\u00016!\t\tc'\u0003\u000285\ta\u0002K]8ek\u000e,'/\u00133Rk>$\u0018-T1oC\u001e,'oQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\rG2LWM\u001c;D_:4\u0017nZ\u000b\u0002wA\u0011\u0011\u0005P\u0005\u0003{i\u0011\u0001d\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\u000e{gNZ5h\u00035\u0019G.[3oi\u000e{gNZ5hA\u00059Q.\u001a;sS\u000e\u001cX#A!\u0011\u0005\t3U\"A\"\u000b\u0005}\"%BA#-\u0003\u0019\u0019w.\\7p]&\u0011qi\u0011\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001\u0002;j[\u0016,\u0012a\u0013\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\u0012\u000bQ!\u001e;jYNL!\u0001U'\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0005\u0003\u0013\n\n\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0016\u0003U\u0003\"AV0\u000f\u0005]k\u0006C\u0001-\\\u001b\u0005I&B\u0001.\u001f\u0003\u0019a$o\\8u})\tA,A\u0003tG\u0006d\u0017-\u0003\u0002_7\u00061\u0001K]3eK\u001aL!\u0001Y1\u0003\rM#(/\u001b8h\u0015\tq6,A\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jq\u0002\n1c\u00197jK:$\u0018+^8uC\u000e\u000bG\u000e\u001c2bG.,\u0012!\u001a\t\u0004M\u001eLW\"A.\n\u0005!\\&AB(qi&|g\u000e\u0005\u0002k]6\t1N\u0003\u0002m[\u0006)\u0011/^8uC*\u00111\u0004L\u0005\u0003_.\u00141c\u00117jK:$\u0018+^8uC\u000e\u000bG\u000e\u001c2bG.\fAc\u00197jK:$\u0018+^8uC\u000e\u000bG\u000e\u001c2bG.\u0004\u0013A\u0002\u001fj]&$h\bF\u0004tiV4x\u000f_=\u0011\u0005\u0005\u0002\u0001\"B\u001a\u000e\u0001\u0004)\u0004\"B\u001d\u000e\u0001\u0004Y\u0004\"B \u000e\u0001\u0004\t\u0005\"B%\u000e\u0001\u0004Y\u0005\"B*\u000e\u0001\u0004)\u0006\"B2\u000e\u0001\u0004)\u0017!\u0005;ie>$H\u000f\\3UQJ,7\u000f[8mIV\tA\u0010\u0005\u0002g{&\u0011ap\u0017\u0002\u0007\t>,(\r\\3\u0002%QD'o\u001c;uY\u0016$\u0006N]3tQ>dG\rI\u0001\u0014E\u0006\u001c7\u000e\u001d:fgN,(/Z#oC\ndW\rZ\u000b\u0003\u0003\u000b\u00012AZA\u0004\u0013\r\tIa\u0017\u0002\b\u0005>|G.Z1o\u0003i\u0011XmY8sI\u0006sGmR3u)\"\u0014x\u000e\u001e;mKRKW.Z't)!\ty!!\u0006\u0002 \u0005\r\u0002c\u00014\u0002\u0012%\u0019\u00111C.\u0003\u0007%sG\u000fC\u0004\u0002\u0018E\u0001\r!!\u0007\u0002\u001b\rd\u0017.\u001a8u'\u0016t7o\u001c:t!\r\t\u00131D\u0005\u0004\u0003;Q\"!D\"mS\u0016tGoU3og>\u00148\u000f\u0003\u0004\u0002\"E\u0001\r\u0001`\u0001\u0006m\u0006dW/\u001a\u0005\b\u0003K\t\u0002\u0019AA\u0014\u0003\u0019!\u0018.\\3NgB\u0019a-!\u000b\n\u0007\u0005-2L\u0001\u0003M_:<\u0017\u0001F2mS\u0016tGOU1uK6+GO]5d\u001d\u0006lW\r\u0006\u0003\u00022\u0005e\u0002\u0003BA\u001a\u0003ki\u0011\u0001R\u0005\u0004\u0003o!%AC'fiJL7MT1nK\"9\u00111\b\nA\u0002\u0005u\u0012aD9v_R\fW*\u001a;sS\u000e$\u0016mZ:\u0011\u000bY\u000by$V+\n\u0007\u0005\u0005\u0013MA\u0002NCB\fAC]3hSN$XM])v_R\fW*\u001a;sS\u000e\u001cH\u0003BA$\u00033\"B!!\u0013\u0002PA\u0019a-a\u0013\n\u0007\u000553L\u0001\u0003V]&$\bbBA)'\u0001\u0007\u00111K\u0001\u0007g\u0016t7o\u001c:\u0011\u0007\t\u000b)&C\u0002\u0002X\r\u0013aaU3og>\u0014\bbBA.'\u0001\u0007\u0011QH\u0001\u000b[\u0016$(/[2UC\u001e\u001c\u0018AF7bs\n,w)\u001a;UQJ|G\u000f\u001e7f)&lW-T:\u0015\r\u0005=\u0011\u0011MA=\u0011\u001d\t\u0019\u0007\u0006a\u0001\u0003K\nqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002h\u0005Md\u0002BA5\u0003_j!!a\u001b\u000b\u0007\u00055D$A\u0004oKR<xN]6\n\t\u0005E\u00141N\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\u0011\t)(a\u001e\u0003\u000fI+\u0017/^3ti*!\u0011\u0011OA6\u0011\u001d\t)\u0003\u0006a\u0001\u0003O\t\u0011cZ3u)\"\u0014x\u000e\u001e;mKRKW.Z't)\u0019\ty!a \u0002\u0002\"9\u0011qC\u000bA\u0002\u0005e\u0001bBA\u0013+\u0001\u0007\u0011qE\u0001\f[\u0006L(-\u001a*fG>\u0014H\r\u0006\u0005\u0002J\u0005\u001d\u00151RAG\u0011\u0019\tII\u0006a\u0001+\u0006IAo\u001c9jG:\u000bW.\u001a\u0005\u0007\u0003C1\u0002\u0019\u0001?\t\u000f\u0005\u0015b\u00031\u0001\u0002(\u00051!/Z2pe\u0012$\u0002\"!\u0013\u0002\u0014\u0006]\u0015\u0011\u0014\u0005\b\u0003+;\u0002\u0019AA*\u0003-\tXo\u001c;b'\u0016t7o\u001c:\t\r\u0005\u0005r\u00031\u0001}\u0011\u001d\t)c\u0006a\u0001\u0003O\tQc\u00197jK:$8i\\;oi6+GO]5d\u001d\u0006lW\r\u0006\u0003\u00022\u0005}\u0005bBA\u001e1\u0001\u0007\u0011Q\b")
public class ProducerIdQuotaManager
extends ClientQuotaManager
implements ProducerIdQuotaRecorder {
    private final ProducerIdQuotaManagerConfig config;
    private final ClientQuotaManagerConfig clientConfig;
    private final Metrics metrics;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> clientQuotaCallback;
    private final double throttleThreshold;

    private ProducerIdQuotaManagerConfig config() {
        return this.config;
    }

    private ClientQuotaManagerConfig clientConfig() {
        return this.clientConfig;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    @Override
    public Time time() {
        return super.time();
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> clientQuotaCallback() {
        return this.clientQuotaCallback;
    }

    private double throttleThreshold() {
        return this.throttleThreshold;
    }

    @Override
    public boolean backpressureEnabled() {
        return false;
    }

    @Override
    public int recordAndGetThrottleTimeMs(ClientSensors clientSensors, double value, long timeMs) {
        int throttleTimeMs = this.getThrottleTimeMs(clientSensors, timeMs);
        if (throttleTimeMs <= 0) {
            clientSensors.quotaSensor().record(value, timeMs, false);
        }
        return throttleTimeMs;
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("usage-rate", this.quotaType().toString(), "Tracking usage-rate per tenant", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    @Override
    public void registerQuotaMetrics(Map<String, String> metricTags, Sensor sensor) {
        super.registerQuotaMetrics(metricTags, sensor);
        sensor.add(this.clientCountMetricName(metricTags), (MeasurableStat)new CumulativeSum(), new MetricConfig());
    }

    public int maybeGetThrottleTimeMs(RequestChannel.Request request, long timeMs) {
        if (this.quotasEnabled()) {
            RequestChannel.Session session = request.session();
            String clientId = request.header().clientId();
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return this.getThrottleTimeMs(clientSensors, timeMs);
        }
        return 0;
    }

    private int getThrottleTimeMs(ClientSensors clientSensors, long timeMs) {
        Sensor quotaSensor = clientSensors.quotaSensor();
        try {
            KafkaMetric countMetric = (KafkaMetric)this.metrics().metrics().get(this.clientCountMetricName(clientSensors.metricTags()));
            if (countMetric != null && countMetric.measurableValue(timeMs) > this.throttleThreshold()) {
                quotaSensor.checkQuotas(timeMs);
            }
            return 0;
        }
        catch (QuotaViolationException e) {
            int throttleTimeMs = (int)this.throttleTime(e);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Quota violated for sensor (").append(quotaSensor.name()).append("). Delay time: (").append(throttleTimeMs).append(")").toString());
            return throttleTimeMs;
        }
    }

    public void maybeRecord(String topicName, double value, long timeMs) {
        if (this.quotasEnabled()) {
            Map metricTags = CollectionConverters$.MODULE$.MapHasAsScala(this.quotaCallback().quotaMetricTagsFromTopic(this.clientQuotaType(), topicName)).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            this.getOrCreateQuotaSensors((Map<String, String>)metricTags, this.getOrCreateQuotaSensors$default$2(), this.getOrCreateQuotaSensors$default$3()).quotaSensor().record(value, timeMs, false);
            return;
        }
    }

    private void record(Sensor quotaSensor, double value, long timeMs) {
        quotaSensor.record(value, timeMs, false);
    }

    private MetricName clientCountMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("count", this.quotaType().toString(), "Tracking total count per tenant/user", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    public ProducerIdQuotaManager(ProducerIdQuotaManagerConfig config, ClientQuotaManagerConfig clientConfig, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> clientQuotaCallback) {
        this.config = config;
        this.clientConfig = clientConfig;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.clientQuotaCallback = clientQuotaCallback;
        super(clientConfig, metrics, QuotaType$ProducerId$.MODULE$, time, threadNamePrefix, clientQuotaCallback, (Option<ActiveTenantsManager>)None$.MODULE$, (Option<AbstractQuotaChannelManager>)None$.MODULE$);
        this.throttleThreshold = (double)config.cacheLimit() * ((double)config.cachePerTenantPercent() / 100.0);
    }
}

