/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.FetcherPool;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkClientType$Fetcher$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkFetcherWithSharedThread;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkSharedFetcherThread;
import kafka.server.link.SharedFetcherTag;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001\u0002\r\u001a\u0001\u0001B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011=\u0003!\u0011!Q\u0001\nACQ\u0001\u0018\u0001\u0005\u0002uCqA\u001a\u0001C\u0002\u0013\u0005q\r\u0003\u0004w\u0001\u0001\u0006I\u0001\u001b\u0005\bo\u0002\u0001\r\u0011\"\u0003y\u0011\u001da\b\u00011A\u0005\nuDq!a\u0002\u0001A\u0003&\u0011\u0010C\u0005\u0002\u0012\u0001\u0001\r\u0011\"\u0003\u0002\u0014!I\u0011Q\u0003\u0001A\u0002\u0013%\u0011q\u0003\u0005\b\u00037\u0001\u0001\u0015)\u0003@\u0011!\ty\u0002\u0001C\u00013\u0005\u0005\u0002bBA\u001a\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003KBq!a\u001a\u0001\t\u0003\tI\u0007C\u0004\u0002l\u0001!\t\"!\u001c\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v\ta2\t\\;ti\u0016\u0014H*\u001b8l\r\u0016$8\r[3s)\"\u0014X-\u00193Q_>d'B\u0001\u000e\u001c\u0003\u0011a\u0017N\\6\u000b\u0005qi\u0012AB:feZ,'OC\u0001\u001f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB\u0011\u0001fK\u0007\u0002S)\u0011!&H\u0001\u0006kRLGn]\u0005\u0003Y%\u0012q\u0001T8hO&tw-\u0001\u0007ce>\\WM]\"p]\u001aLw\r\u0005\u00020a5\t1$\u0003\u000227\tY1*\u00194lC\u000e{gNZ5h\u0003!a\u0017N\\6OC6,\u0007C\u0001\u001b<\u001d\t)\u0014\b\u0005\u00027G5\tqG\u0003\u00029?\u00051AH]8pizJ!AO\u0012\u0002\rA\u0013X\rZ3g\u0013\taTH\u0001\u0004TiJLgn\u001a\u0006\u0003u\r\nQ\"\u001b8ji&\fGnQ8oM&<\u0007C\u0001!B\u001b\u0005I\u0012B\u0001\"\u001a\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017nZ\u0001\u0012G>tg.Z2uS>tW*\u00198bO\u0016\u0014\bC\u0001!F\u0013\t1\u0015D\u0001\u000fDYV\u001cH/\u001a:MS:\\7i\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u0002%\rdWo\u001d;fe2Kgn['fiJL7m\u001d\t\u0003\u0001&K!AS\r\u0003%\rcWo\u001d;fe2Kgn['fiJL7m]\u0001\u0006cV|G/\u0019\t\u0003_5K!AT\u000e\u0003/\rcWo\u001d;fe2Kgn\u001b*fcV,7\u000f^)v_R\f\u0017\u0001\u0002;j[\u0016\u0004\"!\u0015.\u000e\u0003IS!AK*\u000b\u0005Q+\u0016AB2p[6|gN\u0003\u0002\u001f-*\u0011q\u000bW\u0001\u0007CB\f7\r[3\u000b\u0003e\u000b1a\u001c:h\u0013\tY&K\u0001\u0003US6,\u0017A\u0002\u001fj]&$h\b\u0006\u0005_?\u0002\f'm\u00193f!\t\u0001\u0005\u0001C\u0003.\u0011\u0001\u0007a\u0006C\u00033\u0011\u0001\u00071\u0007C\u0003?\u0011\u0001\u0007q\bC\u0003D\u0011\u0001\u0007A\tC\u0003H\u0011\u0001\u0007\u0001\nC\u0003L\u0011\u0001\u0007A\nC\u0003P\u0011\u0001\u0007\u0001+\u0001\u0006uQJ,\u0017\r\u001a)p_2,\u0012\u0001\u001b\t\u0005S:\u00048/D\u0001k\u0015\tYG.A\u0004nkR\f'\r\\3\u000b\u00055\u001c\u0013AC2pY2,7\r^5p]&\u0011qN\u001b\u0002\u0004\u001b\u0006\u0004\bC\u0001!r\u0013\t\u0011\u0018D\u0001\tTQ\u0006\u0014X\r\u001a$fi\u000eDWM\u001d+bOB\u0011\u0001\t^\u0005\u0003kf\u0011ad\u00117vgR,'\u000fT5oWNC\u0017M]3e\r\u0016$8\r[3s)\"\u0014X-\u00193\u0002\u0017QD'/Z1e!>|G\u000eI\u0001\tSN\f5\r^5wKV\t\u0011\u0010\u0005\u0002#u&\u00111p\t\u0002\b\u0005>|G.Z1o\u00031I7/Q2uSZ,w\fJ3r)\rq\u00181\u0001\t\u0003E}L1!!\u0001$\u0005\u0011)f.\u001b;\t\u0011\u0005\u0015A\"!AA\u0002e\f1\u0001\u001f\u00132\u0003%I7/Q2uSZ,\u0007\u0005K\u0002\u000e\u0003\u0017\u00012AIA\u0007\u0013\r\tya\t\u0002\tm>d\u0017\r^5mK\u0006\t2\r\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0016\u0003}\nQc\u00197vgR,'\u000fT5oW\u000e{gNZ5h?\u0012*\u0017\u000fF\u0002\u007f\u00033A\u0001\"!\u0002\u0010\u0003\u0003\u0005\raP\u0001\u0013G2,8\u000f^3s\u0019&t7nQ8oM&<\u0007\u0005K\u0002\u0011\u0003\u0017\t1B]3d_:4\u0017nZ;sKR)a0a\t\u0002(!1\u0011QE\tA\u0002}\n\u0011B\\3x\u0007>tg-[4\t\u000f\u0005%\u0012\u00031\u0001\u0002,\u0005YQ\u000f\u001d3bi\u0016$7*Z=t!\u0015\ti#a\f4\u001b\u0005a\u0017bAA\u0019Y\n\u00191+\u001a;\u0002\u0019\u0005\u001c8/[4o)\"\u0014X-\u00193\u0015\u000fM\f9$!\u0011\u0002L!9\u0011\u0011\b\nA\u0002\u0005m\u0012!\u00034fi\u000eDWM]%e!\r\u0011\u0013QH\u0005\u0004\u0003\u007f\u0019#aA%oi\"9\u00111\t\nA\u0002\u0005\u0015\u0013a\u00034fi\u000eDWM\u001d)p_2\u00042aLA$\u0013\r\tIe\u0007\u0002\f\r\u0016$8\r[3s!>|G\u000eC\u0004\u0002NI\u0001\r!a\u000f\u0002\u001dM|WO]2f\u0005J|7.\u001a:JI\u0006i!/Z7pm\u00164U\r^2iKJ$rA`A*\u0003+\ny\u0006C\u0004\u0002NM\u0001\r!a\u000f\t\u000f\u0005]3\u00031\u0001\u0002Z\u00059a-\u001a;dQ\u0016\u0014\bc\u0001!\u0002\\%\u0019\u0011QL\r\u0003E\rcWo\u001d;fe2Kgn\u001b$fi\u000eDWM],ji\"\u001c\u0006.\u0019:fIRC'/Z1e\u0011\u0019\t\tg\u0005a\u0001g\u00061A\u000f\u001b:fC\u0012\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0002}\u0006yA-Z1e)\"\u0014X-\u00193D_VtG/\u0006\u0002\u0002<\u0005I2M]3bi\u0016\u001c\u0006.\u0019:fI\u001a+Go\u00195feRC'/Z1e)\r\u0019\u0018q\u000e\u0005\u0007\u0003c2\u0002\u0019\u00019\u0002!MD\u0017M]3e\r\u0016$8\r[3s)\u0006<\u0017aE2sK\u0006$XMT3uo>\u00148n\u00117jK:$H\u0003BA<\u0003{\u00022\u0001QA=\u0013\r\tY(\u0007\u0002\u0019\u00072,8\u000f^3s\u0019&t7NT3uo>\u00148n\u00117jK:$\bBBA9/\u0001\u0007\u0001\u000f")
public class ClusterLinkFetcherThreadPool
implements Logging {
    private final KafkaConfig brokerConfig;
    private final String linkName;
    private final ClusterLinkConnectionManager connectionManager;
    private final ClusterLinkMetrics clusterLinkMetrics;
    private final ClusterLinkRequestQuota quota;
    private final Time time;
    private final scala.collection.mutable.Map<SharedFetcherTag, ClusterLinkSharedFetcherThread> threadPool;
    private volatile boolean isActive;
    private volatile ClusterLinkConfig clusterLinkConfig;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public scala.collection.mutable.Map<SharedFetcherTag, ClusterLinkSharedFetcherThread> threadPool() {
        return this.threadPool;
    }

    private boolean isActive() {
        return this.isActive;
    }

    private void isActive_$eq(boolean x$1) {
        this.isActive = x$1;
    }

    private ClusterLinkConfig clusterLinkConfig() {
        return this.clusterLinkConfig;
    }

    private void clusterLinkConfig_$eq(ClusterLinkConfig x$1) {
        this.clusterLinkConfig = x$1;
    }

    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(85).append("Reconfiguring cluster link fetcher thread pool for link ").append($this.linkName).append(" with newConfig ").append((Object)newConfig).append(" updatedKeys ").append(updatedKeys).toString());
        this.clusterLinkConfig_$eq(newConfig);
    }

    public ClusterLinkSharedFetcherThread assignThread(int fetcherId, FetcherPool fetcherPool, int sourceBrokerId) {
        ClusterLinkSharedFetcherThread clusterLinkSharedFetcherThread;
        BooleanRef isNewThread = BooleanRef.create((boolean)false);
        SharedFetcherTag sharedFetcherTag = new SharedFetcherTag(fetcherId, fetcherPool);
        synchronized (this) {
            if (!this.isActive()) {
                throw new IllegalStateException("Cluster link thread pool is no longer active");
            }
            clusterLinkSharedFetcherThread = (ClusterLinkSharedFetcherThread)this.threadPool().getOrElseUpdate((Object)sharedFetcherTag, (Function0 & Serializable)() -> {
                isNewThread$1.elem = true;
                return this.createSharedFetcherThread(sharedFetcherTag);
            });
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Assigned ").append((Object)(isNewThread$1.elem ? "new" : "existing")).append(" shared fetcher thread with tag ").append(sharedFetcherTag).append(" to source broker ").append(sourceBrokerId).toString());
        if (isNewThread.elem) {
            clusterLinkSharedFetcherThread.start();
        }
        return clusterLinkSharedFetcherThread;
    }

    public void removeFetcher(int sourceBrokerId, ClusterLinkFetcherWithSharedThread fetcher, ClusterLinkSharedFetcherThread thread) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append("Removing fetcher ").append(fetcher).toString());
        thread.removeFetcher(sourceBrokerId, fetcher);
        synchronized (this) {
            boolean bl2;
            if (thread.numFetchers() == 0) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Removing shared fetcher thread with tag ").append(thread.sharedFetcherTag()).append(" for link ").append($this.linkName).toString());
                bl2 = this.threadPool().remove((Object)thread.sharedFetcherTag()).nonEmpty();
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        if (bl) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Shutting down shared fetcher thread with tag ").append(thread.sharedFetcherTag()).toString());
            thread.shutdown();
            return;
        }
    }

    public void shutdown() {
        Seq seq;
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Shutting down cluster link fetcher thread pool for link ").append($this.linkName).toString());
        synchronized (this) {
            this.isActive_$eq(false);
            seq = this.threadPool().values().toSeq();
        }
        seq.foreach((Function1 & Serializable)thread -> {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> thread.shutdown(), this, Level.WARN);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized int deadThreadCount() {
        return this.threadPool().values().count((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isThreadFailed()));
    }

    public ClusterLinkSharedFetcherThread createSharedFetcherThread(SharedFetcherTag sharedFetcherTag) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("Creating new shared cluster link fetcher thread for link ").append($this.linkName).append(" with id ").append(sharedFetcherTag).toString());
        ClusterLinkNetworkClient clusterLinkClient = this.createNetworkClient(sharedFetcherTag);
        String threadName = new StringBuilder(34).append("ClusterLinkSharedFetcherThread-").append(this.brokerConfig.brokerId()).append("-").append(this.linkName).append("-").append(sharedFetcherTag.fetcherId()).append("-").append(sharedFetcherTag.fetcherPool().name()).toString();
        ClusterLinkSharedFetcherThread thread = new ClusterLinkSharedFetcherThread(threadName, sharedFetcherTag, this.linkName, this, clusterLinkClient, this.quota, this.clusterLinkConfig().replicaFetchBackoff(), this.time);
        this.threadPool().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)sharedFetcherTag), (Object)thread));
        return thread;
    }

    private ClusterLinkNetworkClient createNetworkClient(SharedFetcherTag sharedFetcherTag) {
        int fetcherId = sharedFetcherTag.fetcherId();
        FetcherPool fetcherPool = sharedFetcherTag.fetcherPool();
        LogContext logContext = new LogContext(new StringBuilder(68).append("[ClusterLinkFetcherThread brokerId=").append(this.brokerConfig.brokerId()).append(" ").append("fetcherId=").append(fetcherId).append(" fetcherPool=").append(fetcherPool.name()).append("] link=").append(this.linkName).append("] ").toString(), this.connectionManager.maxLogLevel());
        ClusterLinkNetworkClient clusterLinkClient = new ClusterLinkNetworkClient(this.brokerConfig, this.clusterLinkConfig(), ClusterLinkMetrics$.MODULE$.throttleTimeSensorName(this.linkName), (Option<ClusterLinkMetadata>)None$.MODULE$, (Option<MetadataUpdater>)new Some((Object)new ManualMetadataUpdater()), this.clusterLinkMetrics.metrics(), (Map<String, String>)((Map)ClusterLinkFactory$.MODULE$.linkMetricTags(this.linkName).$plus$plus((IterableOnce)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-id"), (Object)Integer.toString(fetcherId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-pool"), (Object)fetcherPool.name())})))), this.time, new StringBuilder(20).append("link-").append(this.linkName).append("-fetcher-").append(fetcherId).append("-pool-").append(fetcherPool.name()).toString(), ClusterLinkClientType$Fetcher$.MODULE$, logContext);
        this.connectionManager.enableClusterLink(clusterLinkClient, (Option<AdminMetadataManager>)None$.MODULE$);
        return clusterLinkClient;
    }

    public ClusterLinkFetcherThreadPool(KafkaConfig brokerConfig, String linkName, ClusterLinkConfig initialConfig, ClusterLinkConnectionManager connectionManager, ClusterLinkMetrics clusterLinkMetrics, ClusterLinkRequestQuota quota, Time time) {
        this.brokerConfig = brokerConfig;
        this.linkName = linkName;
        this.connectionManager = connectionManager;
        this.clusterLinkMetrics = clusterLinkMetrics;
        this.quota = quota;
        this.time = time;
        this.threadPool = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.isActive = true;
        this.clusterLinkConfig = initialConfig;
    }
}

