/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.KafkaConfig;
import kafka.server.LinkRequestQuotaUsageType$Metadata$;
import kafka.server.link.ClusterLinkClientType;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkDynamicLogger;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.CoordinatorListener;
import kafka.server.link.MetadataListener;
import kafka.server.link.MetadataRefreshListener;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.message.DescribeClusterLinksResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeClusterLinksRequest;
import org.apache.kafka.common.requests.DescribeClusterLinksResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.ShutdownableThread;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005-g\u0001\u0002\u0014(\u00019B\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005Y\u0001\t\u0015\r\u0011\"\u0001Z\u0011!i\u0006A!A!\u0002\u0013Q\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u0011\u0019\u0004!\u0011!Q\u0001\n\u001dD\u0001B\u001b\u0001\u0003\u0002\u0003\u0006Ia\u001b\u0005\t]\u0002\u0011\t\u0011)A\u0005_\")A\u000f\u0001C\u0001k\"Aq\u0010\u0001b\u0001\n\u0013\t\t\u0001\u0003\u0005\u0002\n\u0001\u0001\u000b\u0011BA\u0002\u0011)\tY\u0001\u0001b\u0001\n\u00039\u0013Q\u0002\u0005\t\u0003+\u0001\u0001\u0015!\u0003\u0002\u0010!I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011\u0004\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u001c!I\u00111\u0005\u0001C\u0002\u0013%\u0011Q\u0005\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u0002(!I\u0011q\b\u0001C\u0002\u0013%\u0011\u0011\t\u0005\t\u0003\u0017\u0002\u0001\u0015!\u0003\u0002D!Y\u0011Q\n\u0001A\u0002\u0003\u0007I\u0011BA(\u0011-\tI\u0006\u0001a\u0001\u0002\u0004%I!a\u0017\t\u0017\u0005\u001d\u0004\u00011A\u0001B\u0003&\u0011\u0011\u000b\u0005\f\u0003c\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\bC\u0006\u0002|\u0001\u0001\r\u00111A\u0005\n\u0005u\u0004bCAA\u0001\u0001\u0007\t\u0011)Q\u0005\u0003kBq!!\"\u0001\t\u0003\n9\tC\u0004\u0002\n\u0002!\t%a#\t\u000f\u0005M\u0005\u0001\"\u0011\u0002\b\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005bBAO\u0001\u0011\u0005\u0011q\u0014\u0005\b\u0003G\u0003A\u0011AAS\u0011\u001d\tI\u000b\u0001C\t\u0003WCq!!-\u0001\t\u0003\n9\tC\u0004\u00024\u0002!I!a\"\t\u000f\u0005U\u0006\u0001\"\u0003\u00028\"9\u0011\u0011\u001a\u0001\u0005\n\u0005\u001d%!G\"mkN$XM\u001d'j].lU\r^1eCR\fG\u000b\u001b:fC\u0012T!\u0001K\u0015\u0002\t1Lgn\u001b\u0006\u0003U-\naa]3sm\u0016\u0014(\"\u0001\u0017\u0002\u000b-\fgm[1\u0004\u0001M!\u0001aL\u001e@!\t\u0001\u0014(D\u00012\u0015\t\u00114'\u0001\u0003vi&d'B\u0001\u00165\u0015\taSG\u0003\u00027o\u00051\u0011\r]1dQ\u0016T\u0011\u0001O\u0001\u0004_J<\u0017B\u0001\u001e2\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0011\u0005qjT\"A\u0014\n\u0005y:#aF'fi\u0006$\u0017\r^1SK\u001a\u0014Xm\u001d5MSN$XM\\3s!\t\u00015)D\u0001B\u0015\t\u00115&A\u0003vi&d7/\u0003\u0002E\u0003\n9Aj\\4hS:<\u0017\u0001\u00042s_.,'oQ8oM&<\u0007CA$I\u001b\u0005I\u0013BA%*\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002#\rdWo\u001d;fe2Kgn[\"p]\u001aLw\r\u0005\u0002=\u0019&\u0011Qj\n\u0002\u0012\u00072,8\u000f^3s\u0019&t7nQ8oM&<\u0017!E2p]:,7\r^5p]6\u000bg.Y4feB\u0019\u0001kU+\u000e\u0003ES\u0011AU\u0001\u0006g\u000e\fG.Y\u0005\u0003)F\u0013aa\u00149uS>t\u0007C\u0001\u001fW\u0013\t9vE\u0001\u000fDYV\u001cH/\u001a:MS:\\7i\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u0002'\rdWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1\u0016\u0003i\u0003\"\u0001P.\n\u0005q;#aE\"mkN$XM\u001d'j].lU\r^1eCR\f\u0017\u0001F2mkN$XM\u001d'j].lU\r^1eCR\f\u0007%A\u0004nKR\u0014\u0018nY:\u0011\u0005\u0001$W\"A1\u000b\u0005y\u0013'BA25\u0003\u0019\u0019w.\\7p]&\u0011Q-\u0019\u0002\b\u001b\u0016$(/[2t\u0003)\u0019G.[3oiRK\b/\u001a\t\u0003y!L!![\u0014\u0003+\rcWo\u001d;fe2Kgn[\"mS\u0016tG\u000fV=qK\u0006)\u0011/^8uCB\u0011q\t\\\u0005\u0003[&\u0012qc\u00117vgR,'\u000fT5oWJ+\u0017/^3tiF+x\u000e^1\u0002\tQLW.\u001a\t\u0003aJl\u0011!\u001d\u0006\u0003\u0005\nL!a]9\u0003\tQKW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013Y<\b0\u001f>|yvt\bC\u0001\u001f\u0001\u0011\u0015)%\u00021\u0001G\u0011\u0015Q%\u00021\u0001L\u0011\u0015q%\u00021\u0001P\u0011\u0015A&\u00021\u0001[\u0011\u0015q&\u00021\u0001`\u0011\u00151'\u00021\u0001h\u0011\u0015Q'\u00021\u0001l\u0011\u0015q'\u00021\u0001p\u0003)awnZ\"p]R,\u0007\u0010^\u000b\u0003\u0003\u0007\u00012\u0001]A\u0003\u0013\r\t9!\u001d\u0002\u000b\u0019><7i\u001c8uKb$\u0018a\u00037pO\u000e{g\u000e^3yi\u0002\n\u0011c\u00197vgR,'\u000fT5oW\u000ec\u0017.\u001a8u+\t\ty\u0001E\u0002=\u0003#I1!a\u0005(\u0005a\u0019E.^:uKJd\u0015N\\6OKR<xN]6DY&,g\u000e^\u0001\u0013G2,8\u000f^3s\u0019&t7n\u00117jK:$\b%A\u0007es:\fW.[2M_\u001e<WM]\u000b\u0003\u00037\u00012\u0001PA\u000f\u0013\r\tyb\n\u0002\u0019\u00072,8\u000f^3s\u0019&t7\u000eR=oC6L7\rT8hO\u0016\u0014\u0018A\u00043z]\u0006l\u0017n\u0019'pO\u001e,'\u000fI\u0001\u0012[\u0016$\u0018\rZ1uC2K7\u000f^3oKJ\u001cXCAA\u0014!\u0019\tI#a\r\u000285\u0011\u00111\u0006\u0006\u0005\u0003[\ty#A\u0004nkR\f'\r\\3\u000b\u0007\u0005E\u0012+\u0001\u0006d_2dWm\u0019;j_:LA!!\u000e\u0002,\t1!)\u001e4gKJ\u00042\u0001PA\u001d\u0013\r\tYd\n\u0002\u0011\u001b\u0016$\u0018\rZ1uC2K7\u000f^3oKJ\f!#\\3uC\u0012\fG/\u0019'jgR,g.\u001a:tA\u0005!2m\\8sI&t\u0017\r^8s\u0019&\u001cH/\u001a8feN,\"!a\u0011\u0011\r\u0005%\u00121GA#!\ra\u0014qI\u0005\u0004\u0003\u0013:#aE\"p_J$\u0017N\\1u_Jd\u0015n\u001d;f]\u0016\u0014\u0018!F2p_J$\u0017N\\1u_Jd\u0015n\u001d;f]\u0016\u00148\u000fI\u0001\u0017GV\u0014(/\u001a8u\u001b\u0016$\u0018\rZ1uC\u000ecWo\u001d;feV\u0011\u0011\u0011\u000b\t\u0005\u0003'\n)&D\u0001c\u0013\r\t9F\u0019\u0002\b\u00072,8\u000f^3s\u0003i\u0019WO\u001d:f]RlU\r^1eCR\f7\t\\;ti\u0016\u0014x\fJ3r)\u0011\ti&a\u0019\u0011\u0007A\u000by&C\u0002\u0002bE\u0013A!\u00168ji\"I\u0011Q\r\f\u0002\u0002\u0003\u0007\u0011\u0011K\u0001\u0004q\u0012\n\u0014aF2veJ,g\u000e^'fi\u0006$\u0017\r^1DYV\u001cH/\u001a:!Q\r9\u00121\u000e\t\u0004!\u00065\u0014bAA8#\nAao\u001c7bi&dW-\u0001\ndkJ\u0014XM\u001c;D_>\u0014H-\u001b8bi>\u0014XCAA;!\u0011\t\u0019&a\u001e\n\u0007\u0005e$M\u0001\u0003O_\u0012,\u0017AF2veJ,g\u000e^\"p_J$\u0017N\\1u_J|F%Z9\u0015\t\u0005u\u0013q\u0010\u0005\n\u0003KJ\u0012\u0011!a\u0001\u0003k\n1cY;se\u0016tGoQ8pe\u0012Lg.\u0019;pe\u0002B3AGA6\u0003\u0019!wnV8sWR\u0011\u0011QL\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:$\"!!$\u0011\u0007A\u000by)C\u0002\u0002\u0012F\u0013qAQ8pY\u0016\fg.A\u0007bo\u0006LGo\u00155vi\u0012|wO\\\u0001\fC\u0012$G*[:uK:,'\u000f\u0006\u0003\u0002^\u0005e\u0005bBAN=\u0001\u0007\u0011qG\u0001\tY&\u001cH/\u001a8fe\u00061\u0012\r\u001a3D_>\u0014H-\u001b8bi>\u0014H*[:uK:,'\u000f\u0006\u0003\u0002^\u0005\u0005\u0006bBAN?\u0001\u0007\u0011QI\u0001\u0016e\u0016lw\u000e^3MS:\\7i\\8sI&t\u0017\r^8s+\t\t9\u000b\u0005\u0003Q'\u0006U\u0014aE2sK\u0006$XMT3uo>\u00148n\u00117jK:$HCBA\b\u0003[\u000by\u000bC\u0003KC\u0001\u00071\nC\u0003YC\u0001\u0007!,A\fp]6+G/\u00193bi\u0006\u0014V-];fgR,\u0006\u000fZ1uK\u0006!R.Y=cK\u001aKg\u000eZ\"p_J$\u0017N\\1u_J\f!\u0005\u001d:pG\u0016\u001c8\u000fR3tGJL'-Z\"mkN$XM\u001d'j].\u0014Vm\u001d9p]N,G\u0003BA/\u0003sCq!a/%\u0001\u0004\ti,\u0001\u0005sKN\u0004xN\\:f!\u0011\ty,!2\u000e\u0005\u0005\u0005'bAAbi\u000591\r\\5f]R\u001c\u0018\u0002BAd\u0003\u0003\u0014ab\u00117jK:$(+Z:q_:\u001cX-\u0001\u0010vg\u0016\u001cuN\u001c;s_2dWM]!t\u0019&t7nQ8pe\u0012Lg.\u0019;pe\u0002")
public class ClusterLinkMetadataThread
extends ShutdownableThread
implements MetadataRefreshListener,
Logging {
    private final KafkaConfig brokerConfig;
    private final ClusterLinkConfig clusterLinkConfig;
    private final Option<ClusterLinkConnectionManager> connectionManager;
    private final ClusterLinkMetadata clusterLinkMetadata;
    private final Metrics metrics;
    private final ClusterLinkClientType clientType;
    private final ClusterLinkRequestQuota quota;
    private final Time time;
    private final LogContext logContext;
    private final ClusterLinkNetworkClient clusterLinkClient;
    private final ClusterLinkDynamicLogger dynamicLogger;
    private final Buffer<MetadataListener> metadataListeners;
    private final Buffer<CoordinatorListener> coordinatorListeners;
    private volatile Cluster currentMetadataCluster;
    private volatile Node currentCoordinator;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkMetadata clusterLinkMetadata() {
        return this.clusterLinkMetadata;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    public ClusterLinkNetworkClient clusterLinkClient() {
        return this.clusterLinkClient;
    }

    private ClusterLinkDynamicLogger dynamicLogger() {
        return this.dynamicLogger;
    }

    private Buffer<MetadataListener> metadataListeners() {
        return this.metadataListeners;
    }

    private Buffer<CoordinatorListener> coordinatorListeners() {
        return this.coordinatorListeners;
    }

    private Cluster currentMetadataCluster() {
        return this.currentMetadataCluster;
    }

    private void currentMetadataCluster_$eq(Cluster x$1) {
        this.currentMetadataCluster = x$1;
    }

    private Node currentCoordinator() {
        return this.currentCoordinator;
    }

    private void currentCoordinator_$eq(Node x$1) {
        this.currentCoordinator = x$1;
    }

    public void doWork() {
        block8: {
            Option start = Option$.MODULE$.empty();
            try {
                try {
                    this.clusterLinkClient().networkClient().poll(Long.MAX_VALUE, this.time.milliseconds());
                    start = new Some((Object)BoxesRunTime.boxToLong((long)this.time.nanoseconds()));
                    this.maybeFindCoordinator();
                    Cluster newMetadataCluster = this.clusterLinkMetadata().fetch();
                    if (newMetadataCluster != this.currentMetadataCluster()) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Process cluster link metadata ").append(newMetadataCluster).toString());
                        this.metadataListeners().foreach((Function1 & Serializable)x$4 -> {
                            x$4.onNewMetadata(newMetadataCluster);
                            return BoxedUnit.UNIT;
                        });
                        this.currentMetadataCluster_$eq(newMetadataCluster);
                        this.currentCoordinator_$eq(null);
                        this.maybeFindCoordinator();
                        this.dynamicLogger().resetErrors();
                    } else {
                        this.clusterLinkMetadata().maybeThrowFatalException();
                    }
                }
                catch (Throwable throwable) {
                    if (throwable instanceof DisconnectException && !this.clusterLinkClient().networkClient().active()) break block8;
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        this.dynamicLogger().error("Failed to refresh metadata", exception);
                        this.metadataListeners().foreach((Function1 & Serializable)x$5 -> {
                            x$5.onMetadataFailure(exception);
                            return BoxedUnit.UNIT;
                        });
                        break block8;
                    }
                    throw throwable;
                }
            }
            finally {
                start.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)s -> $this.quota.record($this.time.nanoseconds() - s, LinkRequestQuotaUsageType$Metadata$.MODULE$));
            }
        }
    }

    public boolean initiateShutdown() {
        if (super.initiateShutdown()) {
            this.clusterLinkClient().initiateClose();
            return true;
        }
        return false;
    }

    public void awaitShutdown() {
        try {
            super.awaitShutdown();
        }
        catch (InterruptedException interruptedException) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Interrupted while awaiting metadata shutdown");
            super.awaitShutdown();
        }
        try {
            this.clusterLinkClient().close();
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to close metadata client after shutting down thread", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public void addListener(MetadataListener listener) {
        this.metadataListeners().$plus$eq((Object)listener);
    }

    public void addCoordinatorListener(CoordinatorListener listener) {
        this.coordinatorListeners().$plus$eq((Object)listener);
    }

    public Option<Node> remoteLinkCoordinator() {
        return Option$.MODULE$.apply((Object)this.currentCoordinator());
    }

    public ClusterLinkNetworkClient createNetworkClient(ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata) {
        ClusterLinkNetworkClient clusterLinkClient = new ClusterLinkNetworkClient(this.brokerConfig, clusterLinkConfig, ClusterLinkMetrics$.MODULE$.throttleTimeSensorName(clusterLinkMetadata.linkName()), (Option<ClusterLinkMetadata>)new Some((Object)clusterLinkMetadata), (Option<MetadataUpdater>)None$.MODULE$, this.metrics, ClusterLinkFactory$.MODULE$.linkMetricTags(clusterLinkMetadata.linkName()), this.time, new StringBuilder(22).append("cluster-link-metadata-").append(clusterLinkMetadata.linkDescription()).toString(), this.clientType, this.logContext());
        this.connectionManager.foreach((Function1 & Serializable)x$6 -> {
            x$6.enableClusterLink(clusterLinkClient, (Option<AdminMetadataManager>)None$.MODULE$);
            return BoxedUnit.UNIT;
        });
        return clusterLinkClient;
    }

    @Override
    public void onMetadataRequestUpdate() {
        this.clusterLinkClient().networkClient().wakeup();
    }

    private void maybeFindCoordinator() {
        Node controller;
        Node node = controller = this.currentMetadataCluster() == null ? null : this.currentMetadataCluster().controller();
        if (this.currentCoordinator() == null && this.coordinatorListeners().nonEmpty() && controller != null && controller.id() >= 0) {
            if (this.clusterLinkClient().networkClient().ready(controller, this.time.milliseconds())) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Determine link coordinator using DescribeClusterLinks controllerId=").append(controller).toString());
                DescribeClusterLinksRequest.Builder requestBuilder = new DescribeClusterLinksRequest.Builder(Optional.of(Collections.singleton(this.clusterLinkMetadata().linkName())), false, Predef$.MODULE$.Integer2int(this.clusterLinkConfig.requestTimeoutMs()));
                long now = this.time.milliseconds();
                ClientRequest request = this.clusterLinkClient().networkClient().newClientRequest(controller.idString(), (AbstractRequest.Builder)requestBuilder, now, true, Predef$.MODULE$.Integer2int(this.clusterLinkConfig.requestTimeoutMs()), response -> this.processDescribeClusterLinkResponse(response));
                this.clusterLinkClient().networkClient().send(request, now);
                return;
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Controller connection not yet ready to send DescribeClusterLinks request");
            return;
        }
    }

    private void processDescribeClusterLinkResponse(ClientResponse response) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Process DescribeClusterLinks response ").append(response).toString());
        if (response.wasDisconnected()) {
            this.clusterLinkMetadata().requestUpdate();
            return;
        }
        if (response.versionMismatch() != null || response.requestHeader().apiVersion() < 1) {
            this.useControllerAsLinkCoordinator();
            return;
        }
        DescribeClusterLinksResponseData describeResponse = ((DescribeClusterLinksResponse)response.responseBody()).data();
        if (describeResponse.errorCode() == Errors.NONE.code() && !describeResponse.entries().isEmpty()) {
            DescribeClusterLinksResponseData.EntryData entry = (DescribeClusterLinksResponseData.EntryData)describeResponse.entries().get(0);
            if (entry.linkCoordinatorId() != -1) {
                Node coordinator = new Node(entry.linkCoordinatorId(), entry.linkCoordinatorHost(), entry.linkCoordinatorPort());
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Remote link coordinator is ").append(coordinator).toString());
                this.currentCoordinator_$eq(coordinator);
                this.coordinatorListeners().foreach((Function1 & Serializable)x$7 -> {
                    x$7.onNewRemoteLinkCoordinator(coordinator);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (entry.linkState() == ClusterLinkDescription.LinkState.ACTIVE.getValue()) {
                this.useControllerAsLinkCoordinator();
                return;
            }
            return;
        }
        this.useControllerAsLinkCoordinator();
    }

    private void useControllerAsLinkCoordinator() {
        Node controller;
        Node node = controller = this.currentMetadataCluster() == null ? null : this.currentMetadataCluster().controller();
        if (controller != null && controller.id() != -1) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Cluster link coordinator not known, using controller ").append(controller).append(" instead").toString());
            this.currentCoordinator_$eq(controller);
            this.coordinatorListeners().foreach((Function1 & Serializable)x$8 -> {
                x$8.onNewRemoteLinkCoordinator(controller);
                return BoxedUnit.UNIT;
            });
            return;
        }
        this.clusterLinkMetadata().requestUpdate();
    }

    public ClusterLinkMetadataThread(KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, Option<ClusterLinkConnectionManager> connectionManager, ClusterLinkMetadata clusterLinkMetadata, Metrics metrics, ClusterLinkClientType clientType, ClusterLinkRequestQuota quota, Time time) {
        this.brokerConfig = brokerConfig;
        this.clusterLinkConfig = clusterLinkConfig;
        this.connectionManager = connectionManager;
        this.clusterLinkMetadata = clusterLinkMetadata;
        this.metrics = metrics;
        this.clientType = clientType;
        this.quota = quota;
        this.time = time;
        super(new StringBuilder(13).append("LinkMetadata-").append(clusterLinkMetadata.linkDescription()).toString());
        this.logContext = new LogContext(new StringBuilder(29).append("[ClusterLinkMetadataClient ").append(clusterLinkMetadata.linkDescription()).append("] ").toString(), (AtomicReference)connectionManager.map((Function1 & Serializable)x$1 -> x$1.maxLogLevel()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.clusterLinkClient = this.createNetworkClient(clusterLinkConfig, clusterLinkMetadata);
        this.dynamicLogger = new ClusterLinkDynamicLogger(this, 10, 5, 10000);
        this.metadataListeners = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.coordinatorListeners = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        clusterLinkMetadata.setRefreshListener(this);
    }
}

