/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import io.confluent.kafka.storage.checksum.E2EChecksumProtectedFileType;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import kafka.server.Defaults;
import kafka.server.KafkaConfig;
import kafka.tier.store.AzureBlockBlobTierObjectStore;
import kafka.tier.store.AzureBlockBlobTierObjectStoreConfig;
import kafka.tier.store.GcsTierObjectStore;
import kafka.tier.store.GcsTierObjectStoreConfig;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.S3TierObjectStore;
import kafka.tier.store.S3TierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.store.TierObjectStoreMetricsEnabled;
import kafka.tier.tools.TierObjectStoreFactory;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;

public class TierObjectStoreUtils {
    public static final List<String> OBJECT_STORE_REQUIRED_PROPERTIES = Arrays.asList(KafkaConfig.TierMetadataNamespaceProp(), KafkaConfig.TierBackendProp(), KafkaConfig.TierS3RegionProp(), KafkaConfig.TierS3BucketProp(), KafkaConfig.TierS3PrefixProp(), KafkaConfig.TierS3AssumeRoleArnProp(), KafkaConfig.TierS3CredFilePathProp(), KafkaConfig.TierGcsRegionProp(), KafkaConfig.TierGcsBucketProp(), KafkaConfig.TierGcsPrefixProp(), KafkaConfig.TierGcsCredFilePathProp(), KafkaConfig.TierGcsWriteChunkSizeProp(), KafkaConfig.TierAzureBlockBlobContainerProp(), KafkaConfig.TierAzureBlockBlobCredFilePathProp(), KafkaConfig.TierAzureBlockBlobEndpointProp(), KafkaConfig.TierAzureBlockBlobPrefixProp(), KafkaConfig.TierAzureBlockBlobAutoAbortThresholdBytesProp());

    public static Optional<TierObjectStore> maybeCreateTierObjectStore(KafkaConfig config, String clusterId, Metrics metrics, Time time, Optional<E2EChecksumStore> checksumStoreOpt) {
        TierObjectStore tierObjectStore;
        if (!config.confluentConfig().tierFeature().booleanValue()) {
            return Optional.empty();
        }
        switch (config.confluentConfig().tierBackend()) {
            case "S3": {
                tierObjectStore = new TierObjectStoreMetricsEnabled(new S3TierObjectStore(new S3TierObjectStoreConfig(Optional.of(clusterId), config), checksumStoreOpt), metrics, time);
                break;
            }
            case "GCS": {
                tierObjectStore = new TierObjectStoreMetricsEnabled(new GcsTierObjectStore(time, metrics, new GcsTierObjectStoreConfig(Optional.of(clusterId), config), checksumStoreOpt), metrics, time);
                break;
            }
            case "AzureBlockBlob": {
                tierObjectStore = new TierObjectStoreMetricsEnabled(new AzureBlockBlobTierObjectStore(new AzureBlockBlobTierObjectStoreConfig(Optional.of(clusterId), config)), metrics, time);
                break;
            }
            case "mock": {
                tierObjectStore = new MockInMemoryTierObjectStore(time, metrics, new MockInMemoryTierObjectStoreConfig(Optional.of(clusterId), config));
                break;
            }
            default: {
                throw new ConfigException("Unknown TierObjectStore type");
            }
        }
        return Optional.of(tierObjectStore);
    }

    public static TierObjectStoreConfig generateBackendConfig(TierObjectStore.Backend backend, Properties props) {
        switch (backend) {
            case S3: {
                ArrayList<String> mandatoryProps = new ArrayList<String>(){
                    {
                        this.add(KafkaConfig.TierS3BucketProp());
                        this.add(KafkaConfig.TierS3RegionProp());
                    }
                };
                TierObjectStoreUtils.verifyMandatoryProps(backend, props, (List<String>)mandatoryProps);
                String s3Bucket = props.getProperty(KafkaConfig.TierS3BucketProp());
                String s3Region = props.getProperty(KafkaConfig.TierS3RegionProp());
                return S3TierObjectStoreConfig.createWithEmptyClusterIdBrokerId(s3Bucket, s3Region, props.getProperty(KafkaConfig.TierS3CredFilePathProp()), props.getProperty(KafkaConfig.TierS3EndpointOverrideProp()), props.getProperty(KafkaConfig.TierS3SignerOverrideProp()), props.getProperty(KafkaConfig.TierS3SseAlgorithmProp(), Defaults.TierS3SseAlgorithm()), props.getProperty(KafkaConfig.TierS3SseCustomerEncryptionKeyProp(), Defaults.TierS3SseCustomerEncryptionKey()), Integer.parseInt(props.getOrDefault((Object)KafkaConfig.TierS3AutoAbortThresholdBytesProp(), Defaults.TierS3AutoAbortThresholdBytes()).toString()), props.getProperty(KafkaConfig.TierS3PrefixProp(), Defaults.TierS3Prefix()), props.getProperty(KafkaConfig.TierS3AssumeRoleArnProp(), Defaults.TierS3AssumeRoleArn()), Boolean.valueOf(props.getProperty(KafkaConfig.TierS3ForcePathStyleAccessProp(), Boolean.toString(Defaults.TierS3ForcePathStyleAccess()))), props.getProperty(KafkaConfig.TierS3UserAgentPrefix(), Defaults.TierS3UserAgentPrefix()), props.getProperty(KafkaConfig.TierS3SslProtocolProp(), Defaults.TierS3SslProtocol()), props.getProperty(KafkaConfig.TierS3SslEnabledProtocolsProp(), Defaults.TierS3SslEnabledProtocols()), props.getProperty(KafkaConfig.TierS3SslTrustStoreLocationProp()), (Password)props.get(KafkaConfig.TierS3SslTrustStorePasswordProp()), props.getProperty(KafkaConfig.TierS3SslTrustStoreTypeProp()), props.getProperty(KafkaConfig.TierS3SslKeyStoreLocationProp()), (Password)props.get(KafkaConfig.TierS3SslKeyStorePasswordProp()), props.getProperty(KafkaConfig.TierS3SslKeyStoreTypeProp()), (Password)props.get(KafkaConfig.TierS3SslKeyPasswordProp()));
            }
            case GCS: {
                ArrayList<String> mandatoryProps = new ArrayList<String>(){
                    {
                        this.add(KafkaConfig.TierGcsBucketProp());
                        this.add(KafkaConfig.TierGcsRegionProp());
                    }
                };
                TierObjectStoreUtils.verifyMandatoryProps(backend, props, (List<String>)mandatoryProps);
                String gcsBucket = props.getProperty(KafkaConfig.TierGcsBucketProp());
                String gcsRegion = props.getProperty(KafkaConfig.TierGcsRegionProp());
                String gcsPrefix = props.getProperty(KafkaConfig.TierGcsPrefixProp());
                return GcsTierObjectStoreConfig.createWithEmptyClusterIdBrokerId(gcsBucket, gcsPrefix, gcsRegion, Integer.parseInt(props.getOrDefault((Object)KafkaConfig.TierGcsWriteChunkSizeProp(), (Object)Defaults.TierGcsWriteChunkSize()).toString()), props.getProperty(KafkaConfig.TierGcsCredFilePathProp()), props.getProperty(KafkaConfig.TierGcsSseCustomerEncryptionKeyProp()), Duration.ofSeconds(30L));
            }
            case AzureBlockBlob: {
                ArrayList<String> mandatoryProps = new ArrayList<String>(){
                    {
                        this.add(KafkaConfig.TierAzureBlockBlobContainerProp());
                    }
                };
                TierObjectStoreUtils.verifyMandatoryProps(backend, props, (List<String>)mandatoryProps);
                return AzureBlockBlobTierObjectStoreConfig.createWithEmptyClusterIdBrokerId(Optional.ofNullable(props.getProperty(KafkaConfig.TierAzureBlockBlobCredFilePathProp())), Optional.ofNullable(props.getProperty(KafkaConfig.TierAzureBlockBlobEndpointProp())), props.getProperty(KafkaConfig.TierAzureBlockBlobContainerProp()), props.getProperty(KafkaConfig.TierAzureBlockBlobPrefixProp(), Defaults.TierAzureBlockBlobPrefix()), Integer.parseInt(props.getProperty(KafkaConfig.TierAzureBlockBlobAutoAbortThresholdBytesProp(), Defaults.TierAzureBlockBlobAutoAbortThresholdBytes().toString())));
            }
            case Mock: {
                return new MockInMemoryTierObjectStoreConfig();
            }
        }
        throw new UnsupportedOperationException("Unsupported backend for config generation: " + (Object)((Object)backend));
    }

    public static TierObjectStore objectStore(String objectStoreConfigFile) throws IOException {
        Properties props;
        try {
            props = Utils.loadProps((String)objectStoreConfigFile, OBJECT_STORE_REQUIRED_PROPERTIES);
        }
        catch (IOException e) {
            System.err.println("Exception while loading object store properties from file: " + objectStoreConfigFile);
            throw e;
        }
        return TierObjectStoreUtils.getObjectStore(props);
    }

    private static TierObjectStore getObjectStore(Properties props) {
        TierObjectStore.Backend backend = TierObjectStore.Backend.valueOf(props.getProperty(KafkaConfig.TierBackendProp()));
        TierObjectStoreConfig config = TierObjectStoreUtils.generateBackendConfig(backend, props);
        return TierObjectStoreFactory.getObjectStoreInstance(Time.SYSTEM, backend, config);
    }

    public static ByteBuffer timeHealthPayload() {
        return ByteBuffer.wrap(Long.toString(System.currentTimeMillis()).getBytes(StandardCharsets.UTF_8));
    }

    private static void verifyMandatoryProps(TierObjectStore.Backend backend, Properties props, List<String> mandatoryProps) {
        List absentProps = mandatoryProps.stream().filter(key -> !props.containsKey(key)).collect(Collectors.toList());
        if (absentProps.size() > 0) {
            throw new IllegalArgumentException("Missing mandatory props for backend: " + (Object)((Object)backend) + ": " + absentProps + " mandatoryProps: " + mandatoryProps);
        }
    }

    public static void postPutSegmentCleanup(E2EChecksumStore checksumStore, File segmentData, File offsetIndexData, File timestampIndexData) {
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedFileType.SEGMENT)) {
            checksumStore.store().remove(segmentData.getAbsolutePath());
        }
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedFileType.OFFSET_INDEX)) {
            checksumStore.store().remove(offsetIndexData.getAbsolutePath());
        }
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedFileType.TIMESTAMP_INDEX)) {
            checksumStore.store().remove(timestampIndexData.getAbsolutePath());
        }
    }
}

