/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\tUa!B\r\u001b\u0003\u0003\t\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\t\u000b}\u0002A\u0011\u0001!\t\u00111\u0003\u0001\u0019!C\u000195C\u0001\"\u0015\u0001A\u0002\u0013\u0005AD\u0015\u0005\u00071\u0002\u0001\u000b\u0015\u0002(\t\u000fu\u0003\u0001\u0019!C\u0005=\"9\u0001\u000e\u0001a\u0001\n\u0013I\u0007BB6\u0001A\u0003&q\fC\u0004n\u0001\t\u0007I\u0011\u00028\t\u000f\u0005\r\u0001\u0001)A\u0005_\"9\u0011Q\u0001\u0001\u0007\u0002\u0005\u001d\u0001bBA\t\u0001\u0019\u0005\u00111\u0003\u0005\b\u0003C\u0001a\u0011AA\u0012\u0011\u0019\t\t\u000b\u0001C\u0001=\"9\u00111\u0015\u0001\u0005\u0002\u0005\u0015\u0006bBAW\u0001\u0011\u0005!D\u001c\u0005\b\u0003_\u0003A\u0011AAY\u0011!\tY\f\u0001C\t5\u0005u\u0006bBAi\u0001\u0011E\u00111\u001b\u0005\t\u00037\u0004A\u0011\u0003\u000e\u0002^\"A\u0011\u0011\u001d\u0001\u0005\u0012i\t\u0019\u000f\u0003\u0005\u0003\u0004\u0001!\tB\u0007B\u0003\u0011\u001d\u0011I\u0001\u0001C\t\u0005\u0017AqA!\u0004\u0001\t#\u0011yA\u0001\u0005US\u0016\u0014H+Y:l\u0015\tYB$A\u0003uCN\\7O\u0003\u0002\u001e=\u0005!A/[3s\u0015\u0005y\u0012!B6bM.\f7\u0001A\u000b\u0003E\u0015\u001b2\u0001A\u0012*!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fMB\u0011!&L\u0007\u0002W)\u0011AFH\u0001\u0006kRLGn]\u0005\u0003]-\u0012q\u0001T8hO&tw-\u0001\u0007sKR\u0014\u0018PU1uK>\u0003H\u000fE\u0002%cMJ!AM\u0013\u0003\r=\u0003H/[8o!\t!T(D\u00016\u0015\t1t'\u0001\u0003d_J,'B\u0001\u001d:\u0003\u001diW\r\u001e:jGNT!AO\u001e\u0002\re\fW.\\3s\u0015\u0005a\u0014aA2p[&\u0011a(\u000e\u0002\u0006\u001b\u0016$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005[\u0005c\u0001\"\u0001\u00076\t!\u0004\u0005\u0002E\u000b2\u0001A!\u0002$\u0001\u0005\u00049%!\u0001+\u0012\u0005!\u000b\u0005C\u0001\u0013J\u0013\tQUEA\u0004O_RD\u0017N\\4\t\u000b=\u0012\u0001\u0019\u0001\u0019\u0002\u0015I,GO]=D_VtG/F\u0001O!\t!s*\u0003\u0002QK\t\u0019\u0011J\u001c;\u0002\u001dI,GO]=D_VtGo\u0018\u0013fcR\u00111K\u0016\t\u0003IQK!!V\u0013\u0003\tUs\u0017\u000e\u001e\u0005\b/\u0012\t\t\u00111\u0001O\u0003\rAH%M\u0001\fe\u0016$(/_\"pk:$\b\u0005\u000b\u0002\u00065B\u0011AeW\u0005\u00039\u0016\u0012\u0001B^8mCRLG.Z\u0001\r?B\fWo]3e+:$\u0018\u000e\\\u000b\u0002?B\u0019A%\r1\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017\u0001\u0002;j[\u0016T\u0011!Z\u0001\u0005U\u00064\u0018-\u0003\u0002hE\n9\u0011J\\:uC:$\u0018\u0001E0qCV\u001cX\rZ+oi&dw\fJ3r)\t\u0019&\u000eC\u0004X\u000f\u0005\u0005\t\u0019A0\u0002\u001b}\u0003\u0018-^:fIVsG/\u001b7!Q\tA!,A\u0004`KJ\u0014xN]:\u0016\u0003=\u00042\u0001]:v\u001b\u0005\t(B\u0001:e\u0003\u0011)H/\u001b7\n\u0005Q\f(aA*fiB\u0011aO \b\u0003ort!\u0001_>\u000e\u0003eT!A\u001f\u0011\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0013BA?&\u0003\u001d\u0001\u0018mY6bO\u0016L1a`A\u0001\u0005%!\u0006N]8xC\ndWM\u0003\u0002~K\u0005Aq,\u001a:s_J\u001c\b%\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]V\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\ti!D\u0001\u001d\u0013\r\ty\u0001\b\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\f1a\u0019;y+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tY\u0002H\u0001\bM\u0016$8\r[3s\u0013\u0011\ty\"!\u0007\u0003'\r\u000bgnY3mY\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0015Q\u0014\u0018M\\:ji&|g\u000e\u0006\b\u0002&\u0005u\u0012qKA4\u0003o\n9)!&\u0015\t\u0005\u001d\u00121\u0007\t\u0006\u0003S\tycQ\u0007\u0003\u0003WQ1!!\f&\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003c\tYC\u0001\u0004GkR,(/\u001a\u0005\b\u0003ki\u00019AA\u001c\u0003\t)7\r\u0005\u0003\u0002*\u0005e\u0012\u0002BA\u001e\u0003W\u0011\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\r\rl\u0001\u0019AA !\u0011\t\t%a\u0015\u000e\u0005\u0005\r#b\u0001\u0017\u0002F)!\u0011qIA%\u0003\u0019\u0019w.\\7p]*\u0019q$a\u0013\u000b\t\u00055\u0013qJ\u0001\u0007CB\f7\r[3\u000b\u0005\u0005E\u0013aA8sO&!\u0011QKA\"\u0005\u0011!\u0016.\\3\t\u000f\u0005eS\u00021\u0001\u0002\\\u0005\tB/[3s)>\u0004\u0018nY!qa\u0016tG-\u001a:\u0011\t\u0005u\u00131M\u0007\u0003\u0003?R1!!\u0019\u001d\u0003\u0015!x\u000e]5d\u0013\u0011\t)'a\u0018\u0003#QKWM\u001d+pa&\u001c\u0017\t\u001d9f]\u0012,'\u000fC\u0004\u0002j5\u0001\r!a\u001b\u0002\u001fQLWM](cU\u0016\u001cGo\u0015;pe\u0016\u0004B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0004\u0003cb\u0012!B:u_J,\u0017\u0002BA;\u0003_\u0012q\u0002V5fe>\u0013'.Z2u'R|'/\u001a\u0005\b\u0003sj\u0001\u0019AA>\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0004\u0003\u0003s\u0012AB:feZ,'/\u0003\u0003\u0002\u0006\u0006}$A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\b\u0003\u0013k\u0001\u0019AAF\u0003\u0019\u0019wN\u001c4jOB!\u0011QRAI\u001b\t\tyIC\u0002\u0002\njIA!a%\u0002\u0010\nyA+[3s)\u0006\u001c8n]\"p]\u001aLw\rC\u0004\u0002\u00186\u0001\r!!'\u0002\u0013QD'o\u001c;uY\u0016\u0014\b\u0003\u0002\u00132\u00037\u00032AKAO\u0013\r\tyj\u000b\u0002\n)\"\u0014x\u000e\u001e;mKJ\f1\u0002]1vg\u0016$WK\u001c;jY\u0006a\u0011n]#se>\u00148\u000b^1uKV\u0011\u0011q\u0015\t\u0004I\u0005%\u0016bAAVK\t9!i\\8mK\u0006t\u0017aC3se>\u00148\u000b^1uKN\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0006\u0002\u00024B!\u0011QWA\\\u001b\t\t)%\u0003\u0003\u0002:\u0006\u0015#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000fe\u0016$(/\u001f+bg.d\u0015\r^3s)\u001d\u0019\u0016qXAb\u0003\u001bDa!!1\u0013\u0001\u0004q\u0015!E7bqJ+GO]=CC\u000e\\wN\u001a4Ng\"9\u0011Q\u0019\nA\u0002\u0005\u001d\u0017!\u00028po6\u001b\bc\u0001\u0013\u0002J&\u0019\u00111Z\u0013\u0003\t1{gn\u001a\u0005\u0007\u0003\u001f\u0014\u0002\u0019A;\u0002\u0003Q\f\u0011\u0002Z3mCf$\u0016m]6\u0015\u000bM\u000b).!7\t\r\u0005]7\u00031\u0001O\u0003\u001d!W\r\\1z\u001bNDq!!2\u0014\u0001\u0004\t9-A\u0007tKR,%O]8s'R\fG/\u001a\u000b\u0004'\u0006}\u0007BBAh)\u0001\u0007Q/A\bdY\u0016\f'/\u0012:s_J\u001cF/\u0019;f)\r\u0019\u0016Q\u001d\u0005\b\u0003O,\u0002\u0019AAu\u00039!\bN]8xC\ndWm\u00117bgN\u0004D!a;\u0002~B1\u0011Q^A{\u0003wtA!a<\u0002rB\u0011\u00010J\u0005\u0004\u0003g,\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002x\u0006e(!B\"mCN\u001c(bAAzKA\u0019A)!@\u0005\u0019\u0005}\u0018Q]A\u0001\u0002\u0003\u0015\tA!\u0001\u0003\u0007}#\u0013'\u0005\u0002Ik\u000612-\u00198dK2\fe\u000eZ*fi\u0016\u0013(o\u001c:Ti\u0006$X\rF\u0002T\u0005\u000fAa!a4\u0017\u0001\u0004)\u0018AF8o'V\u001c7-Z:tMVdGK]1og&$\u0018n\u001c8\u0015\u0003M\u000bqd\u001c8Tk\u000e\u001cWm]:gk2$&/\u00198tSRLwN\\,ji\"$U\r\\1z)\u0015\u0019&\u0011\u0003B\n\u0011\u001d\t9\u000e\u0007a\u0001\u0003\u000fDq!!2\u0019\u0001\u0004\t9\r")
public abstract class TierTask<T extends TierTask<T>>
implements Logging {
    private final Option<Meter> retryRateOpt;
    private volatile int retryCount;
    private volatile Option<Instant> _pausedUntil;
    private final Set<Throwable> _errors;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int retryCount() {
        return this.retryCount;
    }

    public void retryCount_$eq(int x$1) {
        this.retryCount = x$1;
    }

    private Option<Instant> _pausedUntil() {
        return this._pausedUntil;
    }

    private void _pausedUntil_$eq(Option<Instant> x$1) {
        this._pausedUntil = x$1;
    }

    private Set<Throwable> _errors() {
        return this._errors;
    }

    public abstract TopicIdPartition topicIdPartition();

    public abstract CancellationContext ctx();

    public abstract Future<T> transition(Time var1, TierTopicAppender var2, TierObjectStore var3, ReplicaManager var4, TierTasksConfig var5, Option<Throttler> var6, ExecutionContext var7);

    public Option<Instant> pausedUntil() {
        return this._pausedUntil();
    }

    public boolean isErrorState() {
        return !this._errors().isEmpty();
    }

    public Set<Throwable> errorStates() {
        return this._errors();
    }

    public TopicPartition topicPartition() {
        return this.topicIdPartition().topicPartition();
    }

    public void retryTaskLater(int maxRetryBackoffMs, long nowMs, Throwable t) {
        this.retryCount_$eq(this.retryCount() + 1);
        this.retryRateOpt.foreach((Function1 & Serializable)x$1 -> {
            x$1.mark();
            return BoxedUnit.UNIT;
        });
        Instant now = Instant.ofEpochMilli(nowMs);
        int pauseMs = Math.min(maxRetryBackoffMs, (Random$.MODULE$.nextInt(this.retryCount()) + 1) * 1000);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("retrying ").append(this).append(" after ").append(pauseMs).append("ms").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
        this._pausedUntil_$eq((Option<Instant>)new Some((Object)now.plusMillis(pauseMs)));
    }

    public void delayTask(int delayMs, long nowMs) {
        Instant now = Instant.ofEpochMilli(nowMs);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("retrying ").append(this).append(" after ").append(delayMs).append("ms").toString());
        this._pausedUntil_$eq((Option<Instant>)new Some((Object)now.plusMillis(delayMs)));
    }

    public void setErrorState(Throwable t) {
        this._errors().add(t);
    }

    public void clearErrorState(Class<? extends Throwable> throwableClass) {
        this._errors().removeIf(error -> {
            Class<?> clazz = error.getClass();
            return !(clazz != null ? !clazz.equals(throwableClass) : throwableClass != null);
        });
    }

    public void cancelAndSetErrorState(Throwable t) {
        this.setErrorState(t);
        this.ctx().cancel();
    }

    public void onSuccessfulTransition() {
        this.retryCount_$eq(0);
        this._pausedUntil_$eq((Option<Instant>)None$.MODULE$);
    }

    public void onSuccessfulTransitionWithDelay(long delayMs, long nowMs) {
        Instant now = Instant.ofEpochMilli(nowMs);
        this.onSuccessfulTransition();
        this._pausedUntil_$eq((Option<Instant>)new Some((Object)now.plusMillis(delayMs)));
    }

    public TierTask(Option<Meter> retryRateOpt) {
        this.retryRateOpt = retryRateOpt;
        this.retryCount = 0;
        this._pausedUntil = None$.MODULE$;
        this._errors = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

