/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.E2EChecksumInvalidException;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierArchiverFailedException;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.exceptions.TierArchiverRestoreFencedException;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask$;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.FailedState;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Throttler;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.collection.Iterator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rUd\u0001\u0002\u001b6\u0005yB\u0001b\u0013\u0001\u0003\u0006\u0004%\t\u0005\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005\u001b\"AA\u000b\u0001BC\u0002\u0013\u0005S\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003W\u0011!Y\u0006A!a\u0001\n\u0003a\u0006\u0002\u00031\u0001\u0005\u0003\u0007I\u0011A1\t\u0011)\u0004!\u0011!Q!\nuC\u0001b\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\t_\u0002\u0011)\u0019!C\u0001a\"AA\u000f\u0001B\u0001B\u0003%\u0011\u000fC\u0003v\u0001\u0011\u0005a\u000fC\u0003}\u0001\u0011\u0005S\u0010C\u0004\u0002\u0014\u0001!\t%!\u0006\t\u000f\u0005e\u0005\u0001\"\u0011\u0002\u001c\u001e9\u00111V\u001b\t\u0002\u00055fA\u0002\u001b6\u0011\u0003\ty\u000b\u0003\u0004v!\u0011\u0005\u0011q\u0017\u0005\u0006yB!\t& \u0005\b\u0003s\u0003B\u0011AA^\u0011!\tI\r\u0005C\u0001k\u0005-\u0007\u0002CAn!\u0011\u0005Q'!8\t\u0011\u0005m\b\u0003\"\u00016\u0003{D\u0001Ba\u0004\u0011\t\u0003)$\u0011\u0003\u0005\u000b\u0005g\u0001\u0012\u0013!C\u0001k\tU\u0002\u0002\u0003B&!\u0011\u0005QG!\u0014\t\u0011\te\u0004\u0003\"\u00016\u0005wBqA!(\u0011\t\u0013\u0011yJ\u0002\u0004\u0003*B\u0001%1\u0016\u0005\n\u0005#d\"Q3A\u0005\u0002uD\u0011Ba5\u001d\u0005#\u0005\u000b\u0011\u0002@\t\u0015\tUGD!f\u0001\n\u0003\u00119\u000e\u0003\u0006\u0003`r\u0011\t\u0012)A\u0005\u00053Da!\u001e\u000f\u0005\u0002\t\u0005\b\"\u0003Bv9\u0005\u0005I\u0011\u0001Bw\u0011%\u0011\u0019\u0010HI\u0001\n\u0003\u0011)\u0010C\u0005\u0003zr\t\n\u0011\"\u0001\u0003|\"I!q \u000f\u0002\u0002\u0013\u00053\u0011\u0001\u0005\t\u0007\u0007a\u0012\u0011!C\u0001a\"I1Q\u0001\u000f\u0002\u0002\u0013\u00051q\u0001\u0005\n\u0007#a\u0012\u0011!C!\u0007'A\u0011b!\t\u001d\u0003\u0003%\taa\t\t\u0013\r\u001dB$!A\u0005B\r%\u0002\"CB\u00179\u0005\u0005I\u0011IB\u0018\u0011%\u0019\t\u0004HA\u0001\n\u0003\u001a\u0019dB\u0005\u00048A\t\t\u0011#\u0001\u0004:\u0019I!\u0011\u0016\t\u0002\u0002#\u000511\b\u0005\u0007k:\"\taa\u0015\t\u0013\u0005ee&!A\u0005F\u0005m\u0005\"CA]]\u0005\u0005I\u0011QB+\u0011%\u0019YFLA\u0001\n\u0003\u001bi\u0006C\u0005\u0004l9\n\t\u0011\"\u0003\u0004n\tY\u0011I]2iSZ,G+Y:l\u0015\t1t'A\u0004be\u000eD\u0017N^3\u000b\u0005aJ\u0014!\u0002;bg.\u001c(B\u0001\u001e<\u0003\u0011!\u0018.\u001a:\u000b\u0003q\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u007f\u0015\u00032\u0001Q!D\u001b\u00059\u0014B\u0001\"8\u0005!!\u0016.\u001a:UCN\\\u0007C\u0001#\u0001\u001b\u0005)\u0004C\u0001$J\u001b\u00059%B\u0001%<\u0003\u0015)H/\u001b7t\u0013\tQuIA\u0004M_\u001e<\u0017N\\4\u0002\u0007\r$\b0F\u0001N!\tq\u0015+D\u0001P\u0015\t\u0001\u0016(A\u0004gKR\u001c\u0007.\u001a:\n\u0005I{%aE\"b]\u000e,G\u000e\\1uS>t7i\u001c8uKb$\u0018\u0001B2uq\u0002\n\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\u0016\u0003Y\u0003\"a\u0016-\u000e\u0003eJ!!W\u001d\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017!\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8oA\u0005)1\u000f^1uKV\tQ\f\u0005\u0002E=&\u0011q,\u000e\u0002\u0011\u0003J\u001c\u0007.\u001b<f)\u0006\u001c8n\u0015;bi\u0016\f\u0011b\u001d;bi\u0016|F%Z9\u0015\u0005\tD\u0007CA2g\u001b\u0005!'\"A3\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d$'\u0001B+oSRDq!\u001b\u0004\u0002\u0002\u0003\u0007Q,A\u0002yIE\naa\u001d;bi\u0016\u0004\u0013aD1sG\"Lg/\u001a:NKR\u0014\u0018nY:\u0011\u0005\u0011k\u0017B\u000186\u0005=\t%o\u00195jm\u0016\u0014X*\u001a;sS\u000e\u001c\u0018\u0001\u00032s_.,'/\u00133\u0016\u0003E\u0004\"a\u0019:\n\u0005M$'aA%oi\u0006I!M]8lKJLE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\r;\b0\u001f>|\u0011\u0015Y5\u00021\u0001N\u0011\u0015!6\u00021\u0001W\u0011\u0015Y6\u00021\u0001^\u0011\u0015Y7\u00021\u0001m\u0011\u0015y7\u00021\u0001r\u0003)awnZ4fe:\u000bW.Z\u000b\u0002}B\u0019q0!\u0004\u000f\t\u0005\u0005\u0011\u0011\u0002\t\u0004\u0003\u0007!WBAA\u0003\u0015\r\t9!P\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-A-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\t\tB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0017!\u0017A\u0003;sC:\u001c\u0018\u000e^5p]Rq\u0011qCA\u0018\u0003\u0017\nY&a\u001b\u0002|\u0005%E\u0003BA\r\u0003K\u0001R!a\u0007\u0002\"\rk!!!\b\u000b\u0007\u0005}A-\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\t\u0002\u001e\t1a)\u001e;ve\u0016Dq!a\n\u000e\u0001\b\tI#\u0001\u0002fGB!\u00111DA\u0016\u0013\u0011\ti#!\b\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\bbBA\u0019\u001b\u0001\u0007\u00111G\u0001\u0005i&lW\r\u0005\u0003\u00026\u0005\u001dSBAA\u001c\u0015\rA\u0015\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0004d_6lwN\u001c\u0006\u0004y\u0005}\"\u0002BA!\u0003\u0007\na!\u00199bG\",'BAA#\u0003\ry'oZ\u0005\u0005\u0003\u0013\n9D\u0001\u0003US6,\u0007bBA'\u001b\u0001\u0007\u0011qJ\u0001\u0012i&,'\u000fV8qS\u000e\f\u0005\u000f]3oI\u0016\u0014\b\u0003BA)\u0003/j!!a\u0015\u000b\u0007\u0005U\u0013(A\u0003u_BL7-\u0003\u0003\u0002Z\u0005M#!\u0005+jKJ$v\u000e]5d\u0003B\u0004XM\u001c3fe\"9\u0011QL\u0007A\u0002\u0005}\u0013a\u0004;jKJ|%M[3diN#xN]3\u0011\t\u0005\u0005\u0014qM\u0007\u0003\u0003GR1!!\u001a:\u0003\u0015\u0019Ho\u001c:f\u0013\u0011\tI'a\u0019\u0003\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016Dq!!\u001c\u000e\u0001\u0004\ty'\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\t\u0005E\u0014qO\u0007\u0003\u0003gR1!!\u001e<\u0003\u0019\u0019XM\u001d<fe&!\u0011\u0011PA:\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDq!! \u000e\u0001\u0004\ty(\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003\u0003\u000b))\u0004\u0002\u0002\u0004*\u0019\u0011QP\u001c\n\t\u0005\u001d\u00151\u0011\u0002\u0010)&,'\u000fV1tWN\u001cuN\u001c4jO\"9\u00111R\u0007A\u0002\u00055\u0015!\u0003;ie>$H\u000f\\3s!\u0015\u0019\u0017qRAJ\u0013\r\t\t\n\u001a\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\u0019\u000b)*C\u0002\u0002\u0018\u001e\u0013\u0011\u0002\u00165s_R$H.\u001a:\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!(\u0011\t\u0005}\u0015\u0011V\u0007\u0003\u0003CSA!a)\u0002&\u0006!A.\u00198h\u0015\t\t9+\u0001\u0003kCZ\f\u0017\u0002BA\b\u0003C\u000b1\"\u0011:dQ&4X\rV1tWB\u0011A\tE\n\u0005!\u0005EV\tE\u0002d\u0003gK1!!.e\u0005\u0019\te.\u001f*fMR\u0011\u0011QV\u0001\u0006CB\u0004H.\u001f\u000b\f\u0007\u0006u\u0016qXAa\u0003\u000b\f9\rC\u0003L'\u0001\u0007Q\nC\u0003U'\u0001\u0007a\u000b\u0003\u0004\u0002DN\u0001\r!]\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000eC\u0003l'\u0001\u0007A\u000eC\u0003p'\u0001\u0007\u0011/\u0001\tdQ\u0016\u001c7NR1jY\u0016$7\u000b^1uKRA\u0011QZAh\u0003/\fI\u000eE\u0003\u0002\u001c\u0005\u0005R\f\u0003\u0004\\)\u0001\u0007\u0011\u0011\u001b\t\u0004\t\u0006M\u0017bAAkk\tYa)Y5mK\u0012\u001cF/\u0019;f\u0011\u0015!F\u00031\u0001W\u0011\u001d\ti\u0007\u0006a\u0001\u0003_\n1#Z:uC\nd\u0017n\u001d5MK\u0006$WM]:iSB$B\"a8\u0002l\u0006M\u0018Q_A|\u0003s$B!!9\u0002jB1\u00111DA\u0011\u0003G\u00042\u0001RAs\u0013\r\t9/\u000e\u0002\r\u0005\u00164wN]3Va2|\u0017\r\u001a\u0005\b\u0003O)\u00029AA\u0015\u0011\u0019YV\u00031\u0001\u0002nB\u0019A)a<\n\u0007\u0005EXG\u0001\u0007CK\u001a|'/\u001a'fC\u0012,'\u000fC\u0003U+\u0001\u0007a\u000bC\u0004\u0002NU\u0001\r!a\u0014\t\u000b=,\u0002\u0019A9\t\u000f\u00055T\u00031\u0001\u0002p\u0005\u0019R.Y=cK&s\u0017\u000e^5bi\u0016,\u0006\u000f\\8bIRq\u0011q B\u0002\u0005\u000b\u00119A!\u0003\u0003\f\t5A\u0003BAg\u0005\u0003Aq!a\n\u0017\u0001\b\tI\u0003\u0003\u0004\\-\u0001\u0007\u00111\u001d\u0005\u0006)Z\u0001\rA\u0016\u0005\b\u0003c1\u0002\u0019AA\u001a\u0011\u001d\tiE\u0006a\u0001\u0003\u001fBq!!\u0018\u0017\u0001\u0004\ty\u0006C\u0004\u0002nY\u0001\r!a\u001c\u0002\rU\u0004Hn\\1e)9\u0011\u0019Ba\b\u0003(\t%\"1\u0006B\u0017\u0005_!BA!\u0006\u0003\u001eA1\u00111DA\u0011\u0005/\u00012\u0001\u0012B\r\u0013\r\u0011Y\"\u000e\u0002\f\u0003\u001a$XM]+qY>\fG\rC\u0004\u0002(]\u0001\u001d!!\u000b\t\rm;\u0002\u0019\u0001B\u0011!\r!%1E\u0005\u0004\u0005K)$AB+qY>\fG\rC\u0003U/\u0001\u0007a\u000bC\u0004\u00022]\u0001\r!a\r\t\u000b-;\u0002\u0019A'\t\u000f\u0005us\u00031\u0001\u0002`!I!\u0011G\f\u0011\u0002\u0003\u0007\u0011QR\u0001\ri\"\u0014x\u000e\u001e;mKJ|\u0005\u000f^\u0001\u0011kBdw.\u00193%I\u00164\u0017-\u001e7uIY*\"Aa\u000e+\t\u00055%\u0011H\u0016\u0003\u0005w\u0001BA!\u0010\u0003H5\u0011!q\b\u0006\u0005\u0005\u0003\u0012\u0019%A\u0005v]\u000eDWmY6fI*\u0019!Q\t3\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003J\t}\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006qa-\u001b8bY&TX-\u00169m_\u0006$G\u0003\u0004B(\u0005'\u0012)Fa\u0016\u0003Z\tmC\u0003BAq\u0005#Bq!a\n\u001a\u0001\b\tI\u0003\u0003\u0004\\3\u0001\u0007!q\u0003\u0005\u0006)f\u0001\rA\u0016\u0005\b\u0003cI\u0002\u0019AA\u001a\u0011\u001d\ti%\u0007a\u0001\u0003\u001fBqA!\u0018\u001a\u0001\u0004\u0011y&\u0001\bcsR,'+\u0019;f\u001b\u0016$(/[2\u0011\u000b\r\fyI!\u0019\u0011\t\t\r$QO\u0007\u0003\u0005KRAAa\u001a\u0003j\u0005!1m\u001c:f\u0015\u0011\u0011YG!\u001c\u0002\u000f5,GO]5dg*!!q\u000eB9\u0003\u0019I\u0018-\\7fe*\u0011!1O\u0001\u0004G>l\u0017\u0002\u0002B<\u0005K\u0012Q!T3uKJ\f\u0011#\u001e9m_\u0006$\u0017M\u00197f'\u0016<W.\u001a8u)!\u0011iH!#\u0003\u0012\nm\u0005\u0003\u0002B@\u0005\u000bk!A!!\u000b\u0007\t\r5(A\u0002m_\u001eLAAa\"\u0003\u0002\n\tR\u000b\u001d7pC\u0012\f'\r\\3TK\u001elWM\u001c;\t\u000f\t\r%\u00041\u0001\u0003\fB!!q\u0010BG\u0013\u0011\u0011yI!!\u0003\u0017\u0005\u00137\u000f\u001e:bGRdun\u001a\u0005\b\u0005'S\u0002\u0019\u0001BK\u0003)awnZ*fO6,g\u000e\u001e\t\u0005\u0005\u007f\u00129*\u0003\u0003\u0003\u001a\n\u0005%A\u0003'pON+w-\\3oi\")AK\u0007a\u0001-\u0006\t2/Z4nK:$h)\u001b7fg\u0016C\u0018n\u001d;\u0015\t\t\u0005&q\u0015\t\u0004G\n\r\u0016b\u0001BSI\n9!i\\8mK\u0006t\u0007b\u0002B=7\u0001\u0007!Q\u0010\u0002\u0018'\u0016<W.\u001a8u\t\u0016dW\r^3e\u000bb\u001cW\r\u001d;j_:\u001cr\u0001\bBW\u0005s\u0013y\f\u0005\u0003\u00030\nUVB\u0001BY\u0015\u0011\u0011\u0019,!\u000f\u0002\r\u0015\u0014(o\u001c:t\u0013\u0011\u00119L!-\u0003%I+GO]5bE2,W\t_2faRLwN\u001c\t\u0004G\nm\u0016b\u0001B_I\n9\u0001K]8ek\u000e$\b\u0003\u0002Ba\u0005\u0017tAAa1\u0003H:!\u00111\u0001Bc\u0013\u0005)\u0017b\u0001BeI\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002Bg\u0005\u001f\u0014AbU3sS\u0006d\u0017N_1cY\u0016T1A!3e\u0003\ri7oZ\u0001\u0005[N<\u0007%A\u0003dCV\u001cX-\u0006\u0002\u0003ZB!!\u0011\u0019Bn\u0013\u0011\u0011iNa4\u0003\u0013QC'o\\<bE2,\u0017AB2bkN,\u0007\u0005\u0006\u0004\u0003d\n\u001d(\u0011\u001e\t\u0004\u0005KdR\"\u0001\t\t\r\tE\u0017\u00051\u0001\u007f\u0011\u001d\u0011).\ta\u0001\u00053\fAaY8qsR1!1\u001dBx\u0005cD\u0001B!5#!\u0003\u0005\rA \u0005\n\u0005+\u0014\u0003\u0013!a\u0001\u00053\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003x*\u001aaP!\u000f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q \u0016\u0005\u00053\u0014I$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003;\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0004\n\r=\u0001cA2\u0004\f%\u00191Q\u00023\u0003\u0007\u0005s\u0017\u0010C\u0004jO\u0005\u0005\t\u0019A9\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u0006\u0011\r\r]1QDB\u0005\u001b\t\u0019IBC\u0002\u0004\u001c\u0011\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019yb!\u0007\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005C\u001b)\u0003\u0003\u0005jS\u0005\u0005\t\u0019AB\u0005\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005u51\u0006\u0005\bS*\n\t\u00111\u0001r\u0003!A\u0017m\u001d5D_\u0012,G#A9\u0002\r\u0015\fX/\u00197t)\u0011\u0011\tk!\u000e\t\u0011%d\u0013\u0011!a\u0001\u0007\u0013\tqcU3h[\u0016tG\u000fR3mKR,G-\u0012=dKB$\u0018n\u001c8\u0011\u0007\t\u0015hfE\u0003/\u0007{\u0019I\u0005E\u0005\u0004@\r\u0015cP!7\u0003d6\u00111\u0011\t\u0006\u0004\u0007\u0007\"\u0017a\u0002:v]RLW.Z\u0005\u0005\u0007\u000f\u001a\tEA\tBEN$(/Y2u\rVt7\r^5p]J\u0002Baa\u0013\u0004R5\u00111Q\n\u0006\u0005\u0007\u001f\n)+\u0001\u0002j_&!!QZB')\t\u0019I\u0004\u0006\u0004\u0003d\u000e]3\u0011\f\u0005\u0007\u0005#\f\u0004\u0019\u0001@\t\u000f\tU\u0017\u00071\u0001\u0003Z\u00069QO\\1qa2LH\u0003BB0\u0007O\u0002RaYAH\u0007C\u0002baYB2}\ne\u0017bAB3I\n1A+\u001e9mKJB\u0011b!\u001b3\u0003\u0003\u0005\rAa9\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0004pA!\u0011qTB9\u0013\u0011\u0019\u0019(!)\u0003\r=\u0013'.Z2u\u0001")
public final class ArchiveTask
extends TierTask<ArchiveTask> {
    private final CancellationContext ctx;
    private final TopicIdPartition topicIdPartition;
    private ArchiveTaskState state;
    public final ArchiverMetrics kafka$tier$tasks$archive$ArchiveTask$$archiverMetrics;
    private final int brokerId;

    public static ArchiveTask apply(CancellationContext ctx, TopicIdPartition topicIdPartition, int leaderEpoch, ArchiverMetrics archiverMetrics, int brokerId) {
        return ArchiveTask$.MODULE$.apply(ctx, topicIdPartition, leaderEpoch, archiverMetrics, brokerId);
    }

    @Override
    public CancellationContext ctx() {
        return this.ctx;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public ArchiveTaskState state() {
        return this.state;
    }

    public void state_$eq(ArchiveTaskState x$1) {
        this.state = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    @Override
    public String loggerName() {
        return ArchiveTask.class.getName();
    }

    @Override
    public Future<ArchiveTask> transition(Time time, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, ReplicaManager replicaManager, TierTasksConfig config, Option<Throttler> throttler, ExecutionContext ec) {
        Object object;
        if (this.ctx().isCancelled()) {
            object = Future$.MODULE$.successful((Object)this.state());
        } else {
            ArchiveTaskState archiveTaskState = this.state();
            if (archiveTaskState instanceof BeforeLeader) {
                BeforeLeader beforeLeader = (BeforeLeader)archiveTaskState;
                object = ArchiveTask$.MODULE$.establishLeadership(beforeLeader, this.topicIdPartition(), tierTopicAppender, this.brokerId(), replicaManager, ec);
            } else if (archiveTaskState instanceof BeforeUpload) {
                BeforeUpload beforeUpload = (BeforeUpload)archiveTaskState;
                object = ArchiveTask$.MODULE$.maybeInitiateUpload(beforeUpload, this.topicIdPartition(), time, tierTopicAppender, tierObjectStore, replicaManager, ec);
            } else if (archiveTaskState instanceof Upload) {
                Upload upload = (Upload)archiveTaskState;
                object = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), time, this.ctx(), tierObjectStore, throttler, ec);
            } else if (archiveTaskState instanceof AfterUpload) {
                AfterUpload afterUpload = (AfterUpload)archiveTaskState;
                object = ArchiveTask$.MODULE$.finalizeUpload(afterUpload, this.topicIdPartition(), time, tierTopicAppender, this.kafka$tier$tasks$archive$ArchiveTask$$archiverMetrics.byteRateOpt(), ec);
            } else if (archiveTaskState instanceof FailedState) {
                FailedState failedState = (FailedState)archiveTaskState;
                object = ArchiveTask$.MODULE$.checkFailedState(failedState, this.topicIdPartition(), replicaManager);
            } else {
                throw new MatchError((Object)archiveTaskState);
            }
        }
        return object.map((Function1 & Serializable)result -> {
            this.onSuccessfulTransition();
            this.state_$eq((ArchiveTaskState)result);
            return this;
        }, ec).recover((PartialFunction)new Serializable(this, config, time){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchiveTask $outer;
            private final TierTasksConfig config$1;
            private final Time time$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof TierMetadataRetriableException) {
                    TierMetadataRetriableException tierMetadataRetriableException = (TierMetadataRetriableException)((Object)x1);
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), (Throwable)((Object)tierMetadataRetriableException));
                    return (B1)this.$outer;
                }
                if (x1 instanceof TierObjectStoreRetriableException) {
                    TierObjectStoreRetriableException tierObjectStoreRetriableException = (TierObjectStoreRetriableException)((Object)x1);
                    this.$outer.kafka$tier$tasks$archive$ArchiveTask$$archiverMetrics.exceptionsRateOpt().foreach((Function1 & Serializable)x$1 -> {
                        $anonfun$transition$2.$anonfun$applyOrElse$1(x$1);
                        return BoxedUnit.UNIT;
                    });
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), (Throwable)((Object)tierObjectStoreRetriableException));
                    return (B1)this.$outer;
                }
                if (x1 instanceof TierArchiverFailedException) {
                    TierArchiverFailedException tierArchiverFailedException = (TierArchiverFailedException)x1;
                    ArchiveTask archiveTask = this.$outer;
                    if (archiveTask == null) {
                        throw null;
                    }
                    ArchiveTask warn_this = archiveTask;
                    if (warn_this.logger().underlying().isWarnEnabled()) {
                        warn_this.logger().underlying().warn(warn_this.msgWithLogIdent($anonfun$transition$2.$anonfun$applyOrElse$2(this)), (Throwable)tierArchiverFailedException);
                    }
                    Object var10_6 = null;
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), tierArchiverFailedException);
                    this.$outer.state_$eq(new FailedState(this.$outer.state().leaderEpoch()));
                    return (B1)this.$outer;
                }
                if (x1 instanceof TierArchiverRestoreFencedException) {
                    ArchiveTask archiveTask = this.$outer;
                    if (archiveTask == null) {
                        throw null;
                    }
                    ArchiveTask debug_this = archiveTask;
                    if (debug_this.logger().underlying().isDebugEnabled()) {
                        debug_this.logger().underlying().debug(debug_this.msgWithLogIdent($anonfun$transition$2.$anonfun$applyOrElse$4(this)));
                    }
                    Object var11_7 = null;
                    this.$outer.state_$eq(new FailedState(this.$outer.state().leaderEpoch()));
                    return (B1)this.$outer;
                }
                if (x1 instanceof TierArchiverFencedException) {
                    TierArchiverFencedException tierArchiverFencedException = (TierArchiverFencedException)x1;
                    ArchiveTask archiveTask = this.$outer;
                    if (archiveTask == null) {
                        throw null;
                    }
                    ArchiveTask info_this = archiveTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$2.$anonfun$applyOrElse$5(this)), (Throwable)tierArchiverFencedException);
                    }
                    Object var12_9 = null;
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (x1 instanceof NotTierablePartitionException) {
                    NotTierablePartitionException notTierablePartitionException = (NotTierablePartitionException)x1;
                    ArchiveTask archiveTask = this.$outer;
                    if (archiveTask == null) {
                        throw null;
                    }
                    ArchiveTask info_this = archiveTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$2.$anonfun$applyOrElse$7(this)), (Throwable)notTierablePartitionException);
                    }
                    Object var13_11 = null;
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (x1 instanceof SegmentDeletedException) {
                    SegmentDeletedException segmentDeletedException = (SegmentDeletedException)((Object)x1);
                    this.$outer.state_$eq(this.$outer.state().handleSegmentDeletedException(segmentDeletedException));
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), (Throwable)((Object)segmentDeletedException));
                    return (B1)this.$outer;
                }
                if (x1 instanceof E2EChecksumInvalidException) {
                    E2EChecksumInvalidException e2EChecksumInvalidException = (E2EChecksumInvalidException)x1;
                    this.$outer.kafka$tier$tasks$archive$ArchiveTask$$archiverMetrics.e2eChecksumInvalidCount().foreach((Function1 & Serializable)x$2 -> {
                        $anonfun$transition$2.$anonfun$applyOrElse$9(x$2);
                        return BoxedUnit.UNIT;
                    });
                    ArchiveTask archiveTask = this.$outer;
                    if (archiveTask == null) {
                        throw null;
                    }
                    ArchiveTask error_this = archiveTask;
                    if (error_this.logger().underlying().isErrorEnabled()) {
                        error_this.logger().underlying().error(error_this.msgWithLogIdent($anonfun$transition$2.$anonfun$applyOrElse$10(this)), (Throwable)e2EChecksumInvalidException);
                    }
                    Object var14_14 = null;
                    this.$outer.cancelAndSetErrorState(e2EChecksumInvalidException);
                    return (B1)this.$outer;
                }
                if (x1 != null) {
                    ArchiveTask archiveTask = this.$outer;
                    if (archiveTask == null) {
                        throw null;
                    }
                    ArchiveTask error_this = archiveTask;
                    if (error_this.logger().underlying().isErrorEnabled()) {
                        error_this.logger().underlying().error(error_this.msgWithLogIdent($anonfun$transition$2.$anonfun$applyOrElse$12(this)), x1);
                    }
                    Object var15_15 = null;
                    this.$outer.cancelAndSetErrorState(x1);
                    return (B1)this.$outer;
                }
                return (B1)function1.apply(null);
            }

            public final boolean isDefinedAt(Throwable x1) {
                if (x1 instanceof TierMetadataRetriableException) {
                    return true;
                }
                if (x1 instanceof TierObjectStoreRetriableException) {
                    return true;
                }
                if (x1 instanceof TierArchiverFailedException) {
                    return true;
                }
                if (x1 instanceof TierArchiverRestoreFencedException) {
                    return true;
                }
                if (x1 instanceof TierArchiverFencedException) {
                    return true;
                }
                if (x1 instanceof NotTierablePartitionException) {
                    return true;
                }
                if (x1 instanceof SegmentDeletedException) {
                    return true;
                }
                if (x1 instanceof E2EChecksumInvalidException) {
                    return true;
                }
                return x1 != null;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1(Meter x$1) {
                x$1.mark();
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$2($anonfun$transition$2 $this) {
                return new StringBuilder(61).append($this.$outer.topicIdPartition()).append(" failed, pausing archival process and marking ").append($this.$outer.topicIdPartition()).append(" to be in error").toString();
            }

            public static final /* synthetic */ TierArchiverFailedException $anonfun$applyOrElse$3(TierArchiverFailedException x4$1) {
                return x4$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$4($anonfun$transition$2 $this) {
                return new StringBuilder(54).append($this.$outer.topicIdPartition()).append(" encountered metadata fencing due to state restoration").toString();
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$5($anonfun$transition$2 $this) {
                return new StringBuilder(38).append($this.$outer.topicIdPartition()).append(" was fenced, stopping archival process").toString();
            }

            public static final /* synthetic */ TierArchiverFencedException $anonfun$applyOrElse$6(TierArchiverFencedException x6$1) {
                return x6$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$7($anonfun$transition$2 $this) {
                return new StringBuilder(39).append($this.$outer.topicIdPartition()).append(" is not tierable and cannot be archived").toString();
            }

            public static final /* synthetic */ NotTierablePartitionException $anonfun$applyOrElse$8(NotTierablePartitionException x7$1) {
                return x7$1;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$9(Counter x$2) {
                x$2.inc();
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$10($anonfun$transition$2 $this) {
                return new StringBuilder(91).append($this.$outer.topicIdPartition()).append(" failed due to E2E Checksum mismatch, stopping archival process and marking ").append($this.$outer.topicIdPartition()).append(" to be in error").toString();
            }

            public static final /* synthetic */ E2EChecksumInvalidException $anonfun$applyOrElse$11(E2EChecksumInvalidException x9$1) {
                return x9$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$12($anonfun$transition$2 $this) {
                return new StringBuilder(89).append($this.$outer.topicIdPartition()).append(" failed due to unhandled exception, stopping archival process and marking ").append($this.$outer.topicIdPartition()).append(" to be in error").toString();
            }

            public static final /* synthetic */ Throwable $anonfun$applyOrElse$13(Throwable x10$1) {
                return x10$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.config$1 = config$1;
                this.time$1 = time$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(com.yammer.metrics.core.Meter ), $anonfun$applyOrElse$9$adapted(com.yammer.metrics.core.Counter )}, serializedLambda);
            }
        }, ec);
    }

    public String toString() {
        return new StringBuilder(41).append("ArchiveTask(").append(this.topicIdPartition()).append(", state=").append(this.state().getClass().getName()).append(", epoch=").append(this.state().leaderEpoch()).append(", cancelled=").append(this.ctx().isCancelled()).append(")").toString();
    }

    public ArchiveTask(CancellationContext ctx, TopicIdPartition topicIdPartition, ArchiveTaskState state, ArchiverMetrics archiverMetrics, int brokerId) {
        this.ctx = ctx;
        this.topicIdPartition = topicIdPartition;
        this.state = state;
        this.kafka$tier$tasks$archive$ArchiveTask$$archiverMetrics = archiverMetrics;
        this.brokerId = brokerId;
        super(archiverMetrics.retryRateOpt());
    }

    public static class SegmentDeletedException
    extends RetriableException
    implements Product {
        private final String msg;
        private final Throwable cause;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String msg() {
            return this.msg;
        }

        public Throwable cause() {
            return this.cause;
        }

        public SegmentDeletedException copy(String msg, Throwable cause) {
            return new SegmentDeletedException(msg, cause);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public Throwable copy$default$2() {
            return this.cause();
        }

        public String productPrefix() {
            return "SegmentDeletedException";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.msg();
                }
                case 1: {
                    return this.cause();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SegmentDeletedException;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "msg";
                }
                case 1: {
                    return "cause";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof SegmentDeletedException)) break block3;
                    SegmentDeletedException segmentDeletedException = (SegmentDeletedException)((Object)x$1);
                    String string = this.msg();
                    String string2 = segmentDeletedException.msg();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    Throwable throwable = this.cause();
                    Throwable throwable2 = segmentDeletedException.cause();
                    if ((throwable != null ? !throwable.equals(throwable2) : throwable2 != null) || !segmentDeletedException.canEqual((Object)this)) break block3;
                }
                return true;
            }
            return false;
        }

        public SegmentDeletedException(String msg, Throwable cause) {
            this.msg = msg;
            this.cause = cause;
            super(msg, cause);
            Product.$init$((Product)this);
        }
    }
}

