/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.PrintStream;
import java.time.Instant;
import java.util.Optional;
import kafka.tier.domain.AbstractTierMetadata;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MessageFormatter;

public class TierMessageFormatter
implements MessageFormatter {
    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        try {
            Optional<AbstractTierMetadata> entry = AbstractTierMetadata.deserialize((byte[])consumerRecord.key(), (byte[])consumerRecord.value(), consumerRecord.timestamp());
            if (entry.isPresent()) {
                output.printf("(%d, %d, %d, %s): %s\n", consumerRecord.partition(), consumerRecord.leaderEpoch().orElse(-1), consumerRecord.offset(), Instant.ofEpochMilli(consumerRecord.timestamp()), entry.get());
            } else {
                output.printf("(%d, %d, %d, %s): unknown tier metadata type %d\n", consumerRecord.partition(), consumerRecord.leaderEpoch().orElse(-1), consumerRecord.offset(), Instant.ofEpochMilli(consumerRecord.timestamp()), AbstractTierMetadata.getTypeId((byte[])consumerRecord.value()));
            }
        }
        catch (Exception ex) {
            output.printf("(%d, %d, %d, %s): failed to deserialize tier metadata. Error message: %s. Record: %s\n", consumerRecord.partition(), consumerRecord.leaderEpoch().orElse(-1), consumerRecord.offset(), Instant.ofEpochMilli(consumerRecord.timestamp()), ex.getMessage(), consumerRecord.toString());
        }
    }

    public void close() {
    }
}

