/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kafka.server.KafkaConfig;
import scala.collection.JavaConverters;

public class TierTopicManagerConfig {
    public static final long MATERIALIZATION_DELTA_MS = 86400000L;
    public final Supplier<Map<String, Object>> interBrokerClientConfigs;
    public final String tierNamespace;
    public final short configuredNumPartitions;
    public final short configuredReplicationFactor;
    public final int brokerId;
    public final String clusterId;
    public final Duration pollDuration;
    public final Integer requestTimeoutMs;
    public final Integer commitIntervalMs;
    public final Long materializationTimeRangeMs;
    public final List<String> logDirs;
    public final Boolean enableProducerIdempotence;
    public final Boolean enableTierTopicDataLossDetection;
    public final Boolean enableTierTopicFencingDuringDataLoss;
    public final Boolean enableSnapshotBasedMaterialization;

    public TierTopicManagerConfig(Supplier<Map<String, Object>> interBrokerClientConfigs, String tierNamespace, short configuredNumPartitions, short configuredReplicationFactor, int brokerId, String clusterId, Long pollDurationMs, Integer requestTimeoutMs, Integer commitIntervalMs, Long materializationTimeRangeMs, List<String> logDirs, Boolean enableProducerIdempotence, Boolean enableTierTopicDataLossDetection, Boolean enableTierTopicFencingDuringDataLoss, Boolean enableSnapshotBasedMaterialization) {
        this.interBrokerClientConfigs = interBrokerClientConfigs;
        this.tierNamespace = tierNamespace;
        this.configuredNumPartitions = configuredNumPartitions;
        this.configuredReplicationFactor = configuredReplicationFactor;
        this.brokerId = brokerId;
        this.clusterId = clusterId;
        this.pollDuration = Duration.ofMillis(pollDurationMs);
        this.requestTimeoutMs = requestTimeoutMs;
        this.commitIntervalMs = commitIntervalMs;
        this.materializationTimeRangeMs = materializationTimeRangeMs;
        this.logDirs = logDirs;
        this.enableProducerIdempotence = enableProducerIdempotence;
        this.enableTierTopicDataLossDetection = enableTierTopicDataLossDetection;
        this.enableTierTopicFencingDuringDataLoss = enableTierTopicFencingDuringDataLoss;
        this.enableSnapshotBasedMaterialization = enableSnapshotBasedMaterialization;
    }

    public TierTopicManagerConfig(KafkaConfig config, Supplier<Map<String, Object>> interBrokerClientConfigs, String clusterId) {
        this(interBrokerClientConfigs, config.confluentConfig().tierMetadataNamespace(), config.confluentConfig().tierMetadataNumPartitions(), config.confluentConfig().tierMetadataReplicationFactor(), config.brokerId(), clusterId, config.confluentConfig().tierMetadataMaxPollMs(), config.confluentConfig().tierMetadataRequestTimeoutMs(), config.confluentConfig().tierPartitionStateCommitIntervalMs(), TimeUnit.DAYS.toMillis(config.confluentConfig().tierPartitionStateMetadataSnapshotsRetentionDays().intValue()) - 86400000L, JavaConverters.seqAsJavaList(config.logDirs()), config.confluentConfig().tierTopicProducerEnableIdempotence(), config.confluentConfig().tierTopicDataLossDetectionEnable(), config.confluentConfig().tierTopicFencingDuringDataLossEnable(), config.confluentConfig().tierTopicMaterializationFromSnapshotEnable() != false && config.confluentConfig().tierPartitionStateMetadataSnapshotsEnable() != false);
    }

    public static TierTopicManagerConfig reconfigureTierTopicManagerConfig(TierTopicManagerConfig oldConfig, KafkaConfig newConfig) {
        return new TierTopicManagerConfig(oldConfig.interBrokerClientConfigs, oldConfig.tierNamespace, oldConfig.configuredNumPartitions, oldConfig.configuredReplicationFactor, oldConfig.brokerId, oldConfig.clusterId, oldConfig.pollDuration.toMillis(), oldConfig.requestTimeoutMs, oldConfig.commitIntervalMs, TimeUnit.DAYS.toMillis(newConfig.confluentConfig().tierPartitionStateMetadataSnapshotsRetentionDays().intValue()) - 86400000L, oldConfig.logDirs, oldConfig.enableProducerIdempotence, oldConfig.enableTierTopicDataLossDetection, oldConfig.enableTierTopicFencingDuringDataLoss, oldConfig.enableSnapshotBasedMaterialization);
    }
}

