/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.disposables;

import io.confluent.shaded.io.reactivex.disposables.Disposable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;

final class FutureDisposable
extends AtomicReference<Future<?>>
implements Disposable {
    private static final long serialVersionUID = 6545242830671168775L;
    private final boolean allowInterrupt;

    FutureDisposable(Future<?> run, boolean allowInterrupt) {
        super(run);
        this.allowInterrupt = allowInterrupt;
    }

    @Override
    public boolean isDisposed() {
        Future f = (Future)this.get();
        return f == null || f.isDone();
    }

    @Override
    public void dispose() {
        Future f = this.getAndSet(null);
        if (f != null) {
            f.cancel(this.allowInterrupt);
        }
    }
}

