/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.observable;

import io.confluent.shaded.io.reactivex.Observable;
import io.confluent.shaded.io.reactivex.ObservableSource;
import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.Single;
import io.confluent.shaded.io.reactivex.SingleObserver;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.functions.BiConsumer;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.disposables.EmptyDisposable;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.fuseable.FuseToObservable;
import io.confluent.shaded.io.reactivex.internal.operators.observable.ObservableCollect;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;

public final class ObservableCollectSingle<T, U>
extends Single<U>
implements FuseToObservable<U> {
    final ObservableSource<T> source;
    final Callable<? extends U> initialSupplier;
    final BiConsumer<? super U, ? super T> collector;

    public ObservableCollectSingle(ObservableSource<T> source, Callable<? extends U> initialSupplier, BiConsumer<? super U, ? super T> collector) {
        this.source = source;
        this.initialSupplier = initialSupplier;
        this.collector = collector;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super U> t) {
        U u;
        try {
            u = ObjectHelper.requireNonNull(this.initialSupplier.call(), "The initialSupplier returned a null value");
        }
        catch (Throwable e) {
            EmptyDisposable.error(e, t);
            return;
        }
        this.source.subscribe(new CollectObserver<T, U>(t, u, this.collector));
    }

    @Override
    public Observable<U> fuseToObservable() {
        return RxJavaPlugins.onAssembly(new ObservableCollect<T, U>(this.source, this.initialSupplier, this.collector));
    }

    static final class CollectObserver<T, U>
    implements Observer<T>,
    Disposable {
        final SingleObserver<? super U> downstream;
        final BiConsumer<? super U, ? super T> collector;
        final U u;
        Disposable upstream;
        boolean done;

        CollectObserver(SingleObserver<? super U> actual, U u, BiConsumer<? super U, ? super T> collector) {
            this.downstream = actual;
            this.collector = collector;
            this.u = u;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            try {
                this.collector.accept(this.u, t);
            }
            catch (Throwable e) {
                this.upstream.dispose();
                this.onError(e);
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onSuccess(this.u);
        }
    }
}

