/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty;

import io.confluent.common.security.auth.CertificatePrincipal;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateLoginService
extends AbstractLifeCycle
implements LoginService {
    private static final Logger log = LoggerFactory.getLogger(CertificateLoginService.class);
    private SslPrincipalMapper sslPrincipalMapper = null;
    private IdentityService identityService = null;

    public void setSslPrincipalMapper(SslPrincipalMapper sslPrincipalMapper) {
        this.sslPrincipalMapper = sslPrincipalMapper;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.identityService == null) {
            this.identityService = new DefaultIdentityService();
        }
    }

    public String getName() {
        return "X509";
    }

    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        try {
            log.debug("Processing certificate login request for: " + username);
            X509Certificate certificate = (X509Certificate)credentials;
            String mappedName = this.sslPrincipalMapper.getName(username);
            Subject subject = new Subject();
            CertificatePrincipal principal = new CertificatePrincipal(mappedName, certificate);
            subject.getPrincipals().add(principal);
            UserIdentity user = this.identityService.newUserIdentity(subject, (Principal)principal, new String[0]);
            log.debug("Logging in user " + user);
            return user;
        }
        catch (Exception e) {
            log.warn("Failed generating principal", (Throwable)e);
            return null;
        }
    }

    public boolean validate(UserIdentity user) {
        log.debug("Validating user " + user);
        return true;
    }

    public void logout(UserIdentity user) {
        log.debug("Logging out user " + user);
    }
}

