/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty;

import io.confluent.common.security.jetty.JwtLoginService;
import java.util.Objects;
import javax.servlet.ServletRequest;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiJwtLoginService
extends AbstractLifeCycle
implements LoginService {
    private static final Logger log = LoggerFactory.getLogger(MultiJwtLoginService.class);
    private final JwtLoginService confluentJwtLoginService;
    private final JwtLoginService idpJwtLoginService;
    private final String name;
    private final JwtConsumer jwtConsumer;
    private IdentityService identityService;

    public MultiJwtLoginService(JwtLoginService confluentJwtLoginService, JwtLoginService idpJwtLoginService) {
        if (!Objects.equals(confluentJwtLoginService.getName(), idpJwtLoginService.getName())) {
            throw new IllegalArgumentException("login service realm names must match");
        }
        this.confluentJwtLoginService = confluentJwtLoginService;
        this.idpJwtLoginService = idpJwtLoginService;
        this.name = confluentJwtLoginService.getName();
        this.jwtConsumer = new JwtConsumerBuilder().setSkipSignatureVerification().setDisableRequireSignature().setSkipAllValidators().build();
    }

    public String getName() {
        return this.name;
    }

    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        log.debug("Processing new Jwt login request to MultiJwtLoginService.");
        try {
            JwtClaims jwtClaims = this.jwtConsumer.processToClaims((String)credentials);
            String issuer = jwtClaims.getIssuer();
            log.debug("Issuer in request: {}, Confluent issuer: {}, IdP issuer: {}", new Object[]{issuer, this.confluentJwtLoginService.getIssuer(), this.idpJwtLoginService.getIssuer()});
            if (Objects.equals(this.confluentJwtLoginService.getIssuer(), issuer)) {
                return this.confluentJwtLoginService.login(username, credentials, request);
            }
            if (Objects.equals(this.idpJwtLoginService.getIssuer(), issuer)) {
                return this.idpJwtLoginService.login(username, credentials, request);
            }
            log.debug("Unknown issuer: {}", (Object)issuer);
            return null;
        }
        catch (Exception e) {
            log.debug("Exception", (Throwable)e);
            return null;
        }
    }

    public boolean validate(UserIdentity user) {
        return true;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
        this.confluentJwtLoginService.setIdentityService(identityService);
        this.idpJwtLoginService.setIdentityService(identityService);
    }

    public void logout(UserIdentity user) {
    }

    protected void doStart() throws Exception {
        this.confluentJwtLoginService.start();
        this.idpJwtLoginService.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.confluentJwtLoginService.stop();
        this.idpJwtLoginService.stop();
        super.doStop();
    }
}

