/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Log4JLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.apache.kafka.common.security.ssl.CloseableSslEngineFactory;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettySslEngineFactory
extends DefaultSslEngineFactory
implements SslEngineFactory,
CloseableSslEngineFactory {
    private static final Logger log = LoggerFactory.getLogger(NettySslEngineFactory.class);
    private AtomicReference<SslContext> nettySslClientContext = new AtomicReference<Object>(null);
    private AtomicReference<SslContext> nettySslServerContext = new AtomicReference<Object>(null);
    private boolean configured = false;

    @Override
    public SSLEngine createClientSslEngine(String peerHost, int peerPort, String endpointIdentification) {
        if (!this.configured) {
            throw new RuntimeException("Cannot create SSLEngine since this factory has not yet been configured");
        }
        if (this.nettySslClientContext.get() == null) {
            throw new RuntimeException("Cannot create SSLEngine since this factory could not be configured for client");
        }
        SSLEngine sslEngine = this.nettySslClientContext.get().newEngine(ByteBufAllocator.DEFAULT, peerHost, peerPort);
        SSLParameters sslParams = sslEngine.getSSLParameters();
        sslParams.setEndpointIdentificationAlgorithm(endpointIdentification);
        sslEngine.setSSLParameters(sslParams);
        return sslEngine;
    }

    @Override
    public SSLEngine createServerSslEngine(String peerHost, int peerPort) {
        if (!this.configured) {
            throw new RuntimeException("Cannot create SSLEngine since this factory has not yet been configured");
        }
        if (this.nettySslServerContext == null) {
            throw new RuntimeException("Cannot create SSLEngine since this factory could not be configured for server");
        }
        return this.nettySslServerContext.get().newEngine(ByteBufAllocator.DEFAULT, peerHost, peerPort);
    }

    static boolean configsContainKeystore(Map<String, ?> configs) {
        return configs.containsKey("ssl.keystore.type") && configs.containsKey("ssl.keystore.location") && configs.containsKey("ssl.keystore.password");
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        this.configured = true;
    }

    @Override
    protected void createAndSetSSLContext() {
        super.createAndSetSSLContext();
        if (!OpenSsl.isAvailable()) {
            this.nettySslClientContext = null;
            this.nettySslServerContext = null;
        } else {
            this.nettySslClientContext.set(this.createNettySslContext(Mode.CLIENT));
            if (NettySslEngineFactory.configsContainKeystore(this.configs())) {
                this.nettySslServerContext.set(this.createNettySslContext(Mode.SERVER));
            }
        }
    }

    static boolean isConfigurable(Map<String, ?> configs, Mode mode) {
        if (mode == Mode.SERVER && !NettySslEngineFactory.configsContainKeystore(configs)) {
            log.warn("Cannot configure Netty server because keystore is not configured.");
            return false;
        }
        if (!OpenSsl.isAvailable()) {
            log.warn("Cannot configure Netty because no OpenSSL is available.", OpenSsl.unavailabilityCause());
            return false;
        }
        return true;
    }

    @Override
    public Closeable sslEngineCloser(SSLEngine engine) {
        return new CloseableSslEngine(engine);
    }

    @Override
    public void close() {
        super.close();
        if (this.nettySslServerContext.get() != null && this.nettySslServerContext.get() instanceof ReferenceCountedOpenSslContext) {
            ((ReferenceCountedOpenSslContext)this.nettySslServerContext.get()).release();
        }
        if (this.nettySslClientContext.get() != null && this.nettySslClientContext.get() instanceof ReferenceCountedOpenSslContext) {
            ((ReferenceCountedOpenSslContext)this.nettySslClientContext.get()).release();
        }
    }

    DefaultSslEngineFactory.PrivateKeyData loadPrivateKeyData() {
        DefaultSslEngineFactory.SecurityStore keyStore = this.securityKeyStore();
        KeyStore store = keyStore.get();
        KeyStore.PasswordProtection keyProtection = keyStore.keyPassword() == null ? null : new KeyStore.PasswordProtection(keyStore.keyPassword());
        try {
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!store.isKeyEntry(alias)) continue;
                try {
                    KeyStore.Entry entry = store.getEntry(alias, keyProtection);
                    if (!(entry instanceof KeyStore.PrivateKeyEntry)) continue;
                    KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                    PrivateKey privateKey = privateKeyEntry.getPrivateKey();
                    Certificate[] certs = privateKeyEntry.getCertificateChain();
                    if (!(certs instanceof X509Certificate[])) {
                        throw new RuntimeException("Expected a certificate chain of type X509Certificate for alias " + alias);
                    }
                    return new DefaultSslEngineFactory.PrivateKeyData(privateKey, (X509Certificate[])certs);
                }
                catch (NoSuchAlgorithmException e) {
                    log.info("can't find the algorithm for recovering the {} entry.", (Object)alias);
                }
                catch (UnrecoverableEntryException e) {
                    log.trace("ignoring alias {}, since the password doesn't match.", (Object)alias);
                }
            }
        }
        catch (KeyStoreException e) {
            throw new KafkaException(e);
        }
        throw new RuntimeException("No private key found protected with the given password in " + keyStore.toString());
    }

    private SslContext createNettySslContext(Mode mode) {
        try {
            SslContextBuilder builder;
            DefaultSslEngineFactory.PrivateKeyData keystorePrivateKeyData = null;
            if (mode == Mode.SERVER && this.keystore() == null) {
                throw new KafkaException("When using Netty in server mode, a keystore must be configured.");
            }
            if (this.keystore() != null) {
                keystorePrivateKeyData = this.loadPrivateKeyData();
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.tmfAlgorithm());
            tmf.init(this.truststore());
            if (mode == Mode.SERVER) {
                builder = SslContextBuilder.forServer((PrivateKey)keystorePrivateKeyData.key(), (X509Certificate[])keystorePrivateKeyData.certificateChain());
            } else {
                builder = SslContextBuilder.forClient();
                if (keystorePrivateKeyData != null) {
                    builder.keyManager(keystorePrivateKeyData.key(), keystorePrivateKeyData.certificateChain());
                }
            }
            builder.applicationProtocolConfig(ApplicationProtocolConfig.DISABLED).sslProvider(SslProvider.OPENSSL_REFCNT).trustManager(tmf);
            if (this.enabledProtocols() != null) {
                builder.protocols(this.enabledProtocols());
            }
            if (this.cipherSuites() != null) {
                builder.ciphers(Arrays.asList(this.cipherSuites()));
            }
            if (mode == Mode.SERVER) {
                switch (this.sslClientAuth()) {
                    case NONE: {
                        builder.clientAuth(ClientAuth.NONE);
                        break;
                    }
                    case REQUIRED: {
                        builder.clientAuth(ClientAuth.REQUIRE);
                        break;
                    }
                    case REQUESTED: {
                        builder.clientAuth(ClientAuth.OPTIONAL);
                    }
                }
            }
            log.info("Netty is enabled in {} mode for SSL context with keystore {}, truststore {}.", new Object[]{mode, this.keystore(), this.truststore()});
            return builder.build();
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Netty SSL context could not be created with the provided configs", e);
        }
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Log4JLoggerFactory.INSTANCE);
        System.setProperty("io.netty.handler.ssl.openssl.useTasks", "false");
    }

    class CloseableSslEngine
    implements Closeable {
        private final SSLEngine engine;

        CloseableSslEngine(SSLEngine engine) {
            this.engine = engine;
        }

        @Override
        public void close() throws IOException {
            if (this.engine instanceof ReferenceCountedOpenSslEngine) {
                ((ReferenceCountedOpenSslEngine)this.engine).release();
            }
        }
    }
}

