/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.logging;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.common.logging.LogRecordBuilder;
import org.apache.kafka.connect.data.SchemaAndValue;

public final class LogRecordStringBuilder
implements LogRecordBuilder<String> {
    private static final ObjectMapper mapper = new ObjectMapper();
    private String level = null;
    private Long timeMs = null;
    private String loggerName = null;
    private String message = null;

    public LogRecordStringBuilder withLevel(String level) {
        this.level = level;
        return this;
    }

    public LogRecordStringBuilder withTimeMs(long timeMs) {
        this.timeMs = timeMs;
        return this;
    }

    public LogRecordStringBuilder withLoggerName(String loggerName) {
        this.loggerName = loggerName;
        return this;
    }

    public LogRecordStringBuilder withMessageSchemaAndValue(SchemaAndValue messageWithSchema) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public LogRecordBuilder<String> withMessageJson(String message) {
        this.message = message;
        return this;
    }

    @Override
    public String build() {
        try {
            return mapper.writeValueAsString((Object)new LogRecord(this.level, this.loggerName, this.timeMs, this.message));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static class LogRecord {
        @JsonProperty(value="level")
        String level;
        @JsonProperty(value="logger")
        String logger;
        @JsonProperty(value="time")
        Long timeMs;
        @JsonProperty(value="message")
        @JsonRawValue
        String message;

        public LogRecord(String level, String logger, Long timeMs, String message) {
            this.level = level;
            this.logger = logger;
            this.timeMs = timeMs;
            this.message = message;
        }
    }
}

