/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class MirrorTopicChangeRecord
implements ApiMessage {
    Uuid topicId;
    String topicName;
    Uuid clusterLinkId;
    String clusterLinkName;
    long timeMs;
    String mirrorTopicState;
    String previousToPausedState;
    List<Long> stoppedLogEndOffsets;
    boolean promoted;
    boolean topicLevelPause;
    boolean linkLevelPause;
    List<Long> mirrorStartOffsets;
    short mirrorTopicError;
    String nextState;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topic_id", (Type)Type.UUID, "The unique ID for this mirror topic."), new Field("topic_name", (Type)Type.COMPACT_STRING, "The name of this mirror topic. For debugging purposes only."), new Field("cluster_link_id", (Type)Type.UUID, "The unique ID of this cluster link."), new Field("cluster_link_name", (Type)Type.COMPACT_STRING, "The name of this cluster link. For debugging purposes only."), new Field("time_ms", (Type)Type.INT64, "The epoch time at which the state change occurred."), new Field("mirror_topic_state", (Type)Type.COMPACT_STRING, "The new state of the mirror topic. Valid States: PendingMirror, PendingSynchronize, Mirror, FailedMirror, PendingStoppedMirror, PausedMirror and StoppedMirror"), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("previous_to_paused_state", (Type)Type.COMPACT_NULLABLE_STRING, "The state this mirror topic will go into if unpaused. Null if mirror topic is not paused."), 1, new Field("stopped_log_end_offsets", (Type)CompactArrayOf.nullable((Type)Type.INT64), "List of log end offsets ordered by partition ids that the mirror topic was stopped at if mirror topic was state. Null if mirror topic is not stopped."), 2, new Field("promoted", (Type)Type.BOOLEAN, "Set to true if the mirror topic is promoted. This will be set to false when the mirror topic is failed over. This is only valid when the mirror topic state is PendingStopped."), 3, new Field("topic_level_pause", (Type)Type.BOOLEAN, "Set to true if the mirror topic is paused explicitly by user."), 4, new Field("link_level_pause", (Type)Type.BOOLEAN, "Set to true if the mirror topics are paused by pausing the cluster link."), 5, new Field("mirror_start_offsets", (Type)CompactArrayOf.nullable((Type)Type.INT64), "List of earliest offsets to start mirroring from, ordered by partition. By default, mirroring starts from the first available offset."), 6, new Field("mirror_topic_error", (Type)Type.INT16, "Reason for mirror topic failure, if this mirror is in failed state."), 7, new Field("next_state", (Type)Type.COMPACT_NULLABLE_STRING, "The state the remote mirror topic will go into after synchronization. Null if mirror topic is not in PendingSynchronize state.")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public MirrorTopicChangeRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public MirrorTopicChangeRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public MirrorTopicChangeRecord() {
        this.topicId = Uuid.ZERO_UUID;
        this.topicName = "";
        this.clusterLinkId = Uuid.ZERO_UUID;
        this.clusterLinkName = "";
        this.timeMs = 0L;
        this.mirrorTopicState = "";
        this.previousToPausedState = null;
        this.stoppedLogEndOffsets = null;
        this.promoted = false;
        this.topicLevelPause = false;
        this.linkLevelPause = false;
        this.mirrorStartOffsets = null;
        this.mirrorTopicError = (short)-1;
        this.nextState = null;
    }

    public short apiKey() {
        return 10002;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.topicId = _readable.readUuid();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field topicName was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field topicName had invalid length " + length);
        }
        this.topicName = _readable.readString(length);
        this.clusterLinkId = _readable.readUuid();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field clusterLinkName was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field clusterLinkName had invalid length " + length);
        }
        this.clusterLinkName = _context.read(EntityType.LINK_NAME, _readable.readString(length));
        this.timeMs = _readable.readLong();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field mirrorTopicState was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field mirrorTopicState had invalid length " + length);
        }
        this.mirrorTopicState = _readable.readString(length);
        this.previousToPausedState = null;
        this.stoppedLogEndOffsets = null;
        this.promoted = false;
        this.topicLevelPause = false;
        this.linkLevelPause = false;
        this.mirrorStartOffsets = null;
        this.mirrorTopicError = (short)-1;
        this.nextState = null;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block10: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 0: {
                    int length2 = _readable.readUnsignedVarint() - 1;
                    if (length2 < 0) {
                        this.previousToPausedState = null;
                        continue block10;
                    }
                    if (length2 > Short.MAX_VALUE) {
                        throw new RuntimeException("string field previousToPausedState had invalid length " + length2);
                    }
                    this.previousToPausedState = _readable.readString(length2);
                    continue block10;
                }
                case 1: {
                    int i;
                    int arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.stoppedLogEndOffsets = null;
                        continue block10;
                    }
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Long> newCollection = new ArrayList<Long>(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(_readable.readLong());
                    }
                    this.stoppedLogEndOffsets = newCollection;
                    continue block10;
                }
                case 2: {
                    this.promoted = _readable.readByte() != 0;
                    continue block10;
                }
                case 3: {
                    this.topicLevelPause = _readable.readByte() != 0;
                    continue block10;
                }
                case 4: {
                    this.linkLevelPause = _readable.readByte() != 0;
                    continue block10;
                }
                case 5: {
                    int i;
                    int arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.mirrorStartOffsets = null;
                        continue block10;
                    }
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Long> newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(_readable.readLong());
                    }
                    this.mirrorStartOffsets = newCollection;
                    continue block10;
                }
                case 6: {
                    this.mirrorTopicError = _readable.readShort();
                    continue block10;
                }
                case 7: {
                    int length2 = _readable.readUnsignedVarint() - 1;
                    if (length2 < 0) {
                        this.nextState = null;
                        continue block10;
                    }
                    if (length2 > Short.MAX_VALUE) {
                        throw new RuntimeException("string field nextState had invalid length " + length2);
                    }
                    this.nextState = _readable.readString(length2);
                    continue block10;
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeUuid(this.topicId);
        byte[] _stringBytes2 = _cache.getSerializedValue((Object)this.topicName);
        _writable.writeUnsignedVarint(_stringBytes2.length + 1);
        _writable.writeByteArray(_stringBytes2);
        _writable.writeUuid(this.clusterLinkId);
        _stringBytes2 = _cache.getSerializedValue((Object)this.clusterLinkName);
        _writable.writeUnsignedVarint(_stringBytes2.length + 1);
        _writable.writeByteArray(_stringBytes2);
        _writable.writeLong(this.timeMs);
        _stringBytes2 = _cache.getSerializedValue((Object)this.mirrorTopicState);
        _writable.writeUnsignedVarint(_stringBytes2.length + 1);
        _writable.writeByteArray(_stringBytes2);
        if (this.previousToPausedState != null) {
            ++_numTaggedFields;
        }
        if (this.stoppedLogEndOffsets != null) {
            ++_numTaggedFields;
        }
        if (this.promoted) {
            ++_numTaggedFields;
        }
        if (this.topicLevelPause) {
            ++_numTaggedFields;
        }
        if (this.linkLevelPause) {
            ++_numTaggedFields;
        }
        if (this.mirrorStartOffsets != null) {
            ++_numTaggedFields;
        }
        if (this.mirrorTopicError != -1) {
            ++_numTaggedFields;
        }
        if (this.nextState != null) {
            ++_numTaggedFields;
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        if (this.previousToPausedState != null) {
            _writable.writeUnsignedVarint(0);
            _stringBytes = _cache.getSerializedValue((Object)this.previousToPausedState);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint((int)(((byte[])_stringBytes).length + 1)));
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.stoppedLogEndOffsets != null) {
            _writable.writeUnsignedVarint(1);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.stoppedLogEndOffsets).intValue());
            _writable.writeUnsignedVarint(this.stoppedLogEndOffsets.size() + 1);
            _stringBytes = this.stoppedLogEndOffsets.iterator();
            while (_stringBytes.hasNext()) {
                Long stoppedLogEndOffsetsElement = (Long)_stringBytes.next();
                _writable.writeLong(stoppedLogEndOffsetsElement.longValue());
            }
        }
        if (this.promoted) {
            _writable.writeUnsignedVarint(2);
            _writable.writeUnsignedVarint(1);
            _writable.writeByte(this.promoted ? (byte)1 : 0);
        }
        if (this.topicLevelPause) {
            _writable.writeUnsignedVarint(3);
            _writable.writeUnsignedVarint(1);
            _writable.writeByte(this.topicLevelPause ? (byte)1 : 0);
        }
        if (this.linkLevelPause) {
            _writable.writeUnsignedVarint(4);
            _writable.writeUnsignedVarint(1);
            _writable.writeByte(this.linkLevelPause ? (byte)1 : 0);
        }
        if (this.mirrorStartOffsets != null) {
            _writable.writeUnsignedVarint(5);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.mirrorStartOffsets).intValue());
            _writable.writeUnsignedVarint(this.mirrorStartOffsets.size() + 1);
            _stringBytes = this.mirrorStartOffsets.iterator();
            while (_stringBytes.hasNext()) {
                Long mirrorStartOffsetsElement = (Long)_stringBytes.next();
                _writable.writeLong(mirrorStartOffsetsElement.longValue());
            }
        }
        if (this.mirrorTopicError != -1) {
            _writable.writeUnsignedVarint(6);
            _writable.writeUnsignedVarint(2);
            _writable.writeShort(this.mirrorTopicError);
        }
        if (this.nextState != null) {
            _writable.writeUnsignedVarint(7);
            _stringBytes = _cache.getSerializedValue((Object)this.nextState);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint((int)(((byte[])_stringBytes).length + 1)));
            _writable.writeUnsignedVarint(((Object)_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _arraySize;
        int _stringPrefixSize;
        int _numTaggedFields = 0;
        _size.addBytes(16);
        byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'topicName' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.topicName, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _size.addBytes(16);
        _stringBytes = _context.write(EntityType.LINK_NAME, this.clusterLinkName).getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'clusterLinkName' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.clusterLinkName, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _size.addBytes(8);
        _stringBytes = this.mirrorTopicState.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'mirrorTopicState' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.mirrorTopicState, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        if (this.previousToPausedState != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _stringBytes = this.previousToPausedState.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'previousToPausedState' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.previousToPausedState, _stringBytes);
            _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint((int)(_stringPrefixSize + _stringBytes.length)));
        }
        if (this.stoppedLogEndOffsets != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.stoppedLogEndOffsets.size() + 1)));
            _size.addBytes(this.stoppedLogEndOffsets.size() * 8);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.stoppedLogEndOffsets, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this.promoted) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        if (this.topicLevelPause) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        if (this.linkLevelPause) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        if (this.mirrorStartOffsets != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.mirrorStartOffsets.size() + 1)));
            _size.addBytes(this.mirrorStartOffsets.size() * 8);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.mirrorStartOffsets, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this.mirrorTopicError != -1) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(2);
        }
        if (this.nextState != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _stringBytes = this.nextState.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'nextState' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.nextState, _stringBytes);
            _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint((int)(_stringPrefixSize + _stringBytes.length)));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MirrorTopicChangeRecord)) {
            return false;
        }
        MirrorTopicChangeRecord other = (MirrorTopicChangeRecord)obj;
        if (!this.topicId.equals((Object)other.topicId)) {
            return false;
        }
        if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
            return false;
        }
        if (!this.clusterLinkId.equals((Object)other.clusterLinkId)) {
            return false;
        }
        if (this.clusterLinkName == null ? other.clusterLinkName != null : !this.clusterLinkName.equals(other.clusterLinkName)) {
            return false;
        }
        if (this.timeMs != other.timeMs) {
            return false;
        }
        if (this.mirrorTopicState == null ? other.mirrorTopicState != null : !this.mirrorTopicState.equals(other.mirrorTopicState)) {
            return false;
        }
        if (this.previousToPausedState == null ? other.previousToPausedState != null : !this.previousToPausedState.equals(other.previousToPausedState)) {
            return false;
        }
        if (this.stoppedLogEndOffsets == null ? other.stoppedLogEndOffsets != null : !this.stoppedLogEndOffsets.equals(other.stoppedLogEndOffsets)) {
            return false;
        }
        if (this.promoted != other.promoted) {
            return false;
        }
        if (this.topicLevelPause != other.topicLevelPause) {
            return false;
        }
        if (this.linkLevelPause != other.linkLevelPause) {
            return false;
        }
        if (this.mirrorStartOffsets == null ? other.mirrorStartOffsets != null : !this.mirrorStartOffsets.equals(other.mirrorStartOffsets)) {
            return false;
        }
        if (this.mirrorTopicError != other.mirrorTopicError) {
            return false;
        }
        if (this.nextState == null ? other.nextState != null : !this.nextState.equals(other.nextState)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.topicId.hashCode();
        hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
        hashCode = 31 * hashCode + this.clusterLinkId.hashCode();
        hashCode = 31 * hashCode + (this.clusterLinkName == null ? 0 : this.clusterLinkName.hashCode());
        hashCode = 31 * hashCode + ((int)(this.timeMs >> 32) ^ (int)this.timeMs);
        hashCode = 31 * hashCode + (this.mirrorTopicState == null ? 0 : this.mirrorTopicState.hashCode());
        hashCode = 31 * hashCode + (this.previousToPausedState == null ? 0 : this.previousToPausedState.hashCode());
        hashCode = 31 * hashCode + (this.stoppedLogEndOffsets == null ? 0 : this.stoppedLogEndOffsets.hashCode());
        hashCode = 31 * hashCode + (this.promoted ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.topicLevelPause ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.linkLevelPause ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.mirrorStartOffsets == null ? 0 : this.mirrorStartOffsets.hashCode());
        hashCode = 31 * hashCode + this.mirrorTopicError;
        hashCode = 31 * hashCode + (this.nextState == null ? 0 : this.nextState.hashCode());
        return hashCode;
    }

    public MirrorTopicChangeRecord duplicate() {
        MirrorTopicChangeRecord _duplicate = new MirrorTopicChangeRecord();
        _duplicate.topicId = this.topicId;
        _duplicate.topicName = this.topicName;
        _duplicate.clusterLinkId = this.clusterLinkId;
        _duplicate.clusterLinkName = this.clusterLinkName;
        _duplicate.timeMs = this.timeMs;
        _duplicate.mirrorTopicState = this.mirrorTopicState;
        _duplicate.previousToPausedState = this.previousToPausedState == null ? null : this.previousToPausedState;
        if (this.stoppedLogEndOffsets == null) {
            _duplicate.stoppedLogEndOffsets = null;
        } else {
            ArrayList<Long> newStoppedLogEndOffsets = new ArrayList<Long>(this.stoppedLogEndOffsets.size());
            for (Long _element : this.stoppedLogEndOffsets) {
                newStoppedLogEndOffsets.add(_element);
            }
            _duplicate.stoppedLogEndOffsets = newStoppedLogEndOffsets;
        }
        _duplicate.promoted = this.promoted;
        _duplicate.topicLevelPause = this.topicLevelPause;
        _duplicate.linkLevelPause = this.linkLevelPause;
        if (this.mirrorStartOffsets == null) {
            _duplicate.mirrorStartOffsets = null;
        } else {
            ArrayList<Long> newMirrorStartOffsets = new ArrayList<Long>(this.mirrorStartOffsets.size());
            for (Long _element : this.mirrorStartOffsets) {
                newMirrorStartOffsets.add(_element);
            }
            _duplicate.mirrorStartOffsets = newMirrorStartOffsets;
        }
        _duplicate.mirrorTopicError = this.mirrorTopicError;
        _duplicate.nextState = this.nextState == null ? null : this.nextState;
        return _duplicate;
    }

    public String toString() {
        return "MirrorTopicChangeRecord(topicId=" + this.topicId.toString() + ", topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", clusterLinkId=" + this.clusterLinkId.toString() + ", clusterLinkName=" + (this.clusterLinkName == null ? "null" : "'" + this.clusterLinkName.toString() + "'") + ", timeMs=" + this.timeMs + ", mirrorTopicState=" + (this.mirrorTopicState == null ? "null" : "'" + this.mirrorTopicState.toString() + "'") + ", previousToPausedState=" + (this.previousToPausedState == null ? "null" : "'" + this.previousToPausedState.toString() + "'") + ", stoppedLogEndOffsets=" + (this.stoppedLogEndOffsets == null ? "null" : MessageUtil.deepToString(this.stoppedLogEndOffsets.iterator())) + ", promoted=" + (this.promoted ? "true" : "false") + ", topicLevelPause=" + (this.topicLevelPause ? "true" : "false") + ", linkLevelPause=" + (this.linkLevelPause ? "true" : "false") + ", mirrorStartOffsets=" + (this.mirrorStartOffsets == null ? "null" : MessageUtil.deepToString(this.mirrorStartOffsets.iterator())) + ", mirrorTopicError=" + this.mirrorTopicError + ", nextState=" + (this.nextState == null ? "null" : "'" + this.nextState.toString() + "'") + ")";
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public String topicName() {
        return this.topicName;
    }

    public Uuid clusterLinkId() {
        return this.clusterLinkId;
    }

    public String clusterLinkName() {
        return this.clusterLinkName;
    }

    public long timeMs() {
        return this.timeMs;
    }

    public String mirrorTopicState() {
        return this.mirrorTopicState;
    }

    public String previousToPausedState() {
        return this.previousToPausedState;
    }

    public List<Long> stoppedLogEndOffsets() {
        return this.stoppedLogEndOffsets;
    }

    public boolean promoted() {
        return this.promoted;
    }

    public boolean topicLevelPause() {
        return this.topicLevelPause;
    }

    public boolean linkLevelPause() {
        return this.linkLevelPause;
    }

    public List<Long> mirrorStartOffsets() {
        return this.mirrorStartOffsets;
    }

    public short mirrorTopicError() {
        return this.mirrorTopicError;
    }

    public String nextState() {
        return this.nextState;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public MirrorTopicChangeRecord setTopicId(Uuid v) {
        this.topicId = v;
        return this;
    }

    public MirrorTopicChangeRecord setTopicName(String v) {
        this.topicName = v;
        return this;
    }

    public MirrorTopicChangeRecord setClusterLinkId(Uuid v) {
        this.clusterLinkId = v;
        return this;
    }

    public MirrorTopicChangeRecord setClusterLinkName(String v) {
        this.clusterLinkName = v;
        return this;
    }

    public MirrorTopicChangeRecord setTimeMs(long v) {
        this.timeMs = v;
        return this;
    }

    public MirrorTopicChangeRecord setMirrorTopicState(String v) {
        this.mirrorTopicState = v;
        return this;
    }

    public MirrorTopicChangeRecord setPreviousToPausedState(String v) {
        this.previousToPausedState = v;
        return this;
    }

    public MirrorTopicChangeRecord setStoppedLogEndOffsets(List<Long> v) {
        this.stoppedLogEndOffsets = v;
        return this;
    }

    public MirrorTopicChangeRecord setPromoted(boolean v) {
        this.promoted = v;
        return this;
    }

    public MirrorTopicChangeRecord setTopicLevelPause(boolean v) {
        this.topicLevelPause = v;
        return this;
    }

    public MirrorTopicChangeRecord setLinkLevelPause(boolean v) {
        this.linkLevelPause = v;
        return this;
    }

    public MirrorTopicChangeRecord setMirrorStartOffsets(List<Long> v) {
        this.mirrorStartOffsets = v;
        return this;
    }

    public MirrorTopicChangeRecord setMirrorTopicError(short v) {
        this.mirrorTopicError = v;
        return this;
    }

    public MirrorTopicChangeRecord setNextState(String v) {
        this.nextState = v;
        return this;
    }
}

