/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.metadata.BrokerRegistration;

class ControllerMetricsChanges {
    private int fencedBrokersChange = 0;
    private int activeBrokersChange = 0;
    private int migratingZkBrokersChange = 0;
    private int degradedBrokersChange = 0;

    ControllerMetricsChanges() {
    }

    static int delta(boolean prev, boolean next) {
        if (prev) {
            return next ? 0 : -1;
        }
        return next ? 1 : 0;
    }

    public int fencedBrokersChange() {
        return this.fencedBrokersChange;
    }

    public int activeBrokersChange() {
        return this.activeBrokersChange;
    }

    public int migratingZkBrokersChange() {
        return this.migratingZkBrokersChange;
    }

    public int degradedBrokersChange() {
        return this.degradedBrokersChange;
    }

    void handleBrokerChange(BrokerRegistration prev, BrokerRegistration next) {
        boolean wasFenced = false;
        boolean wasActive = false;
        boolean wasZk = false;
        boolean wasDegraded = false;
        if (prev != null) {
            wasFenced = prev.fenced();
            wasActive = !prev.fenced();
            wasZk = prev.isMigratingZkBroker();
            wasDegraded = !prev.degradedComponents().isEmpty();
        }
        boolean isFenced = false;
        boolean isActive = false;
        boolean isZk = false;
        boolean isDegraded = false;
        if (next != null) {
            isFenced = next.fenced();
            isActive = !next.fenced();
            isZk = next.isMigratingZkBroker();
            isDegraded = !next.degradedComponents().isEmpty();
        }
        this.fencedBrokersChange += ControllerMetricsChanges.delta(wasFenced, isFenced);
        this.activeBrokersChange += ControllerMetricsChanges.delta(wasActive, isActive);
        this.migratingZkBrokersChange += ControllerMetricsChanges.delta(wasZk, isZk);
        this.degradedBrokersChange += ControllerMetricsChanges.delta(wasDegraded, isDegraded);
    }

    void apply(ControllerMetadataMetrics metrics) {
        if (this.fencedBrokersChange != 0) {
            metrics.addToFencedBrokerCount(this.fencedBrokersChange);
        }
        if (this.activeBrokersChange != 0) {
            metrics.addToActiveBrokerCount(this.activeBrokersChange);
        }
        if (this.migratingZkBrokersChange != 0) {
            metrics.addToMigratingZkBrokerCount(this.migratingZkBrokersChange);
        }
        if (this.degradedBrokersChange != 0) {
            metrics.addToBrokersWithDegradedHealthCount(this.degradedBrokersChange);
        }
    }
}

