/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.image.node.ClusterLinksImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.ClusterLink;

public class ClusterLinksImage {
    public static final ClusterLinksImage EMPTY = new ClusterLinksImage(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    private final Map<Uuid, ClusterLink> linksById;
    private final Map<String, ClusterLink> linksByName;
    private final Map<String, Set<String>> linkNamesByTenant;

    public ClusterLinksImage(Map<Uuid, ClusterLink> linksById, Map<String, ClusterLink> linksByName, Map<String, Set<String>> linkNamesByTenant) {
        this.linksById = Collections.unmodifiableMap(linksById);
        this.linksByName = Collections.unmodifiableMap(linksByName);
        this.linkNamesByTenant = Collections.unmodifiableMap(linkNamesByTenant);
    }

    public boolean isEmpty() {
        return this.linksById.isEmpty() && this.linksByName.isEmpty();
    }

    public Map<Uuid, ClusterLink> linksById() {
        return this.linksById;
    }

    public Map<String, ClusterLink> linksByName() {
        return this.linksByName;
    }

    public Optional<ClusterLink> clusterLink(String linkName) {
        return Optional.ofNullable(this.linksByName.get(linkName));
    }

    public Optional<Uuid> clusterLinkId(String linkName) {
        return Optional.ofNullable(this.linksByName.get(linkName)).map(ClusterLink::linkId);
    }

    public Set<String> linksForTenant(String tenant) {
        return this.linkNamesByTenant.getOrDefault(tenant, Collections.emptySet());
    }

    public Map<String, Set<String>> linkNamesByTenant() {
        return this.linkNamesByTenant;
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        for (ClusterLink link : this.linksById.values()) {
            ClusterLinkRecord record = new ClusterLinkRecord().setClusterLinkName(link.linkName()).setClusterLinkId(link.linkId()).setTenantPrefix(link.tenantPrefix().orElse(null)).setRemoteClusterId(link.remoteClusterId());
            String mode = link.linkMode().toString();
            if (!mode.equals(record.linkMode())) {
                if (!options.metadataVersion().isClusterLinkModeSupported()) {
                    options.handleLoss("a cluster link with a non-DESTINATION mode");
                    continue;
                }
                record.setLinkMode(mode);
            }
            writer.write(options.metadataVersion().clusterLinkRecordVersion(), record);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClusterLinksImage)) {
            return false;
        }
        ClusterLinksImage other = (ClusterLinksImage)o;
        return this.linksById.equals(other.linksById) && this.linksByName.equals(other.linksByName) && this.linkNamesByTenant.equals(other.linkNamesByTenant);
    }

    public int hashCode() {
        return Objects.hash(this.linksById, this.linksByName, this.linkNamesByTenant);
    }

    public String toString() {
        return new ClusterLinksImageNode(this).stringify();
    }
}

