/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.util.JsonFormat;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.protobuf.events.auditlog.v2.Result;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import io.confluent.security.audit.AuditLogUtils;
import io.confluent.security.audit.kafka.AuditExtractorOptions;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.message.DeleteAclsRequestData;
import org.apache.kafka.common.message.DeleteAclsRequestDataJsonConverter;
import org.apache.kafka.common.message.DeleteAclsResponseData;
import org.apache.kafka.common.message.DeleteAclsResponseDataJsonConverter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.server.audit.KafkaRequestEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAclsRequestAuditExtractor {
    private static final Logger log = LoggerFactory.getLogger(DeleteAclsRequestAuditExtractor.class);

    public static List<AuditLog> extract(KafkaRequestEvent requestEvent, AuditExtractorOptions extractorOptions) throws Exception {
        ArrayList<AuditLog> extractedAuditLogs = new ArrayList<AuditLog>();
        DeleteAclsRequestData deleteAclsRequestData = DeleteAclsRequestDataJsonConverter.read((JsonNode)requestEvent.requestPayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        DeleteAclsResponseData deleteAclsResponseData = DeleteAclsResponseDataJsonConverter.read((JsonNode)requestEvent.responsePayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        boolean hasAuthorizationFailure = DeleteAclsRequestAuditExtractor.hasAuthorizationFailure(deleteAclsResponseData);
        Struct requestData = DeleteAclsRequestAuditExtractor.requestData(deleteAclsRequestData, requestEvent);
        Result.Status status = DeleteAclsRequestAuditExtractor.status(deleteAclsResponseData);
        Struct resultData = DeleteAclsRequestAuditExtractor.resultData(deleteAclsResponseData, requestEvent);
        List<TypedCloudResourceRef> typedCloudResourceRefList = AuditLogUtils.typedCloudResourceRefList(requestEvent);
        String resourceCrn = AuditLogUtils.requestCrn(extractorOptions.crnAuthority(), requestEvent);
        AuditLog auditLog = AuditLogUtils.auditLog(requestEvent, extractorOptions, hasAuthorizationFailure, false, requestData, status, resultData, typedCloudResourceRefList, resourceCrn);
        extractedAuditLogs.add(auditLog);
        return extractedAuditLogs;
    }

    private static boolean hasAuthorizationFailure(DeleteAclsResponseData deleteAclsResponseData) {
        return deleteAclsResponseData.filterResults().stream().anyMatch(deleteAclsFilterResult -> AuditLogUtils.hasAuthorizationFailure(deleteAclsFilterResult.errorCode()));
    }

    private static Struct requestData(DeleteAclsRequestData deleteAclsRequestData, KafkaRequestEvent requestEvent) throws Exception {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = (ObjectNode)DeleteAclsRequestDataJsonConverter.write((DeleteAclsRequestData)deleteAclsRequestData, (short)((short)requestEvent.requestContext().requestVersion()), (boolean)true);
        jsonNode.remove("aclState");
        for (JsonNode filter : jsonNode.get("filters")) {
            ((ObjectNode)filter).set("resourceTypeFilter", (JsonNode)new TextNode(ResourceType.fromCode((byte)((byte)filter.get("resourceTypeFilter").shortValue())).name()));
            ((ObjectNode)filter).set("patternTypeFilter", (JsonNode)new TextNode(PatternType.fromCode((byte)((byte)filter.get("patternTypeFilter").shortValue())).name()));
            ((ObjectNode)filter).set("operation", (JsonNode)new TextNode(AclOperation.fromCode((byte)((byte)filter.get("operation").shortValue())).name()));
            ((ObjectNode)filter).set("permissionType", (JsonNode)new TextNode(AclPermissionType.fromCode((byte)((byte)filter.get("permissionType").shortValue())).name()));
        }
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }

    private static Result.Status status(DeleteAclsResponseData deleteAclsResponseData) {
        if (deleteAclsResponseData.filterResults().stream().anyMatch(filterResult -> filterResult.errorCode() != Errors.NONE.code())) {
            return Result.Status.FAILURE;
        }
        return Result.Status.SUCCESS;
    }

    private static Struct resultData(DeleteAclsResponseData deleteAclsResponseData, KafkaRequestEvent requestEvent) throws InvalidProtocolBufferException {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = (ObjectNode)DeleteAclsResponseDataJsonConverter.write((DeleteAclsResponseData)deleteAclsResponseData, (short)((short)requestEvent.requestContext().requestVersion()), (boolean)true);
        jsonNode.remove("throttleTimeMs");
        for (JsonNode filterResults : jsonNode.get("filterResults")) {
            for (JsonNode matchingAcl : filterResults.get("matchingAcls")) {
                ((ObjectNode)matchingAcl).set("resourceType", (JsonNode)new TextNode(ResourceType.fromCode((byte)((byte)matchingAcl.get("resourceType").shortValue())).name()));
                ((ObjectNode)matchingAcl).set("patternType", (JsonNode)new TextNode(PatternType.fromCode((byte)((byte)matchingAcl.get("patternType").shortValue())).name()));
                ((ObjectNode)matchingAcl).set("operation", (JsonNode)new TextNode(AclOperation.fromCode((byte)((byte)matchingAcl.get("operation").shortValue())).name()));
                ((ObjectNode)matchingAcl).set("permissionType", (JsonNode)new TextNode(AclPermissionType.fromCode((byte)((byte)matchingAcl.get("permissionType").shortValue())).name()));
            }
        }
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }
}

