/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.util.JsonFormat;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.protobuf.events.auditlog.v2.Result;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import io.confluent.security.audit.AuditLogUtils;
import io.confluent.security.audit.kafka.AuditExtractorOptions;
import io.confluent.security.authorizer.ResourcePattern;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.message.DeleteClusterLinksRequestData;
import org.apache.kafka.common.message.DeleteClusterLinksRequestDataJsonConverter;
import org.apache.kafka.common.message.DeleteClusterLinksResponseData;
import org.apache.kafka.common.message.DeleteClusterLinksResponseDataJsonConverter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.server.audit.KafkaRequestEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteClusterLinksRequestAuditExtractor {
    private static final Logger log = LoggerFactory.getLogger(DeleteClusterLinksRequestAuditExtractor.class);

    public static List<AuditLog> extract(KafkaRequestEvent requestEvent, AuditExtractorOptions extractorOptions) throws Exception {
        ArrayList<AuditLog> extractedAuditLogs = new ArrayList<AuditLog>();
        DeleteClusterLinksRequestData deleteClusterLinksRequestData = DeleteClusterLinksRequestDataJsonConverter.read((JsonNode)requestEvent.requestPayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        DeleteClusterLinksResponseData deleteClusterLinksResponseData = DeleteClusterLinksResponseDataJsonConverter.read((JsonNode)requestEvent.responsePayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        boolean validateOnly = deleteClusterLinksRequestData.validateOnly();
        boolean force = deleteClusterLinksRequestData.force();
        for (String linkName : deleteClusterLinksRequestData.linkNames()) {
            DeleteClusterLinksResponseData.EntryData entryData = DeleteClusterLinksRequestAuditExtractor.responseEntryData(deleteClusterLinksResponseData, linkName);
            boolean hasAuthorizationFailure = AuditLogUtils.hasAuthorizationFailure(entryData.errorCode());
            Struct requestData = DeleteClusterLinksRequestAuditExtractor.requestData(linkName, validateOnly, force);
            Result.Status status = DeleteClusterLinksRequestAuditExtractor.status(entryData);
            Struct resultData = DeleteClusterLinksRequestAuditExtractor.resultData(entryData);
            List<TypedCloudResourceRef> typedCloudResourceRefList = DeleteClusterLinksRequestAuditExtractor.typedCloudResourceRefList(requestEvent, linkName);
            ResourcePattern resourcePattern = new ResourcePattern("link", linkName, PatternType.LITERAL);
            String resourceCrn = AuditLogUtils.requestResourceCrn(extractorOptions.crnAuthority(), requestEvent, resourcePattern);
            AuditLog auditLog = AuditLogUtils.auditLog(requestEvent, extractorOptions, hasAuthorizationFailure, validateOnly, requestData, status, resultData, typedCloudResourceRefList, resourceCrn);
            extractedAuditLogs.add(auditLog);
        }
        return extractedAuditLogs;
    }

    private static DeleteClusterLinksResponseData.EntryData responseEntryData(DeleteClusterLinksResponseData deleteClusterLinksResponseData, String linkName) {
        for (DeleteClusterLinksResponseData.EntryData entryData : deleteClusterLinksResponseData.entries()) {
            if (!entryData.linkName().equals(linkName)) continue;
            return entryData;
        }
        throw new IllegalStateException("Missing responseEntryData linkName " + linkName);
    }

    private static List<TypedCloudResourceRef> typedCloudResourceRefList(KafkaRequestEvent requestEvent, String topicName) {
        List<TypedCloudResourceRef> typedCloudResourceRefList = AuditLogUtils.typedCloudResourceRefList(requestEvent);
        typedCloudResourceRefList.add(TypedCloudResourceRef.newBuilder().setType(TypedCloudResourceRef.ResourceType.CLUSTER_LINK).setResourceId(topicName).build());
        return typedCloudResourceRefList;
    }

    private static Struct requestData(String linkName, boolean validateOnly, boolean force) throws Exception {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = new ObjectNode(JsonNodeFactory.instance);
        jsonNode.set("linkName", (JsonNode)new TextNode(linkName));
        jsonNode.set("validateOnly", (JsonNode)BooleanNode.valueOf((boolean)validateOnly));
        jsonNode.set("force", (JsonNode)BooleanNode.valueOf((boolean)force));
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }

    private static Result.Status status(DeleteClusterLinksResponseData.EntryData entryData) {
        if (entryData.errorCode() == Errors.NONE.code()) {
            return Result.Status.SUCCESS;
        }
        return Result.Status.FAILURE;
    }

    private static Struct resultData(DeleteClusterLinksResponseData.EntryData entryData) throws InvalidProtocolBufferException {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = new ObjectNode(JsonNodeFactory.instance);
        jsonNode.set("message", (JsonNode)new TextNode(entryData.errorMessage()));
        jsonNode.set("errorCode", (JsonNode)new ShortNode(entryData.errorCode()));
        jsonNode.set("errorType", (JsonNode)new TextNode(Errors.forCode((short)entryData.errorCode()).name()));
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }
}

