/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.telemetry.exporter;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TopicSpec {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="partitions")
    private int partitions;
    @JsonProperty(value="replicationFactor")
    private int replicationFactor;
    @JsonProperty(value="config")
    private Map<String, String> config = new HashMap<String, String>();

    public TopicSpec() {
    }

    public TopicSpec(String name, int partitions, int replicationFactor, Map<String, String> config) {
        this.name = name;
        this.partitions = partitions;
        this.replicationFactor = replicationFactor;
        this.config = config;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int partitions() {
        return this.partitions;
    }

    public void setPartitions(int partitions) {
        this.partitions = partitions;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public Map<String, String> config() {
        return this.config;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicSpec topicSpec = (TopicSpec)o;
        return this.partitions == topicSpec.partitions && this.replicationFactor == topicSpec.replicationFactor && Objects.equals(this.name, topicSpec.name) && Objects.equals(this.config, topicSpec.config);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.partitions, this.replicationFactor, this.config);
    }

    public String toString() {
        return "TopicSpec={name='" + this.name() + '\'' + ", partitions='" + this.partitions() + '\'' + ", replicationFactor=" + this.replicationFactor() + ", config=" + this.config() + '}';
    }

    public static final class Builder {
        public String name;
        public int partitions = 0;
        public int replicationFactor = 0;
        public Map<String, String> config = new HashMap<String, String>();

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setPartitions(int partitions) {
            this.partitions = partitions;
            return this;
        }

        public Builder setReplicationFactor(int replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this;
        }

        public Builder setConfig(Map<String, String> config) {
            this.config = config;
            return this;
        }

        public Builder setTopicConfig(String key, String value) {
            this.config.put(key, value);
            return this;
        }

        public TopicSpec build() {
            TopicSpec topicSpec = new TopicSpec();
            Objects.requireNonNull(this.name, "topic name is required");
            topicSpec.setName(this.name);
            topicSpec.setPartitions(this.partitions);
            topicSpec.setReplicationFactor(this.replicationFactor);
            topicSpec.setConfig((Map<String, String>)ImmutableMap.copyOf(this.config));
            return topicSpec;
        }
    }

    public static class Topics {
        public List<TopicSpec> topics;

        public List<TopicSpec> topics() {
            return this.topics;
        }

        public void setTopics(List<TopicSpec> topics) {
            this.topics = topics;
        }

        public String toString() {
            return "Topics{topics=" + this.topics + '}';
        }
    }
}

