/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.logging.processing;

import io.confluent.ksql.logging.processing.LoggingSerdeUtil;
import io.confluent.ksql.logging.processing.ProcessingLogConfig;
import io.confluent.ksql.logging.processing.ProcessingLogMessageSchema;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;

public class SerializationError<T>
implements ProcessingLogger.ErrorMessage {
    private final Throwable exception;
    private final Optional<T> record;
    private final String topic;
    private final boolean isKey;

    public SerializationError(Throwable exception, Optional<T> record, String topic, boolean isKey) {
        this.exception = Objects.requireNonNull(exception, "exception");
        this.record = Objects.requireNonNull(record, "record");
        this.topic = Objects.requireNonNull(topic, "topic");
        this.isKey = isKey;
    }

    public SchemaAndValue get(ProcessingLogConfig config) {
        Struct struct = new Struct(ProcessingLogMessageSchema.PROCESSING_LOG_SCHEMA).put("type", (Object)ProcessingLogMessageSchema.MessageType.SERIALIZATION_ERROR.getTypeId()).put("serializationError", (Object)this.serializationError(config));
        return new SchemaAndValue(ProcessingLogMessageSchema.PROCESSING_LOG_SCHEMA, (Object)struct);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializationError that = (SerializationError)o;
        return Objects.equals(this.exception, that.exception) && Objects.equals(this.record, that.record) && Objects.equals(this.topic, that.topic) && this.isKey == that.isKey;
    }

    public int hashCode() {
        return Objects.hash(this.exception, this.record, this.topic, this.isKey);
    }

    private Struct serializationError(ProcessingLogConfig config) {
        Struct serializationError = new Struct(ProcessingLogMessageSchema.MessageType.SERIALIZATION_ERROR.getSchema()).put("target", (Object)LoggingSerdeUtil.getRecordComponent(this.isKey)).put("errorMessage", (Object)this.exception.getMessage()).put("cause", LoggingSerdeUtil.getCause(this.exception)).put("topic", (Object)this.topic);
        if (config.getBoolean(ProcessingLogConfig.INCLUDE_ROWS).booleanValue()) {
            serializationError.put("record", this.record.map(Object::toString).orElse(null));
        }
        return serializationError;
    }
}

