/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.GenericDeserializer;
import io.confluent.ksql.serde.GenericSerdeFactory;
import io.confluent.ksql.serde.GenericSerializer;
import io.confluent.ksql.serde.ValueSerdeFactory;
import io.confluent.ksql.serde.tracked.TrackedCallback;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;

public final class GenericRowSerDe
implements ValueSerdeFactory {
    private static final int ADDITIONAL_CAPACITY = 4;
    private final GenericSerdeFactory innerFactory;
    private final Optional<String> queryId;

    public GenericRowSerDe() {
        this(new GenericSerdeFactory(), Optional.empty());
    }

    public GenericRowSerDe(String queryId) {
        this(new GenericSerdeFactory(), Optional.of(queryId));
    }

    @VisibleForTesting
    GenericRowSerDe(GenericSerdeFactory innerFactory, Optional<String> queryId) {
        this.innerFactory = Objects.requireNonNull(innerFactory, "innerFactory");
        this.queryId = queryId;
    }

    public static Serde<GenericRow> from(FormatInfo format, PersistenceSchema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> schemaRegistryClientFactory, String loggerNamePrefix, ProcessingLogContext processingLogContext) {
        return new GenericRowSerDe().create(format, schema, ksqlConfig, schemaRegistryClientFactory, loggerNamePrefix, processingLogContext, Optional.empty());
    }

    @Override
    public Serde<GenericRow> create(FormatInfo format, PersistenceSchema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srClientFactory, String loggerNamePrefix, ProcessingLogContext processingLogContext, Optional<TrackedCallback> tracker) {
        Serde<List<?>> formatSerde = this.innerFactory.createFormatSerde("Value", format, schema, ksqlConfig, srClientFactory, false);
        Serde<GenericRow> genericRowSerde = GenericRowSerDe.toGenericRowSerde(formatSerde, schema);
        Serde<GenericRow> loggingSerde = this.innerFactory.wrapInLoggingSerde(genericRowSerde, loggerNamePrefix, processingLogContext, this.queryId);
        Serde<GenericRow> serde = tracker.map(callback -> this.innerFactory.wrapInTrackingSerde(loggingSerde, (TrackedCallback)callback)).orElse(loggingSerde);
        serde.configure(Collections.emptyMap(), false);
        return serde;
    }

    private static Serde<GenericRow> toGenericRowSerde(Serde<List<?>> innerSerde, PersistenceSchema schema) {
        GenericSerializer<GenericRow> serializer = new GenericSerializer<GenericRow>(GenericRow::values, innerSerde.serializer(), schema.columns().size());
        GenericDeserializer<GenericRow> deserializer = new GenericDeserializer<GenericRow>(GenericRowSerDe::createGenericRow, innerSerde.deserializer(), schema.columns().size());
        return Serdes.serdeFrom(serializer, deserializer);
    }

    private static GenericRow createGenericRow(List<?> values) {
        GenericRow row = new GenericRow(values.size() + 4);
        row.appendAll(values);
        return row;
    }
}

