/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.github.erosb.jsonsKema.JsonArray;
import com.github.erosb.jsonsKema.JsonBoolean;
import com.github.erosb.jsonsKema.JsonNull;
import com.github.erosb.jsonsKema.JsonNumber;
import com.github.erosb.jsonsKema.JsonString;
import com.github.erosb.jsonsKema.SourceLocation;
import com.github.erosb.jsonsKema.UnknownSource;
import io.confluent.kafka.schemaregistry.json.jackson.JsonSkemaObjectDeserializer;
import java.io.IOException;
import java.util.ArrayList;

public class JsonSkemaArrayDeserializer
extends StdDeserializer<JsonArray> {
    private static final long serialVersionUID = 1L;
    public static final JsonSkemaArrayDeserializer instance = new JsonSkemaArrayDeserializer();

    public JsonSkemaArrayDeserializer() {
        super(JsonArray.class);
    }

    public JsonArray deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t;
        if (!p.isExpectedStartArrayToken()) {
            JsonToken t2 = p.currentToken();
            return (JsonArray)ctxt.handleUnexpectedToken(this.handledType(), t2, p, "Unexpected token (%s), expected START_ARRAY for %s value", new Object[]{t2, ClassUtil.nameOf((Class)this.handledType())});
        }
        ArrayList<Object> elements = new ArrayList<Object>();
        block11: while ((t = p.nextToken()) != JsonToken.END_ARRAY) {
            switch (t) {
                case START_ARRAY: {
                    elements.add(this.deserialize(p, ctxt));
                    continue block11;
                }
                case START_OBJECT: {
                    elements.add(JsonSkemaObjectDeserializer.instance.deserialize(p, ctxt));
                    continue block11;
                }
                case VALUE_STRING: {
                    elements.add(new JsonString(p.getText(), (SourceLocation)UnknownSource.INSTANCE));
                    continue block11;
                }
                case VALUE_NULL: {
                    elements.add(new JsonNull((SourceLocation)UnknownSource.INSTANCE));
                    continue block11;
                }
                case VALUE_TRUE: {
                    elements.add(new JsonBoolean(true, (SourceLocation)UnknownSource.INSTANCE));
                    continue block11;
                }
                case VALUE_FALSE: {
                    elements.add(new JsonBoolean(false, (SourceLocation)UnknownSource.INSTANCE));
                    continue block11;
                }
                case VALUE_NUMBER_INT: {
                    Number num = p.getNumberValue();
                    if (num instanceof Byte || num instanceof Short) {
                        num = num.intValue();
                    }
                    elements.add(new JsonNumber(num, (SourceLocation)UnknownSource.INSTANCE));
                    continue block11;
                }
                case VALUE_NUMBER_FLOAT: {
                    elements.add(new JsonNumber(p.getNumberValue(), (SourceLocation)UnknownSource.INSTANCE));
                    continue block11;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object o = p.getEmbeddedObject();
                    if (o instanceof byte[]) {
                        elements.add(new JsonString(p.getText(), (SourceLocation)UnknownSource.INSTANCE));
                        continue block11;
                    }
                    return (JsonArray)ctxt.handleUnexpectedToken(this.handledType(), p);
                }
            }
            return (JsonArray)ctxt.handleUnexpectedToken(this.handledType(), p);
        }
        return new JsonArray(elements, (SourceLocation)UnknownSource.INSTANCE);
    }
}

