/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;
import org.bouncycastle.jsse.BCX509ExtendedKeyManager;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.provider.ImportX509KeyManager;
import org.bouncycastle.jsse.provider.ProvX509Key;
import org.bouncycastle.jsse.provider.TransportData;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ImportX509KeyManager_4
extends BCX509ExtendedKeyManager
implements ImportX509KeyManager {
    final X509KeyManager x509KeyManager;

    ImportX509KeyManager_4(X509KeyManager x509KeyManager) {
        this.x509KeyManager = x509KeyManager;
    }

    @Override
    public X509KeyManager unwrap() {
        return this.x509KeyManager;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.x509KeyManager.chooseClientAlias(keyType, issuers, socket);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.x509KeyManager.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.x509KeyManager.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.x509KeyManager.getClientAliases(keyType, issuers);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.x509KeyManager.getPrivateKey(alias);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.x509KeyManager.getServerAliases(keyType, issuers);
    }

    @Override
    protected BCX509Key getKeyBC(String keyType, String alias) {
        return ProvX509Key.from(this.x509KeyManager, keyType, alias);
    }

    @Override
    protected BCX509Key validateKeyBC(boolean forServer, String keyType, String alias, Socket socket) {
        return ProvX509Key.validate(this.x509KeyManager, forServer, keyType, alias, TransportData.from(socket));
    }
}

