/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.client;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import java.util.Objects;

public final class BufferCopyStream
implements ReadStream<Buffer> {
    private final ReadStream<Buffer> source;

    public BufferCopyStream(ReadStream<Buffer> source) {
        Objects.requireNonNull(source, "Source must be non-null");
        this.source = source;
    }

    public ReadStream<Buffer> handler(Handler<Buffer> handler) {
        if (handler == null) {
            this.source.handler(null);
        } else {
            this.source.handler(event -> handler.handle((Object)event.copy()));
        }
        return this;
    }

    public ReadStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
        this.source.exceptionHandler(handler);
        return this;
    }

    public ReadStream<Buffer> pause() {
        this.source.pause();
        return this;
    }

    public ReadStream<Buffer> resume() {
        this.source.resume();
        return this;
    }

    public ReadStream<Buffer> fetch(long amount) {
        this.source.fetch(amount);
        return this;
    }

    public ReadStream<Buffer> endHandler(Handler<Void> endHandler) {
        this.source.endHandler(endHandler);
        return this;
    }
}

