/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.jwt;

import com.google.crypto.tink.AccessesPartialKey;
import com.google.crypto.tink.InsecureSecretKeyAccess;
import com.google.crypto.tink.Key;
import com.google.crypto.tink.jwt.JwtRsaSsaPkcs1Parameters;
import com.google.crypto.tink.jwt.JwtRsaSsaPkcs1PublicKey;
import com.google.crypto.tink.jwt.JwtSignaturePrivateKey;
import com.google.crypto.tink.util.SecretBigInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.RestrictedApi;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.util.Optional;

public final class JwtRsaSsaPkcs1PrivateKey
extends JwtSignaturePrivateKey {
    private final JwtRsaSsaPkcs1PublicKey publicKey;
    private final SecretBigInteger d;
    private final SecretBigInteger p;
    private final SecretBigInteger q;
    private final SecretBigInteger dP;
    private final SecretBigInteger dQ;
    private final SecretBigInteger qInv;

    private JwtRsaSsaPkcs1PrivateKey(JwtRsaSsaPkcs1PublicKey publicKey, SecretBigInteger p, SecretBigInteger q, SecretBigInteger d, SecretBigInteger dP, SecretBigInteger dQ, SecretBigInteger qInv) {
        this.publicKey = publicKey;
        this.p = p;
        this.q = q;
        this.d = d;
        this.dP = dP;
        this.dQ = dQ;
        this.qInv = qInv;
    }

    @RestrictedApi(explanation="Accessing parts of keys can produce unexpected incompatibilities, annotate the function with @AccessesPartialKey", link="https://developers.google.com/tink/design/access_control#accessing_partial_keys", allowedOnPath=".*Test\\.java", allowlistAnnotations={AccessesPartialKey.class})
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public JwtRsaSsaPkcs1Parameters getParameters() {
        return this.publicKey.getParameters();
    }

    @Override
    public JwtRsaSsaPkcs1PublicKey getPublicKey() {
        return this.publicKey;
    }

    @RestrictedApi(explanation="Accessing parts of keys can produce unexpected incompatibilities, annotate the function with @AccessesPartialKey", link="https://developers.google.com/tink/design/access_control#accessing_partial_keys", allowedOnPath=".*Test\\.java", allowlistAnnotations={AccessesPartialKey.class})
    public SecretBigInteger getPrimeP() {
        return this.p;
    }

    @RestrictedApi(explanation="Accessing parts of keys can produce unexpected incompatibilities, annotate the function with @AccessesPartialKey", link="https://developers.google.com/tink/design/access_control#accessing_partial_keys", allowedOnPath=".*Test\\.java", allowlistAnnotations={AccessesPartialKey.class})
    public SecretBigInteger getPrimeQ() {
        return this.q;
    }

    public SecretBigInteger getPrivateExponent() {
        return this.d;
    }

    public SecretBigInteger getPrimeExponentP() {
        return this.dP;
    }

    public SecretBigInteger getPrimeExponentQ() {
        return this.dQ;
    }

    public SecretBigInteger getCrtCoefficient() {
        return this.qInv;
    }

    @Override
    public boolean equalsKey(Key o) {
        if (!(o instanceof JwtRsaSsaPkcs1PrivateKey)) {
            return false;
        }
        JwtRsaSsaPkcs1PrivateKey that = (JwtRsaSsaPkcs1PrivateKey)o;
        return that.publicKey.equalsKey(this.publicKey) && this.p.equalsSecretBigInteger(that.p) && this.q.equalsSecretBigInteger(that.q) && this.d.equalsSecretBigInteger(that.d) && this.dP.equalsSecretBigInteger(that.dP) && this.dQ.equalsSecretBigInteger(that.dQ) && this.qInv.equalsSecretBigInteger(that.qInv);
    }

    public static class Builder {
        private Optional<JwtRsaSsaPkcs1PublicKey> publicKey = Optional.empty();
        private Optional<SecretBigInteger> d = Optional.empty();
        private Optional<SecretBigInteger> p = Optional.empty();
        private Optional<SecretBigInteger> q = Optional.empty();
        private Optional<SecretBigInteger> dP = Optional.empty();
        private Optional<SecretBigInteger> dQ = Optional.empty();
        private Optional<SecretBigInteger> qInv = Optional.empty();
        private static final int PRIME_CERTAINTY = 10;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder setPublicKey(JwtRsaSsaPkcs1PublicKey publicKey) {
            this.publicKey = Optional.of(publicKey);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPrimes(SecretBigInteger p, SecretBigInteger q) {
            this.p = Optional.of(p);
            this.q = Optional.of(q);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPrivateExponent(SecretBigInteger d) {
            this.d = Optional.of(d);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPrimeExponents(SecretBigInteger dP, SecretBigInteger dQ) {
            this.dP = Optional.of(dP);
            this.dQ = Optional.of(dQ);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCrtCoefficient(SecretBigInteger qInv) {
            this.qInv = Optional.of(qInv);
            return this;
        }

        @AccessesPartialKey
        public JwtRsaSsaPkcs1PrivateKey build() throws GeneralSecurityException {
            if (!this.publicKey.isPresent()) {
                throw new GeneralSecurityException("Cannot build without a RSA SSA PKCS1 public key");
            }
            if (!this.p.isPresent() || !this.q.isPresent()) {
                throw new GeneralSecurityException("Cannot build without prime factors");
            }
            if (!this.d.isPresent()) {
                throw new GeneralSecurityException("Cannot build without private exponent");
            }
            if (!this.dP.isPresent() || !this.dQ.isPresent()) {
                throw new GeneralSecurityException("Cannot build without prime exponents");
            }
            if (!this.qInv.isPresent()) {
                throw new GeneralSecurityException("Cannot build without CRT coefficient");
            }
            BigInteger e = this.publicKey.get().getParameters().getPublicExponent();
            BigInteger n = this.publicKey.get().getModulus();
            BigInteger ip = this.p.get().getBigInteger(InsecureSecretKeyAccess.get());
            BigInteger iq = this.q.get().getBigInteger(InsecureSecretKeyAccess.get());
            BigInteger id = this.d.get().getBigInteger(InsecureSecretKeyAccess.get());
            BigInteger idP = this.dP.get().getBigInteger(InsecureSecretKeyAccess.get());
            BigInteger idQ = this.dQ.get().getBigInteger(InsecureSecretKeyAccess.get());
            BigInteger iqInv = this.qInv.get().getBigInteger(InsecureSecretKeyAccess.get());
            if (!ip.isProbablePrime(10)) {
                throw new GeneralSecurityException("p is not a prime");
            }
            if (!iq.isProbablePrime(10)) {
                throw new GeneralSecurityException("q is not a prime");
            }
            if (!ip.multiply(iq).equals(n)) {
                throw new GeneralSecurityException("Prime p times prime q is not equal to the public key's modulus");
            }
            BigInteger pMinusOne = ip.subtract(BigInteger.ONE);
            BigInteger qMinusOne = iq.subtract(BigInteger.ONE);
            BigInteger lambda = pMinusOne.divide(pMinusOne.gcd(qMinusOne)).multiply(qMinusOne);
            if (!e.multiply(id).mod(lambda).equals(BigInteger.ONE)) {
                throw new GeneralSecurityException("D is invalid.");
            }
            if (!e.multiply(idP).mod(pMinusOne).equals(BigInteger.ONE)) {
                throw new GeneralSecurityException("dP is invalid.");
            }
            if (!e.multiply(idQ).mod(qMinusOne).equals(BigInteger.ONE)) {
                throw new GeneralSecurityException("dQ is invalid.");
            }
            if (!iq.multiply(iqInv).mod(ip).equals(BigInteger.ONE)) {
                throw new GeneralSecurityException("qInv is invalid.");
            }
            return new JwtRsaSsaPkcs1PrivateKey(this.publicKey.get(), this.p.get(), this.q.get(), this.d.get(), this.dP.get(), this.dQ.get(), this.qInv.get());
        }
    }
}

