/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.completable;

import io.confluent.shaded.io.reactivex.Completable;
import io.confluent.shaded.io.reactivex.CompletableObserver;
import io.confluent.shaded.io.reactivex.CompletableSource;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.internal.disposables.SequentialDisposable;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableConcatArray
extends Completable {
    final CompletableSource[] sources;

    public CompletableConcatArray(CompletableSource[] sources) {
        this.sources = sources;
    }

    @Override
    public void subscribeActual(CompletableObserver observer) {
        ConcatInnerObserver inner = new ConcatInnerObserver(observer, this.sources);
        observer.onSubscribe(inner.sd);
        inner.next();
    }

    static final class ConcatInnerObserver
    extends AtomicInteger
    implements CompletableObserver {
        private static final long serialVersionUID = -7965400327305809232L;
        final CompletableObserver downstream;
        final CompletableSource[] sources;
        int index;
        final SequentialDisposable sd;

        ConcatInnerObserver(CompletableObserver actual, CompletableSource[] sources) {
            this.downstream = actual;
            this.sources = sources;
            this.sd = new SequentialDisposable();
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.sd.replace(d);
        }

        @Override
        public void onError(Throwable e) {
            this.downstream.onError(e);
        }

        @Override
        public void onComplete() {
            this.next();
        }

        void next() {
            if (this.sd.isDisposed()) {
                return;
            }
            if (this.getAndIncrement() != 0) {
                return;
            }
            CompletableSource[] a = this.sources;
            do {
                int idx;
                if (this.sd.isDisposed()) {
                    return;
                }
                ++this.index;
                if (idx == a.length) {
                    this.downstream.onComplete();
                    return;
                }
                a[idx].subscribe(this);
            } while (this.decrementAndGet() != 0);
        }
    }
}

