/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.CredentialBuilderBase;
import com.azure.identity.implementation.IdentityClientOptions;

public final class CredentialBuilderBaseHelper {
    private static final ClientLogger LOGGER = new ClientLogger(CredentialBuilderBaseHelper.class);
    private static CredentialBuilderBaseAccessor accessor;

    private CredentialBuilderBaseHelper() {
    }

    public static void setAccessor(CredentialBuilderBaseAccessor newAccessor) {
        if (accessor != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("Accessor must be non-null"));
        }
        accessor = newAccessor;
    }

    public static CredentialBuilderBaseAccessor getAccessor() {
        if (accessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("CredentialBuilderBaseHelper must be initialized"));
        }
        return accessor;
    }

    public static IdentityClientOptions getClientOptions(CredentialBuilderBase<?> builder) {
        return CredentialBuilderBaseHelper.getAccessor().getClientOptions(builder);
    }

    public static interface CredentialBuilderBaseAccessor {
        public IdentityClientOptions getClientOptions(CredentialBuilderBase<?> var1);
    }
}

