/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;
import org.apache.kafka.coordinator.group.GroupMetadataManager;
import org.apache.kafka.coordinator.group.OffsetMetadataManager;
import org.apache.kafka.coordinator.group.Record;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.coordinator.group.runtime.CoordinatorResult;
import org.apache.kafka.coordinator.group.runtime.CoordinatorShard;
import org.apache.kafka.coordinator.group.runtime.CoordinatorShardBuilder;
import org.apache.kafka.coordinator.group.runtime.CoordinatorTimer;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.timeline.SnapshotRegistry;

public class GroupCoordinatorShard
implements CoordinatorShard<Record> {
    private final GroupMetadataManager groupMetadataManager;
    private final OffsetMetadataManager offsetMetadataManager;

    GroupCoordinatorShard(GroupMetadataManager groupMetadataManager, OffsetMetadataManager offsetMetadataManager) {
        this.groupMetadataManager = groupMetadataManager;
        this.offsetMetadataManager = offsetMetadataManager;
    }

    public CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> consumerGroupHeartbeat(RequestContext context, ConsumerGroupHeartbeatRequestData request) {
        return this.groupMetadataManager.consumerGroupHeartbeat(context, request);
    }

    public CoordinatorResult<Void, Record> genericGroupJoin(RequestContext context, JoinGroupRequestData request, CompletableFuture<JoinGroupResponseData> responseFuture) {
        return this.groupMetadataManager.genericGroupJoin(context, request, responseFuture);
    }

    public CoordinatorResult<Void, Record> genericGroupSync(RequestContext context, SyncGroupRequestData request, CompletableFuture<SyncGroupResponseData> responseFuture) {
        return this.groupMetadataManager.genericGroupSync(context, request, responseFuture);
    }

    public HeartbeatResponseData genericGroupHeartbeat(RequestContext context, HeartbeatRequestData request) {
        return this.groupMetadataManager.genericGroupHeartbeat(context, request);
    }

    public CoordinatorResult<OffsetCommitResponseData, Record> commitOffset(RequestContext context, OffsetCommitRequestData request) throws ApiException {
        return this.offsetMetadataManager.commitOffset(context, request);
    }

    @Override
    public void onLoaded(MetadataImage newImage) {
        MetadataDelta emptyDelta = new MetadataDelta(newImage);
        this.groupMetadataManager.onNewMetadataImage(newImage, emptyDelta);
        this.offsetMetadataManager.onNewMetadataImage(newImage, emptyDelta);
        this.groupMetadataManager.onLoaded();
    }

    @Override
    public void onNewMetadataImage(MetadataImage newImage, MetadataDelta delta) {
        this.groupMetadataManager.onNewMetadataImage(newImage, delta);
        this.offsetMetadataManager.onNewMetadataImage(newImage, delta);
    }

    private ApiMessage messageOrNull(ApiMessageAndVersion apiMessageAndVersion) {
        if (apiMessageAndVersion == null) {
            return null;
        }
        return apiMessageAndVersion.message();
    }

    @Override
    public void replay(Record record) throws RuntimeException {
        ApiMessageAndVersion key = record.key();
        ApiMessageAndVersion value = record.value();
        switch (key.version()) {
            case 0: 
            case 1: {
                this.offsetMetadataManager.replay((OffsetCommitKey)key.message(), (OffsetCommitValue)this.messageOrNull(value));
                break;
            }
            case 2: {
                this.groupMetadataManager.replay((GroupMetadataKey)key.message(), (GroupMetadataValue)this.messageOrNull(value));
                break;
            }
            case 3: {
                this.groupMetadataManager.replay((ConsumerGroupMetadataKey)key.message(), (ConsumerGroupMetadataValue)this.messageOrNull(value));
                break;
            }
            case 4: {
                this.groupMetadataManager.replay((ConsumerGroupPartitionMetadataKey)key.message(), (ConsumerGroupPartitionMetadataValue)this.messageOrNull(value));
                break;
            }
            case 5: {
                this.groupMetadataManager.replay((ConsumerGroupMemberMetadataKey)key.message(), (ConsumerGroupMemberMetadataValue)this.messageOrNull(value));
                break;
            }
            case 6: {
                this.groupMetadataManager.replay((ConsumerGroupTargetAssignmentMetadataKey)key.message(), (ConsumerGroupTargetAssignmentMetadataValue)this.messageOrNull(value));
                break;
            }
            case 7: {
                this.groupMetadataManager.replay((ConsumerGroupTargetAssignmentMemberKey)key.message(), (ConsumerGroupTargetAssignmentMemberValue)this.messageOrNull(value));
                break;
            }
            case 8: {
                this.groupMetadataManager.replay((ConsumerGroupCurrentMemberAssignmentKey)key.message(), (ConsumerGroupCurrentMemberAssignmentValue)this.messageOrNull(value));
                break;
            }
            default: {
                throw new IllegalStateException("Received an unknown record type " + key.version() + " in " + record);
            }
        }
    }

    public static class Builder
    implements CoordinatorShardBuilder<GroupCoordinatorShard, Record> {
        private final GroupCoordinatorConfig config;
        private LogContext logContext;
        private SnapshotRegistry snapshotRegistry;
        private Time time;
        private CoordinatorTimer<Void, Record> timer;

        public Builder(GroupCoordinatorConfig config) {
            this.config = config;
        }

        @Override
        public CoordinatorShardBuilder<GroupCoordinatorShard, Record> withLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        @Override
        public CoordinatorShardBuilder<GroupCoordinatorShard, Record> withTime(Time time) {
            this.time = time;
            return this;
        }

        @Override
        public CoordinatorShardBuilder<GroupCoordinatorShard, Record> withTimer(CoordinatorTimer<Void, Record> timer) {
            this.timer = timer;
            return this;
        }

        @Override
        public CoordinatorShardBuilder<GroupCoordinatorShard, Record> withSnapshotRegistry(SnapshotRegistry snapshotRegistry) {
            this.snapshotRegistry = snapshotRegistry;
            return this;
        }

        @Override
        public GroupCoordinatorShard build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            if (this.config == null) {
                throw new IllegalArgumentException("Config must be set.");
            }
            if (this.snapshotRegistry == null) {
                throw new IllegalArgumentException("SnapshotRegistry must be set.");
            }
            if (this.time == null) {
                throw new IllegalArgumentException("Time must be set.");
            }
            if (this.timer == null) {
                throw new IllegalArgumentException("Timer must be set.");
            }
            GroupMetadataManager groupMetadataManager = new GroupMetadataManager.Builder().withLogContext(this.logContext).withSnapshotRegistry(this.snapshotRegistry).withTime(this.time).withTimer(this.timer).withConsumerGroupAssignors(this.config.consumerGroupAssignors).withConsumerGroupMaxSize(this.config.consumerGroupMaxSize).withConsumerGroupHeartbeatInterval(this.config.consumerGroupHeartbeatIntervalMs).withGenericGroupInitialRebalanceDelayMs(this.config.genericGroupInitialRebalanceDelayMs).withGenericGroupNewMemberJoinTimeoutMs(this.config.genericGroupNewMemberJoinTimeoutMs).withGenericGroupMinSessionTimeoutMs(this.config.genericGroupMinSessionTimeoutMs).withGenericGroupMaxSessionTimeoutMs(this.config.genericGroupMaxSessionTimeoutMs).build();
            OffsetMetadataManager offsetMetadataManager = new OffsetMetadataManager.Builder().withLogContext(this.logContext).withSnapshotRegistry(this.snapshotRegistry).withTime(this.time).withGroupMetadataManager(groupMetadataManager).withOffsetMetadataMaxSize(this.config.offsetMetadataMaxSize).build();
            return new GroupCoordinatorShard(groupMetadataManager, offsetMetadataManager);
        }
    }
}

