/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.oauth;

import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.auth.store.data.IdentityPoolKey;
import io.confluent.security.auth.store.data.IdentityPoolValueV2;
import io.confluent.security.auth.store.data.JwtIssuerKeyV2;
import io.confluent.security.auth.store.data.JwtIssuerValue;
import io.confluent.security.authentication.oidc.RefreshTokenInfo;
import io.confluent.security.store.KeyValueStore;
import io.confluent.security.store.MetadataStoreStatus;
import io.confluent.security.trustservice.store.TrustCache;
import io.confluent.security.trustservice.store.data.IdentityPool;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.jose4j.jwk.JsonWebKeySet;

public class MockTrustCache
implements TrustCache,
KeyValueStore<AuthKey, AuthValue> {
    private final Map<String, JsonWebKeySet> jsonWebKeys;
    private final Map<String, IdentityPool> identityPools = new ConcurrentHashMap<String, IdentityPool>();

    public MockTrustCache() {
        this.jsonWebKeys = new ConcurrentHashMap<String, JsonWebKeySet>();
    }

    public AuthValue get(AuthKey key) {
        switch (key.entryType()) {
            case JWT_ISSUER: {
                JsonWebKeySet jwks = this.jsonWebKeys.get(((JwtIssuerKeyV2)key).cacheKey());
                return jwks == null ? null : new JwtIssuerValue(jwks);
            }
            case IDENTITY_POOL: {
                IdentityPoolKey identityPoolKey = (IdentityPoolKey)key;
                IdentityPool identityPool = this.identityPools.get(identityPoolKey.poolId());
                return identityPool == null ? null : new IdentityPoolValueV2(identityPool);
            }
        }
        throw new IllegalArgumentException("Unknown key type " + key.entryType());
    }

    public AuthValue put(AuthKey key, AuthValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        if (key.entryType() != value.entryType()) {
            throw new CorruptRecordException("Invalid record with key=" + key + ", value=" + value);
        }
        switch (key.entryType()) {
            case JWT_ISSUER: {
                return this.updateJwtIssuer((JwtIssuerKeyV2)key, (JwtIssuerValue)value);
            }
            case IDENTITY_POOL: {
                return this.updateIdentityPool((IdentityPoolKey)key, (IdentityPoolValueV2)value);
            }
        }
        throw new IllegalArgumentException("Unknown key type " + key.entryType());
    }

    private JwtIssuerValue updateJwtIssuer(JwtIssuerKeyV2 key, JwtIssuerValue value) {
        JsonWebKeySet oldValue = this.jsonWebKeys.put(key.cacheKey(), value.keys());
        return oldValue == null ? null : new JwtIssuerValue(oldValue);
    }

    private IdentityPoolValueV2 updateIdentityPool(IdentityPoolKey key, IdentityPoolValueV2 value) {
        IdentityPool oldValue = this.identityPools.put(key.poolId(), new IdentityPool(key.poolId(), value.version(), value.issuer(), value.jwksEndpoint(), value.subjectClaim(), value.serviceAccount(), value.policy(), value.orgId()));
        return oldValue == null ? null : new IdentityPoolValueV2(oldValue);
    }

    public AuthValue remove(AuthKey key) {
        switch (key.entryType()) {
            case JWT_ISSUER: {
                JsonWebKeySet oldJwks = this.jsonWebKeys.remove(((JwtIssuerKeyV2)key).cacheKey());
                return oldJwks == null ? null : new JwtIssuerValue(oldJwks);
            }
            case IDENTITY_POOL: {
                IdentityPool oldIdentityPool = this.identityPools.remove(((IdentityPoolKey)key).poolId());
                return oldIdentityPool == null ? null : new IdentityPoolValueV2(oldIdentityPool);
            }
        }
        throw new IllegalArgumentException("Unknown key type " + key.entryType());
    }

    public Map<? extends AuthKey, ? extends AuthValue> map(String entryType) {
        return null;
    }

    public void fail(int partition, String errorMessage) {
    }

    public MetadataStoreStatus status(int partition) {
        return null;
    }

    public Map<String, JsonWebKeySet> jsonWebKeySets() {
        return Collections.unmodifiableMap(this.jsonWebKeys);
    }

    public JsonWebKeySet jsonWebKeySet(String jwtIssuer) {
        return this.jsonWebKeys.get(jwtIssuer);
    }

    public IdentityPool identityPool(String poolId) {
        return this.identityPools.get(poolId);
    }

    public Map<String, IdentityPool> identityPools() {
        return Collections.unmodifiableMap(this.identityPools);
    }

    public RefreshTokenInfo refreshTokenInfo(String refreshTokenKey) {
        return null;
    }
}

