/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.token;

import io.confluent.kafka.clients.plugins.auth.jwt.PublicKeyJwks;
import io.confluent.security.auth.client.provider.BuiltInAuthProviders;
import io.confluent.security.auth.client.rest.RestClient;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenBearerServerLoginCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(TokenBearerServerLoginCallbackHandler.class);
    private final Function<Map<String, String>, RestClient> restClientCreator;
    private RestClient restClient;
    private boolean configured = false;
    private boolean tokenRequired = false;
    private static final String KEY_OPTION = "publicKeyPath";
    private static final String LOGIN_SERVER_OPTION = "metadataServerUrls";
    private static final String USER_OPTION = "username";
    private static final String PASSWORD_OPTION = "password";

    public TokenBearerServerLoginCallbackHandler() {
        this(loginConfigs -> new RestClient(loginConfigs));
    }

    TokenBearerServerLoginCallbackHandler(Function<Map<String, String>, RestClient> restClientCreator) {
        this.restClientCreator = Objects.requireNonNull(restClientCreator);
    }

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        Map<String, String> moduleOptions = this.jaasConfigDef(saslMechanism, jaasConfigEntries);
        String publicKeyPath = moduleOptions.getOrDefault(KEY_OPTION, "");
        TokenBearerServerLoginCallbackHandler.validatePublicKey(publicKeyPath);
        String loginServer = moduleOptions.getOrDefault(LOGIN_SERVER_OPTION, "");
        String user = moduleOptions.getOrDefault(USER_OPTION, "");
        String pass = moduleOptions.getOrDefault(PASSWORD_OPTION, "");
        if (user.isEmpty()) {
            this.configured = true;
            return;
        }
        if (loginServer.isEmpty()) {
            throw new ConfigException(String.format("Missing required configuration %s which has no default value.", LOGIN_SERVER_OPTION));
        }
        if (pass.isEmpty()) {
            throw new ConfigException("Option username specified with an empty password");
        }
        HashMap<String, String> loginConfigs = new HashMap<String, String>();
        loginConfigs.put("confluent.metadata.bootstrap.server.urls", loginServer);
        loginConfigs.put("confluent.metadata.http.auth.credentials.provider", BuiltInAuthProviders.HttpCredentialProviders.BASIC.name());
        loginConfigs.put("confluent.metadata.basic.auth.credentials.provider", BuiltInAuthProviders.BasicAuthCredentialProviders.USER_INFO.name());
        loginConfigs.put("confluent.metadata.basic.auth.user.info", user + ":" + pass);
        this.restClient = this.restClientCreator.apply(loginConfigs);
        this.configured = true;
        this.tokenRequired = true;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (!this.configured) {
            throw new IllegalStateException("Callback handler not configured");
        }
        for (Callback callback : callbacks) {
            if (callback instanceof OAuthBearerTokenCallback) {
                try {
                    this.attachAuthToken((OAuthBearerTokenCallback)callback);
                    continue;
                }
                catch (KafkaException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    private void attachAuthToken(OAuthBearerTokenCallback callback) {
        if (callback.token() != null) {
            throw new IllegalArgumentException("Callback had an Authentication Token already");
        }
        if (!this.tokenRequired) {
            return;
        }
        callback.token(this.restClient.login());
    }

    public void close() {
        if (this.restClient != null) {
            this.restClient.close();
        }
    }

    public static void validatePublicKey(String publicKeyPath) {
        try {
            if (publicKeyPath.isEmpty()) {
                log.error("No publicKeyPath was provided in the JAAS config!");
                throw new ConfigException("publicKeyPath option must be set in JAAS config!");
            }
            PublicKeyJwks.loadPublicKey((String)publicKeyPath);
        }
        catch (IOException e) {
            String errMsg = String.format("Could not load the public key from %s", publicKeyPath);
            log.error(errMsg);
            throw new ConfigException(errMsg, (Object)e);
        }
    }

    private Map<String, String> jaasConfigDef(String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        JaasOptionsUtils.validateOAuthMechanismAndNonNullJaasConfig((String)saslMechanism, jaasConfigEntries);
        return Collections.unmodifiableMap(jaasConfigEntries.get(0).getOptions());
    }
}

