/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import io.confluent.common.security.jetty.JwtLoginService;
import io.confluent.common.security.jetty.JwtWithFallbackLoginService;
import io.confluent.common.security.jetty.MdsBasicLoginService;
import io.confluent.common.security.jetty.OAuthOrBasicAuthenticator;
import io.confluent.common.security.jetty.initializer.InstallBearerOrBasicSecurityHandler;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtAuthenticator;
import io.confluent.ksql.security.VertxAuthenticationPlugin;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.UserIdentity;

public class VertxBearerOrBasicAuthenticationPlugin
extends VertxAuthenticationPlugin {
    @Override
    public void configure(Map<String, ?> config) {
        BasicAuthenticator basicAuthenticator = new BasicAuthenticator(){

            public UserIdentity login(String username, Object password, ServletRequest servletRequest) {
                return this._loginService.login(username, password, servletRequest);
            }
        };
        OAuthOrBasicAuthenticator authenticator = new OAuthOrBasicAuthenticator(basicAuthenticator);
        InstallBearerOrBasicSecurityHandler.BearerConfig bearerConfig = new InstallBearerOrBasicSecurityHandler.BearerConfig(config);
        String realm = bearerConfig.getString("authentication.realm");
        JwtLoginService jwtLoginService = new JwtLoginService(realm, new JwtAuthenticator(bearerConfig.jwtAuthenticatorConfig()));
        MdsBasicLoginService mdsBasicLoginService = new MdsBasicLoginService(config, realm);
        JwtWithFallbackLoginService loginService = new JwtWithFallbackLoginService(jwtLoginService, (LoginService)mdsBasicLoginService);
        this.configure(realm, (Authenticator)authenticator, (LoginService)loginService);
    }

    @Override
    protected boolean validateUser(UserIdentity userIdentity) {
        return true;
    }
}

